/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RetireGrantRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RetireGrantRequest.Builder, RetireGrantRequest> {
    private final String grantToken;

    private final String keyId;

    private final String grantId;

    private RetireGrantRequest(BuilderImpl builder) {
        this.grantToken = builder.grantToken;
        this.keyId = builder.keyId;
        this.grantId = builder.grantId;
    }

    /**
     * <p>
     * Token that identifies the grant to be retired.
     * </p>
     * 
     * @return Token that identifies the grant to be retired.
     */
    public String grantToken() {
        return grantToken;
    }

    /**
     * <p>
     * The Amazon Resource Name of the CMK associated with the grant. Example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name of the CMK associated with the grant. Example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab
     *         </p>
     *         </li>
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * Unique identifier of the grant to retire. The grant ID is returned in the response to a <code>CreateGrant</code>
     * operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123
     * </p>
     * </li>
     * </ul>
     * 
     * @return Unique identifier of the grant to retire. The grant ID is returned in the response to a
     *         <code>CreateGrant</code> operation.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123
     *         </p>
     *         </li>
     */
    public String grantId() {
        return grantId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((grantToken() == null) ? 0 : grantToken().hashCode());
        hashCode = 31 * hashCode + ((keyId() == null) ? 0 : keyId().hashCode());
        hashCode = 31 * hashCode + ((grantId() == null) ? 0 : grantId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetireGrantRequest)) {
            return false;
        }
        RetireGrantRequest other = (RetireGrantRequest) obj;
        if (other.grantToken() == null ^ this.grantToken() == null) {
            return false;
        }
        if (other.grantToken() != null && !other.grantToken().equals(this.grantToken())) {
            return false;
        }
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.grantId() == null ^ this.grantId() == null) {
            return false;
        }
        if (other.grantId() != null && !other.grantId().equals(this.grantId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (grantToken() != null) {
            sb.append("GrantToken: ").append(grantToken()).append(",");
        }
        if (keyId() != null) {
            sb.append("KeyId: ").append(keyId()).append(",");
        }
        if (grantId() != null) {
            sb.append("GrantId: ").append(grantId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RetireGrantRequest> {
        /**
         * <p>
         * Token that identifies the grant to be retired.
         * </p>
         * 
         * @param grantToken
         *        Token that identifies the grant to be retired.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantToken(String grantToken);

        /**
         * <p>
         * The Amazon Resource Name of the CMK associated with the grant. Example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab
         * </p>
         * </li>
         * </ul>
         * 
         * @param keyId
         *        The Amazon Resource Name of the CMK associated with the grant. Example:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * Unique identifier of the grant to retire. The grant ID is returned in the response to a
         * <code>CreateGrant</code> operation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123
         * </p>
         * </li>
         * </ul>
         * 
         * @param grantId
         *        Unique identifier of the grant to retire. The grant ID is returned in the response to a
         *        <code>CreateGrant</code> operation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantId(String grantId);
    }

    private static final class BuilderImpl implements Builder {
        private String grantToken;

        private String keyId;

        private String grantId;

        private BuilderImpl() {
        }

        private BuilderImpl(RetireGrantRequest model) {
            setGrantToken(model.grantToken);
            setKeyId(model.keyId);
            setGrantId(model.grantId);
        }

        public final String getGrantToken() {
            return grantToken;
        }

        @Override
        public final Builder grantToken(String grantToken) {
            this.grantToken = grantToken;
            return this;
        }

        public final void setGrantToken(String grantToken) {
            this.grantToken = grantToken;
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getGrantId() {
            return grantId;
        }

        @Override
        public final Builder grantId(String grantId) {
            this.grantId = grantId;
            return this;
        }

        public final void setGrantId(String grantId) {
            this.grantId = grantId;
        }

        @Override
        public RetireGrantRequest build() {
            return new RetireGrantRequest(this);
        }
    }
}
