/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ReEncryptRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ReEncryptRequest.Builder, ReEncryptRequest> {
    private final ByteBuffer ciphertextBlob;

    private final Map<String, String> sourceEncryptionContext;

    private final String destinationKeyId;

    private final Map<String, String> destinationEncryptionContext;

    private final List<String> grantTokens;

    private ReEncryptRequest(BuilderImpl builder) {
        this.ciphertextBlob = builder.ciphertextBlob;
        this.sourceEncryptionContext = builder.sourceEncryptionContext;
        this.destinationKeyId = builder.destinationKeyId;
        this.destinationEncryptionContext = builder.destinationEncryptionContext;
        this.grantTokens = builder.grantTokens;
    }

    /**
     * <p>
     * Ciphertext of the data to reencrypt.
     * </p>
     * <p>
     * This method will return a new read-only {@code ByteBuffer} each time it is invoked.
     * </p>
     * 
     * @return Ciphertext of the data to reencrypt.
     */
    public ByteBuffer ciphertextBlob() {
        return ciphertextBlob == null ? null : ciphertextBlob.asReadOnlyBuffer();
    }

    /**
     * <p>
     * Encryption context used to encrypt and decrypt the data specified in the <code>CiphertextBlob</code> parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Encryption context used to encrypt and decrypt the data specified in the <code>CiphertextBlob</code>
     *         parameter.
     */
    public Map<String, String> sourceEncryptionContext() {
        return sourceEncryptionContext;
    }

    /**
     * <p>
     * A unique identifier for the CMK to use to reencrypt the data. This value can be a globally unique identifier, a
     * fully specified ARN to either an alias or a key, or an alias name prefixed by "alias/".
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
     * </p>
     * </li>
     * <li>
     * <p>
     * Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
     * </p>
     * </li>
     * <li>
     * <p>
     * Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
     * </p>
     * </li>
     * <li>
     * <p>
     * Alias Name Example - alias/MyAliasName
     * </p>
     * </li>
     * </ul>
     * 
     * @return A unique identifier for the CMK to use to reencrypt the data. This value can be a globally unique
     *         identifier, a fully specified ARN to either an alias or a key, or an alias name prefixed by "alias/".</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Alias Name Example - alias/MyAliasName
     *         </p>
     *         </li>
     */
    public String destinationKeyId() {
        return destinationKeyId;
    }

    /**
     * <p>
     * Encryption context to use when the data is reencrypted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Encryption context to use when the data is reencrypted.
     */
    public Map<String, String> destinationEncryptionContext() {
        return destinationEncryptionContext;
    }

    /**
     * <p>
     * A list of grant tokens.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the
     * <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of grant tokens.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in
     *         the <i>AWS Key Management Service Developer Guide</i>.
     */
    public List<String> grantTokens() {
        return grantTokens;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ciphertextBlob() == null) ? 0 : ciphertextBlob().hashCode());
        hashCode = 31 * hashCode + ((sourceEncryptionContext() == null) ? 0 : sourceEncryptionContext().hashCode());
        hashCode = 31 * hashCode + ((destinationKeyId() == null) ? 0 : destinationKeyId().hashCode());
        hashCode = 31 * hashCode + ((destinationEncryptionContext() == null) ? 0 : destinationEncryptionContext().hashCode());
        hashCode = 31 * hashCode + ((grantTokens() == null) ? 0 : grantTokens().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReEncryptRequest)) {
            return false;
        }
        ReEncryptRequest other = (ReEncryptRequest) obj;
        if (other.ciphertextBlob() == null ^ this.ciphertextBlob() == null) {
            return false;
        }
        if (other.ciphertextBlob() != null && !other.ciphertextBlob().equals(this.ciphertextBlob())) {
            return false;
        }
        if (other.sourceEncryptionContext() == null ^ this.sourceEncryptionContext() == null) {
            return false;
        }
        if (other.sourceEncryptionContext() != null && !other.sourceEncryptionContext().equals(this.sourceEncryptionContext())) {
            return false;
        }
        if (other.destinationKeyId() == null ^ this.destinationKeyId() == null) {
            return false;
        }
        if (other.destinationKeyId() != null && !other.destinationKeyId().equals(this.destinationKeyId())) {
            return false;
        }
        if (other.destinationEncryptionContext() == null ^ this.destinationEncryptionContext() == null) {
            return false;
        }
        if (other.destinationEncryptionContext() != null
                && !other.destinationEncryptionContext().equals(this.destinationEncryptionContext())) {
            return false;
        }
        if (other.grantTokens() == null ^ this.grantTokens() == null) {
            return false;
        }
        if (other.grantTokens() != null && !other.grantTokens().equals(this.grantTokens())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (ciphertextBlob() != null) {
            sb.append("CiphertextBlob: ").append(ciphertextBlob()).append(",");
        }
        if (sourceEncryptionContext() != null) {
            sb.append("SourceEncryptionContext: ").append(sourceEncryptionContext()).append(",");
        }
        if (destinationKeyId() != null) {
            sb.append("DestinationKeyId: ").append(destinationKeyId()).append(",");
        }
        if (destinationEncryptionContext() != null) {
            sb.append("DestinationEncryptionContext: ").append(destinationEncryptionContext()).append(",");
        }
        if (grantTokens() != null) {
            sb.append("GrantTokens: ").append(grantTokens()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ReEncryptRequest> {
        /**
         * <p>
         * Ciphertext of the data to reencrypt.
         * </p>
         * <p>
         * To preserve immutability, the remaining bytes in the provided buffer will be copied into a new buffer when
         * set.
         * </p>
         *
         * @param ciphertextBlob
         *        Ciphertext of the data to reencrypt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ciphertextBlob(ByteBuffer ciphertextBlob);

        /**
         * <p>
         * Encryption context used to encrypt and decrypt the data specified in the <code>CiphertextBlob</code>
         * parameter.
         * </p>
         * 
         * @param sourceEncryptionContext
         *        Encryption context used to encrypt and decrypt the data specified in the <code>CiphertextBlob</code>
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEncryptionContext(Map<String, String> sourceEncryptionContext);

        /**
         * <p>
         * A unique identifier for the CMK to use to reencrypt the data. This value can be a globally unique identifier,
         * a fully specified ARN to either an alias or a key, or an alias name prefixed by "alias/".
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
         * </p>
         * </li>
         * <li>
         * <p>
         * Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
         * </p>
         * </li>
         * <li>
         * <p>
         * Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
         * </p>
         * </li>
         * <li>
         * <p>
         * Alias Name Example - alias/MyAliasName
         * </p>
         * </li>
         * </ul>
         * 
         * @param destinationKeyId
         *        A unique identifier for the CMK to use to reencrypt the data. This value can be a globally unique
         *        identifier, a fully specified ARN to either an alias or a key, or an alias name prefixed by
         *        "alias/".</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Alias Name Example - alias/MyAliasName
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationKeyId(String destinationKeyId);

        /**
         * <p>
         * Encryption context to use when the data is reencrypted.
         * </p>
         * 
         * @param destinationEncryptionContext
         *        Encryption context to use when the data is reencrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationEncryptionContext(Map<String, String> destinationEncryptionContext);

        /**
         * <p>
         * A list of grant tokens.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the
         * <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param grantTokens
         *        A list of grant tokens.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a>
         *        in the <i>AWS Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantTokens(Collection<String> grantTokens);

        /**
         * <p>
         * A list of grant tokens.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the
         * <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param grantTokens
         *        A list of grant tokens.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a>
         *        in the <i>AWS Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantTokens(String... grantTokens);
    }

    private static final class BuilderImpl implements Builder {
        private ByteBuffer ciphertextBlob;

        private Map<String, String> sourceEncryptionContext;

        private String destinationKeyId;

        private Map<String, String> destinationEncryptionContext;

        private List<String> grantTokens;

        private BuilderImpl() {
        }

        private BuilderImpl(ReEncryptRequest model) {
            setCiphertextBlob(model.ciphertextBlob);
            setSourceEncryptionContext(model.sourceEncryptionContext);
            setDestinationKeyId(model.destinationKeyId);
            setDestinationEncryptionContext(model.destinationEncryptionContext);
            setGrantTokens(model.grantTokens);
        }

        public final ByteBuffer getCiphertextBlob() {
            return ciphertextBlob;
        }

        @Override
        public final Builder ciphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy(ciphertextBlob);
            return this;
        }

        public final void setCiphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy(ciphertextBlob);
        }

        public final Map<String, String> getSourceEncryptionContext() {
            return sourceEncryptionContext;
        }

        @Override
        public final Builder sourceEncryptionContext(Map<String, String> sourceEncryptionContext) {
            this.sourceEncryptionContext = EncryptionContextTypeCopier.copy(sourceEncryptionContext);
            return this;
        }

        public final void setSourceEncryptionContext(Map<String, String> sourceEncryptionContext) {
            this.sourceEncryptionContext = EncryptionContextTypeCopier.copy(sourceEncryptionContext);
        }

        public final String getDestinationKeyId() {
            return destinationKeyId;
        }

        @Override
        public final Builder destinationKeyId(String destinationKeyId) {
            this.destinationKeyId = destinationKeyId;
            return this;
        }

        public final void setDestinationKeyId(String destinationKeyId) {
            this.destinationKeyId = destinationKeyId;
        }

        public final Map<String, String> getDestinationEncryptionContext() {
            return destinationEncryptionContext;
        }

        @Override
        public final Builder destinationEncryptionContext(Map<String, String> destinationEncryptionContext) {
            this.destinationEncryptionContext = EncryptionContextTypeCopier.copy(destinationEncryptionContext);
            return this;
        }

        public final void setDestinationEncryptionContext(Map<String, String> destinationEncryptionContext) {
            this.destinationEncryptionContext = EncryptionContextTypeCopier.copy(destinationEncryptionContext);
        }

        public final Collection<String> getGrantTokens() {
            return grantTokens;
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String... grantTokens) {
            grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        @SafeVarargs
        public final void setGrantTokens(String... grantTokens) {
            grantTokens(Arrays.asList(grantTokens));
        }

        @Override
        public ReEncryptRequest build() {
            return new ReEncryptRequest(this);
        }
    }
}
