/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutKeyPolicyRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutKeyPolicyRequest.Builder, PutKeyPolicyRequest> {
    private final String keyId;

    private final String policyName;

    private final String policy;

    private final Boolean bypassPolicyLockoutSafetyCheck;

    private PutKeyPolicyRequest(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.policyName = builder.policyName;
        this.policy = builder.policy;
        this.bypassPolicyLockoutSafetyCheck = builder.bypassPolicyLockoutSafetyCheck;
    }

    /**
     * <p>
     * A unique identifier for the CMK.
     * </p>
     * <p>
     * Use the CMK's unique identifier or its Amazon Resource Name (ARN). For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Unique ID: 1234abcd-12ab-34cd-56ef-1234567890ab
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
     * </p>
     * </li>
     * </ul>
     * 
     * @return A unique identifier for the CMK.</p>
     *         <p>
     *         Use the CMK's unique identifier or its Amazon Resource Name (ARN). For example:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Unique ID: 1234abcd-12ab-34cd-56ef-1234567890ab
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
     *         </p>
     *         </li>
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * The name of the key policy.
     * </p>
     * <p>
     * This value must be <code>default</code>.
     * </p>
     * 
     * @return The name of the key policy.</p>
     *         <p>
     *         This value must be <code>default</code>.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The key policy to attach to the CMK.
     * </p>
     * <p>
     * If you do not set <code>BypassPolicyLockoutSafetyCheck</code> to true, the policy must meet the following
     * criteria:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It must allow the principal that is making the <code>PutKeyPolicy</code> request to make a subsequent
     * <code>PutKeyPolicy</code> request on the CMK. This reduces the likelihood that the CMK becomes unmanageable. For
     * more information, refer to the scenario in the <a href=
     * "http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     * >Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The principals that are specified in the key policy must exist and be visible to AWS KMS. When you create a new
     * AWS principal (for example, an IAM user or role), you might need to enforce a delay before specifying the new
     * principal in a key policy because the new principal might not immediately be visible to AWS KMS. For more
     * information, see <a href=
     * "http://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency"
     * >Changes that I make are not always immediately visible</a> in the <i>IAM User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The policy size limit is 32 KiB (32768 bytes).
     * </p>
     * 
     * @return The key policy to attach to the CMK.</p>
     *         <p>
     *         If you do not set <code>BypassPolicyLockoutSafetyCheck</code> to true, the policy must meet the following
     *         criteria:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         It must allow the principal that is making the <code>PutKeyPolicy</code> request to make a subsequent
     *         <code>PutKeyPolicy</code> request on the CMK. This reduces the likelihood that the CMK becomes
     *         unmanageable. For more information, refer to the scenario in the <a href=
     *         "http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     *         >Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The principals that are specified in the key policy must exist and be visible to AWS KMS. When you create
     *         a new AWS principal (for example, an IAM user or role), you might need to enforce a delay before
     *         specifying the new principal in a key policy because the new principal might not immediately be visible
     *         to AWS KMS. For more information, see <a href=
     *         "http://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency"
     *         >Changes that I make are not always immediately visible</a> in the <i>IAM User Guide</i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The policy size limit is 32 KiB (32768 bytes).
     */
    public String policy() {
        return policy;
    }

    /**
     * <p>
     * A flag to indicate whether to bypass the key policy lockout safety check.
     * </p>
     * <important>
     * <p>
     * Setting this value to true increases the likelihood that the CMK becomes unmanageable. Do not set this value to
     * true indiscriminately.
     * </p>
     * <p>
     * For more information, refer to the scenario in the <a href=
     * "http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     * >Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * Use this parameter only when you intend to prevent the principal that is making the request from making a
     * subsequent <code>PutKeyPolicy</code> request on the CMK.
     * </p>
     * <p>
     * The default value is false.
     * </p>
     * 
     * @return A flag to indicate whether to bypass the key policy lockout safety check.</p> <important>
     *         <p>
     *         Setting this value to true increases the likelihood that the CMK becomes unmanageable. Do not set this
     *         value to true indiscriminately.
     *         </p>
     *         <p>
     *         For more information, refer to the scenario in the <a href=
     *         "http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     *         >Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.
     *         </p>
     *         </important>
     *         <p>
     *         Use this parameter only when you intend to prevent the principal that is making the request from making a
     *         subsequent <code>PutKeyPolicy</code> request on the CMK.
     *         </p>
     *         <p>
     *         The default value is false.
     */
    public Boolean bypassPolicyLockoutSafetyCheck() {
        return bypassPolicyLockoutSafetyCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyId() == null) ? 0 : keyId().hashCode());
        hashCode = 31 * hashCode + ((policyName() == null) ? 0 : policyName().hashCode());
        hashCode = 31 * hashCode + ((policy() == null) ? 0 : policy().hashCode());
        hashCode = 31 * hashCode + ((bypassPolicyLockoutSafetyCheck() == null) ? 0 : bypassPolicyLockoutSafetyCheck().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutKeyPolicyRequest)) {
            return false;
        }
        PutKeyPolicyRequest other = (PutKeyPolicyRequest) obj;
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        if (other.policy() == null ^ this.policy() == null) {
            return false;
        }
        if (other.policy() != null && !other.policy().equals(this.policy())) {
            return false;
        }
        if (other.bypassPolicyLockoutSafetyCheck() == null ^ this.bypassPolicyLockoutSafetyCheck() == null) {
            return false;
        }
        if (other.bypassPolicyLockoutSafetyCheck() != null
                && !other.bypassPolicyLockoutSafetyCheck().equals(this.bypassPolicyLockoutSafetyCheck())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (keyId() != null) {
            sb.append("KeyId: ").append(keyId()).append(",");
        }
        if (policyName() != null) {
            sb.append("PolicyName: ").append(policyName()).append(",");
        }
        if (policy() != null) {
            sb.append("Policy: ").append(policy()).append(",");
        }
        if (bypassPolicyLockoutSafetyCheck() != null) {
            sb.append("BypassPolicyLockoutSafetyCheck: ").append(bypassPolicyLockoutSafetyCheck()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutKeyPolicyRequest> {
        /**
         * <p>
         * A unique identifier for the CMK.
         * </p>
         * <p>
         * Use the CMK's unique identifier or its Amazon Resource Name (ARN). For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Unique ID: 1234abcd-12ab-34cd-56ef-1234567890ab
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
         * </p>
         * </li>
         * </ul>
         * 
         * @param keyId
         *        A unique identifier for the CMK.</p>
         *        <p>
         *        Use the CMK's unique identifier or its Amazon Resource Name (ARN). For example:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Unique ID: 1234abcd-12ab-34cd-56ef-1234567890ab
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * The name of the key policy.
         * </p>
         * <p>
         * This value must be <code>default</code>.
         * </p>
         * 
         * @param policyName
         *        The name of the key policy.</p>
         *        <p>
         *        This value must be <code>default</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The key policy to attach to the CMK.
         * </p>
         * <p>
         * If you do not set <code>BypassPolicyLockoutSafetyCheck</code> to true, the policy must meet the following
         * criteria:
         * </p>
         * <ul>
         * <li>
         * <p>
         * It must allow the principal that is making the <code>PutKeyPolicy</code> request to make a subsequent
         * <code>PutKeyPolicy</code> request on the CMK. This reduces the likelihood that the CMK becomes unmanageable.
         * For more information, refer to the scenario in the <a href=
         * "http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
         * >Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The principals that are specified in the key policy must exist and be visible to AWS KMS. When you create a
         * new AWS principal (for example, an IAM user or role), you might need to enforce a delay before specifying the
         * new principal in a key policy because the new principal might not immediately be visible to AWS KMS. For more
         * information, see <a href=
         * "http://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency"
         * >Changes that I make are not always immediately visible</a> in the <i>IAM User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The policy size limit is 32 KiB (32768 bytes).
         * </p>
         * 
         * @param policy
         *        The key policy to attach to the CMK.</p>
         *        <p>
         *        If you do not set <code>BypassPolicyLockoutSafetyCheck</code> to true, the policy must meet the
         *        following criteria:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        It must allow the principal that is making the <code>PutKeyPolicy</code> request to make a subsequent
         *        <code>PutKeyPolicy</code> request on the CMK. This reduces the likelihood that the CMK becomes
         *        unmanageable. For more information, refer to the scenario in the <a href=
         *        "http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
         *        >Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The principals that are specified in the key policy must exist and be visible to AWS KMS. When you
         *        create a new AWS principal (for example, an IAM user or role), you might need to enforce a delay
         *        before specifying the new principal in a key policy because the new principal might not immediately be
         *        visible to AWS KMS. For more information, see <a href=
         *        "http://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency"
         *        >Changes that I make are not always immediately visible</a> in the <i>IAM User Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The policy size limit is 32 KiB (32768 bytes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * A flag to indicate whether to bypass the key policy lockout safety check.
         * </p>
         * <important>
         * <p>
         * Setting this value to true increases the likelihood that the CMK becomes unmanageable. Do not set this value
         * to true indiscriminately.
         * </p>
         * <p>
         * For more information, refer to the scenario in the <a href=
         * "http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
         * >Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * </important>
         * <p>
         * Use this parameter only when you intend to prevent the principal that is making the request from making a
         * subsequent <code>PutKeyPolicy</code> request on the CMK.
         * </p>
         * <p>
         * The default value is false.
         * </p>
         * 
         * @param bypassPolicyLockoutSafetyCheck
         *        A flag to indicate whether to bypass the key policy lockout safety check.</p> <important>
         *        <p>
         *        Setting this value to true increases the likelihood that the CMK becomes unmanageable. Do not set this
         *        value to true indiscriminately.
         *        </p>
         *        <p>
         *        For more information, refer to the scenario in the <a href=
         *        "http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
         *        >Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.
         *        </p>
         *        </important>
         *        <p>
         *        Use this parameter only when you intend to prevent the principal that is making the request from
         *        making a subsequent <code>PutKeyPolicy</code> request on the CMK.
         *        </p>
         *        <p>
         *        The default value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck);
    }

    private static final class BuilderImpl implements Builder {
        private String keyId;

        private String policyName;

        private String policy;

        private Boolean bypassPolicyLockoutSafetyCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(PutKeyPolicyRequest model) {
            setKeyId(model.keyId);
            setPolicyName(model.policyName);
            setPolicy(model.policy);
            setBypassPolicyLockoutSafetyCheck(model.bypassPolicyLockoutSafetyCheck);
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final Boolean getBypassPolicyLockoutSafetyCheck() {
            return bypassPolicyLockoutSafetyCheck;
        }

        @Override
        public final Builder bypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
            return this;
        }

        public final void setBypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
        }

        @Override
        public PutKeyPolicyRequest build() {
            return new PutKeyPolicyRequest(this);
        }
    }
}
