/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kms.transform.KeyMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata about a customer master key (CMK).
 * </p>
 * <p>
 * This data type is used as a response element for the <a>CreateKey</a> and <a>DescribeKey</a> operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class KeyMetadata implements StructuredPojo, ToCopyableBuilder<KeyMetadata.Builder, KeyMetadata> {
    private final String awsAccountId;

    private final String keyId;

    private final String arn;

    private final Instant creationDate;

    private final Boolean enabled;

    private final String description;

    private final String keyUsage;

    private final String keyState;

    private final Instant deletionDate;

    private final Instant validTo;

    private final String origin;

    private final String expirationModel;

    private KeyMetadata(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.keyId = builder.keyId;
        this.arn = builder.arn;
        this.creationDate = builder.creationDate;
        this.enabled = builder.enabled;
        this.description = builder.description;
        this.keyUsage = builder.keyUsage;
        this.keyState = builder.keyState;
        this.deletionDate = builder.deletionDate;
        this.validTo = builder.validTo;
        this.origin = builder.origin;
        this.expirationModel = builder.expirationModel;
    }

    /**
     * <p>
     * The twelve-digit account ID of the AWS account that owns the CMK.
     * </p>
     * 
     * @return The twelve-digit account ID of the AWS account that owns the CMK.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The globally unique identifier for the CMK.
     * </p>
     * 
     * @return The globally unique identifier for the CMK.
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the CMK. For examples, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">AWS Key
     * Management Service (AWS KMS)</a> in the Example ARNs section of the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the CMK. For examples, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">AWS Key
     *         Management Service (AWS KMS)</a> in the Example ARNs section of the <i>AWS General Reference</i>.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time when the CMK was created.
     * </p>
     * 
     * @return The date and time when the CMK was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * Specifies whether the CMK is enabled. When <code>KeyState</code> is <code>Enabled</code> this value is true,
     * otherwise it is false.
     * </p>
     * 
     * @return Specifies whether the CMK is enabled. When <code>KeyState</code> is <code>Enabled</code> this value is
     *         true, otherwise it is false.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The description of the CMK.
     * </p>
     * 
     * @return The description of the CMK.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The cryptographic operations for which you can use the CMK. Currently the only allowed value is
     * <code>ENCRYPT_DECRYPT</code>, which means you can use the CMK for the <a>Encrypt</a> and <a>Decrypt</a>
     * operations.
     * </p>
     * 
     * @return The cryptographic operations for which you can use the CMK. Currently the only allowed value is
     *         <code>ENCRYPT_DECRYPT</code>, which means you can use the CMK for the <a>Encrypt</a> and <a>Decrypt</a>
     *         operations.
     * @see KeyUsageType
     */
    public String keyUsage() {
        return keyUsage;
    }

    /**
     * <p>
     * The state of the CMK.
     * </p>
     * <p>
     * For more information about how key state affects the use of a CMK, see <a
     * href="http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects the Use of a
     * Customer Master Key</a> in the <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * 
     * @return The state of the CMK.</p>
     *         <p>
     *         For more information about how key state affects the use of a CMK, see <a
     *         href="http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects the Use
     *         of a Customer Master Key</a> in the <i>AWS Key Management Service Developer Guide</i>.
     * @see KeyState
     */
    public String keyState() {
        return keyState;
    }

    /**
     * <p>
     * The date and time after which AWS KMS deletes the CMK. This value is present only when <code>KeyState</code> is
     * <code>PendingDeletion</code>, otherwise this value is omitted.
     * </p>
     * 
     * @return The date and time after which AWS KMS deletes the CMK. This value is present only when
     *         <code>KeyState</code> is <code>PendingDeletion</code>, otherwise this value is omitted.
     */
    public Instant deletionDate() {
        return deletionDate;
    }

    /**
     * <p>
     * The time at which the imported key material expires. When the key material expires, AWS KMS deletes the key
     * material and the CMK becomes unusable. This value is present only for CMKs whose <code>Origin</code> is
     * <code>EXTERNAL</code> and whose <code>ExpirationModel</code> is <code>KEY_MATERIAL_EXPIRES</code>, otherwise this
     * value is omitted.
     * </p>
     * 
     * @return The time at which the imported key material expires. When the key material expires, AWS KMS deletes the
     *         key material and the CMK becomes unusable. This value is present only for CMKs whose <code>Origin</code>
     *         is <code>EXTERNAL</code> and whose <code>ExpirationModel</code> is <code>KEY_MATERIAL_EXPIRES</code>,
     *         otherwise this value is omitted.
     */
    public Instant validTo() {
        return validTo;
    }

    /**
     * <p>
     * The source of the CMK's key material. When this value is <code>AWS_KMS</code>, AWS KMS created the key material.
     * When this value is <code>EXTERNAL</code>, the key material was imported from your existing key management
     * infrastructure or the CMK lacks key material.
     * </p>
     * 
     * @return The source of the CMK's key material. When this value is <code>AWS_KMS</code>, AWS KMS created the key
     *         material. When this value is <code>EXTERNAL</code>, the key material was imported from your existing key
     *         management infrastructure or the CMK lacks key material.
     * @see OriginType
     */
    public String origin() {
        return origin;
    }

    /**
     * <p>
     * Specifies whether the CMK's key material expires. This value is present only when <code>Origin</code> is
     * <code>EXTERNAL</code>, otherwise this value is omitted.
     * </p>
     * 
     * @return Specifies whether the CMK's key material expires. This value is present only when <code>Origin</code> is
     *         <code>EXTERNAL</code>, otherwise this value is omitted.
     * @see ExpirationModelType
     */
    public String expirationModel() {
        return expirationModel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((awsAccountId() == null) ? 0 : awsAccountId().hashCode());
        hashCode = 31 * hashCode + ((keyId() == null) ? 0 : keyId().hashCode());
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((creationDate() == null) ? 0 : creationDate().hashCode());
        hashCode = 31 * hashCode + ((enabled() == null) ? 0 : enabled().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((keyUsage() == null) ? 0 : keyUsage().hashCode());
        hashCode = 31 * hashCode + ((keyState() == null) ? 0 : keyState().hashCode());
        hashCode = 31 * hashCode + ((deletionDate() == null) ? 0 : deletionDate().hashCode());
        hashCode = 31 * hashCode + ((validTo() == null) ? 0 : validTo().hashCode());
        hashCode = 31 * hashCode + ((origin() == null) ? 0 : origin().hashCode());
        hashCode = 31 * hashCode + ((expirationModel() == null) ? 0 : expirationModel().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyMetadata)) {
            return false;
        }
        KeyMetadata other = (KeyMetadata) obj;
        if (other.awsAccountId() == null ^ this.awsAccountId() == null) {
            return false;
        }
        if (other.awsAccountId() != null && !other.awsAccountId().equals(this.awsAccountId())) {
            return false;
        }
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.keyUsage() == null ^ this.keyUsage() == null) {
            return false;
        }
        if (other.keyUsage() != null && !other.keyUsage().equals(this.keyUsage())) {
            return false;
        }
        if (other.keyState() == null ^ this.keyState() == null) {
            return false;
        }
        if (other.keyState() != null && !other.keyState().equals(this.keyState())) {
            return false;
        }
        if (other.deletionDate() == null ^ this.deletionDate() == null) {
            return false;
        }
        if (other.deletionDate() != null && !other.deletionDate().equals(this.deletionDate())) {
            return false;
        }
        if (other.validTo() == null ^ this.validTo() == null) {
            return false;
        }
        if (other.validTo() != null && !other.validTo().equals(this.validTo())) {
            return false;
        }
        if (other.origin() == null ^ this.origin() == null) {
            return false;
        }
        if (other.origin() != null && !other.origin().equals(this.origin())) {
            return false;
        }
        if (other.expirationModel() == null ^ this.expirationModel() == null) {
            return false;
        }
        if (other.expirationModel() != null && !other.expirationModel().equals(this.expirationModel())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (awsAccountId() != null) {
            sb.append("AWSAccountId: ").append(awsAccountId()).append(",");
        }
        if (keyId() != null) {
            sb.append("KeyId: ").append(keyId()).append(",");
        }
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (creationDate() != null) {
            sb.append("CreationDate: ").append(creationDate()).append(",");
        }
        if (enabled() != null) {
            sb.append("Enabled: ").append(enabled()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (keyUsage() != null) {
            sb.append("KeyUsage: ").append(keyUsage()).append(",");
        }
        if (keyState() != null) {
            sb.append("KeyState: ").append(keyState()).append(",");
        }
        if (deletionDate() != null) {
            sb.append("DeletionDate: ").append(deletionDate()).append(",");
        }
        if (validTo() != null) {
            sb.append("ValidTo: ").append(validTo()).append(",");
        }
        if (origin() != null) {
            sb.append("Origin: ").append(origin()).append(",");
        }
        if (expirationModel() != null) {
            sb.append("ExpirationModel: ").append(expirationModel()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeyMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, KeyMetadata> {
        /**
         * <p>
         * The twelve-digit account ID of the AWS account that owns the CMK.
         * </p>
         * 
         * @param awsAccountId
         *        The twelve-digit account ID of the AWS account that owns the CMK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The globally unique identifier for the CMK.
         * </p>
         * 
         * @param keyId
         *        The globally unique identifier for the CMK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the CMK. For examples, see <a
         * href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">AWS Key
         * Management Service (AWS KMS)</a> in the Example ARNs section of the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the CMK. For examples, see <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">AWS
         *        Key Management Service (AWS KMS)</a> in the Example ARNs section of the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time when the CMK was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time when the CMK was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * Specifies whether the CMK is enabled. When <code>KeyState</code> is <code>Enabled</code> this value is true,
         * otherwise it is false.
         * </p>
         * 
         * @param enabled
         *        Specifies whether the CMK is enabled. When <code>KeyState</code> is <code>Enabled</code> this value is
         *        true, otherwise it is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The description of the CMK.
         * </p>
         * 
         * @param description
         *        The description of the CMK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The cryptographic operations for which you can use the CMK. Currently the only allowed value is
         * <code>ENCRYPT_DECRYPT</code>, which means you can use the CMK for the <a>Encrypt</a> and <a>Decrypt</a>
         * operations.
         * </p>
         * 
         * @param keyUsage
         *        The cryptographic operations for which you can use the CMK. Currently the only allowed value is
         *        <code>ENCRYPT_DECRYPT</code>, which means you can use the CMK for the <a>Encrypt</a> and
         *        <a>Decrypt</a> operations.
         * @see KeyUsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyUsageType
         */
        Builder keyUsage(String keyUsage);

        /**
         * <p>
         * The cryptographic operations for which you can use the CMK. Currently the only allowed value is
         * <code>ENCRYPT_DECRYPT</code>, which means you can use the CMK for the <a>Encrypt</a> and <a>Decrypt</a>
         * operations.
         * </p>
         * 
         * @param keyUsage
         *        The cryptographic operations for which you can use the CMK. Currently the only allowed value is
         *        <code>ENCRYPT_DECRYPT</code>, which means you can use the CMK for the <a>Encrypt</a> and
         *        <a>Decrypt</a> operations.
         * @see KeyUsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyUsageType
         */
        Builder keyUsage(KeyUsageType keyUsage);

        /**
         * <p>
         * The state of the CMK.
         * </p>
         * <p>
         * For more information about how key state affects the use of a CMK, see <a
         * href="http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects the Use of a
         * Customer Master Key</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param keyState
         *        The state of the CMK.</p>
         *        <p>
         *        For more information about how key state affects the use of a CMK, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects the
         *        Use of a Customer Master Key</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * @see KeyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyState
         */
        Builder keyState(String keyState);

        /**
         * <p>
         * The state of the CMK.
         * </p>
         * <p>
         * For more information about how key state affects the use of a CMK, see <a
         * href="http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects the Use of a
         * Customer Master Key</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param keyState
         *        The state of the CMK.</p>
         *        <p>
         *        For more information about how key state affects the use of a CMK, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects the
         *        Use of a Customer Master Key</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * @see KeyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyState
         */
        Builder keyState(KeyState keyState);

        /**
         * <p>
         * The date and time after which AWS KMS deletes the CMK. This value is present only when <code>KeyState</code>
         * is <code>PendingDeletion</code>, otherwise this value is omitted.
         * </p>
         * 
         * @param deletionDate
         *        The date and time after which AWS KMS deletes the CMK. This value is present only when
         *        <code>KeyState</code> is <code>PendingDeletion</code>, otherwise this value is omitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionDate(Instant deletionDate);

        /**
         * <p>
         * The time at which the imported key material expires. When the key material expires, AWS KMS deletes the key
         * material and the CMK becomes unusable. This value is present only for CMKs whose <code>Origin</code> is
         * <code>EXTERNAL</code> and whose <code>ExpirationModel</code> is <code>KEY_MATERIAL_EXPIRES</code>, otherwise
         * this value is omitted.
         * </p>
         * 
         * @param validTo
         *        The time at which the imported key material expires. When the key material expires, AWS KMS deletes
         *        the key material and the CMK becomes unusable. This value is present only for CMKs whose
         *        <code>Origin</code> is <code>EXTERNAL</code> and whose <code>ExpirationModel</code> is
         *        <code>KEY_MATERIAL_EXPIRES</code>, otherwise this value is omitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validTo(Instant validTo);

        /**
         * <p>
         * The source of the CMK's key material. When this value is <code>AWS_KMS</code>, AWS KMS created the key
         * material. When this value is <code>EXTERNAL</code>, the key material was imported from your existing key
         * management infrastructure or the CMK lacks key material.
         * </p>
         * 
         * @param origin
         *        The source of the CMK's key material. When this value is <code>AWS_KMS</code>, AWS KMS created the key
         *        material. When this value is <code>EXTERNAL</code>, the key material was imported from your existing
         *        key management infrastructure or the CMK lacks key material.
         * @see OriginType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginType
         */
        Builder origin(String origin);

        /**
         * <p>
         * The source of the CMK's key material. When this value is <code>AWS_KMS</code>, AWS KMS created the key
         * material. When this value is <code>EXTERNAL</code>, the key material was imported from your existing key
         * management infrastructure or the CMK lacks key material.
         * </p>
         * 
         * @param origin
         *        The source of the CMK's key material. When this value is <code>AWS_KMS</code>, AWS KMS created the key
         *        material. When this value is <code>EXTERNAL</code>, the key material was imported from your existing
         *        key management infrastructure or the CMK lacks key material.
         * @see OriginType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginType
         */
        Builder origin(OriginType origin);

        /**
         * <p>
         * Specifies whether the CMK's key material expires. This value is present only when <code>Origin</code> is
         * <code>EXTERNAL</code>, otherwise this value is omitted.
         * </p>
         * 
         * @param expirationModel
         *        Specifies whether the CMK's key material expires. This value is present only when <code>Origin</code>
         *        is <code>EXTERNAL</code>, otherwise this value is omitted.
         * @see ExpirationModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationModelType
         */
        Builder expirationModel(String expirationModel);

        /**
         * <p>
         * Specifies whether the CMK's key material expires. This value is present only when <code>Origin</code> is
         * <code>EXTERNAL</code>, otherwise this value is omitted.
         * </p>
         * 
         * @param expirationModel
         *        Specifies whether the CMK's key material expires. This value is present only when <code>Origin</code>
         *        is <code>EXTERNAL</code>, otherwise this value is omitted.
         * @see ExpirationModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationModelType
         */
        Builder expirationModel(ExpirationModelType expirationModel);
    }

    private static final class BuilderImpl implements Builder {
        private String awsAccountId;

        private String keyId;

        private String arn;

        private Instant creationDate;

        private Boolean enabled;

        private String description;

        private String keyUsage;

        private String keyState;

        private Instant deletionDate;

        private Instant validTo;

        private String origin;

        private String expirationModel;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyMetadata model) {
            setAWSAccountId(model.awsAccountId);
            setKeyId(model.keyId);
            setArn(model.arn);
            setCreationDate(model.creationDate);
            setEnabled(model.enabled);
            setDescription(model.description);
            setKeyUsage(model.keyUsage);
            setKeyState(model.keyState);
            setDeletionDate(model.deletionDate);
            setValidTo(model.validTo);
            setOrigin(model.origin);
            setExpirationModel(model.expirationModel);
        }

        public final String getAWSAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAWSAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKeyUsage() {
            return keyUsage;
        }

        @Override
        public final Builder keyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        @Override
        public final Builder keyUsage(KeyUsageType keyUsage) {
            this.keyUsage(keyUsage.toString());
            return this;
        }

        public final void setKeyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
        }

        public final void setKeyUsage(KeyUsageType keyUsage) {
            this.keyUsage(keyUsage.toString());
        }

        public final String getKeyState() {
            return keyState;
        }

        @Override
        public final Builder keyState(String keyState) {
            this.keyState = keyState;
            return this;
        }

        @Override
        public final Builder keyState(KeyState keyState) {
            this.keyState(keyState.toString());
            return this;
        }

        public final void setKeyState(String keyState) {
            this.keyState = keyState;
        }

        public final void setKeyState(KeyState keyState) {
            this.keyState(keyState.toString());
        }

        public final Instant getDeletionDate() {
            return deletionDate;
        }

        @Override
        public final Builder deletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
            return this;
        }

        public final void setDeletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
        }

        public final Instant getValidTo() {
            return validTo;
        }

        @Override
        public final Builder validTo(Instant validTo) {
            this.validTo = validTo;
            return this;
        }

        public final void setValidTo(Instant validTo) {
            this.validTo = validTo;
        }

        public final String getOrigin() {
            return origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(OriginType origin) {
            this.origin(origin.toString());
            return this;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        public final void setOrigin(OriginType origin) {
            this.origin(origin.toString());
        }

        public final String getExpirationModel() {
            return expirationModel;
        }

        @Override
        public final Builder expirationModel(String expirationModel) {
            this.expirationModel = expirationModel;
            return this;
        }

        @Override
        public final Builder expirationModel(ExpirationModelType expirationModel) {
            this.expirationModel(expirationModel.toString());
            return this;
        }

        public final void setExpirationModel(String expirationModel) {
            this.expirationModel = expirationModel;
        }

        public final void setExpirationModel(ExpirationModelType expirationModel) {
            this.expirationModel(expirationModel.toString());
        }

        @Override
        public KeyMetadata build() {
            return new KeyMetadata(this);
        }
    }
}
