/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetParametersForImportRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetParametersForImportRequest.Builder, GetParametersForImportRequest> {
    private final String keyId;

    private final String wrappingAlgorithm;

    private final String wrappingKeySpec;

    private GetParametersForImportRequest(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.wrappingAlgorithm = builder.wrappingAlgorithm;
        this.wrappingKeySpec = builder.wrappingKeySpec;
    }

    /**
     * <p>
     * The identifier of the CMK into which you will import key material. The CMK's <code>Origin</code> must be
     * <code>EXTERNAL</code>.
     * </p>
     * <p>
     * A valid identifier is the unique key ID or the Amazon Resource Name (ARN) of the CMK. Examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Unique key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the CMK into which you will import key material. The CMK's <code>Origin</code> must be
     *         <code>EXTERNAL</code>.</p>
     *         <p>
     *         A valid identifier is the unique key ID or the Amazon Resource Name (ARN) of the CMK. Examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Unique key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
     *         </p>
     *         </li>
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * The algorithm you will use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>. For
     * more information, see <a
     * href="http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html">Encrypt the
     * Key Material</a> in the <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * 
     * @return The algorithm you will use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>.
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html"
     *         >Encrypt the Key Material</a> in the <i>AWS Key Management Service Developer Guide</i>.
     * @see AlgorithmSpec
     */
    public String wrappingAlgorithm() {
        return wrappingAlgorithm;
    }

    /**
     * <p>
     * The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are supported.
     * </p>
     * 
     * @return The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are
     *         supported.
     * @see WrappingKeySpec
     */
    public String wrappingKeySpec() {
        return wrappingKeySpec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyId() == null) ? 0 : keyId().hashCode());
        hashCode = 31 * hashCode + ((wrappingAlgorithm() == null) ? 0 : wrappingAlgorithm().hashCode());
        hashCode = 31 * hashCode + ((wrappingKeySpec() == null) ? 0 : wrappingKeySpec().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersForImportRequest)) {
            return false;
        }
        GetParametersForImportRequest other = (GetParametersForImportRequest) obj;
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.wrappingAlgorithm() == null ^ this.wrappingAlgorithm() == null) {
            return false;
        }
        if (other.wrappingAlgorithm() != null && !other.wrappingAlgorithm().equals(this.wrappingAlgorithm())) {
            return false;
        }
        if (other.wrappingKeySpec() == null ^ this.wrappingKeySpec() == null) {
            return false;
        }
        if (other.wrappingKeySpec() != null && !other.wrappingKeySpec().equals(this.wrappingKeySpec())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (keyId() != null) {
            sb.append("KeyId: ").append(keyId()).append(",");
        }
        if (wrappingAlgorithm() != null) {
            sb.append("WrappingAlgorithm: ").append(wrappingAlgorithm()).append(",");
        }
        if (wrappingKeySpec() != null) {
            sb.append("WrappingKeySpec: ").append(wrappingKeySpec()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetParametersForImportRequest> {
        /**
         * <p>
         * The identifier of the CMK into which you will import key material. The CMK's <code>Origin</code> must be
         * <code>EXTERNAL</code>.
         * </p>
         * <p>
         * A valid identifier is the unique key ID or the Amazon Resource Name (ARN) of the CMK. Examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Unique key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param keyId
         *        The identifier of the CMK into which you will import key material. The CMK's <code>Origin</code> must
         *        be <code>EXTERNAL</code>.</p>
         *        <p>
         *        A valid identifier is the unique key ID or the Amazon Resource Name (ARN) of the CMK. Examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Unique key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * The algorithm you will use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>. For
         * more information, see <a
         * href="http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html">Encrypt
         * the Key Material</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param wrappingAlgorithm
         *        The algorithm you will use to encrypt the key material before importing it with
         *        <a>ImportKeyMaterial</a>. For more information, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html"
         *        >Encrypt the Key Material</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * @see AlgorithmSpec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlgorithmSpec
         */
        Builder wrappingAlgorithm(String wrappingAlgorithm);

        /**
         * <p>
         * The algorithm you will use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>. For
         * more information, see <a
         * href="http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html">Encrypt
         * the Key Material</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param wrappingAlgorithm
         *        The algorithm you will use to encrypt the key material before importing it with
         *        <a>ImportKeyMaterial</a>. For more information, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html"
         *        >Encrypt the Key Material</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * @see AlgorithmSpec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlgorithmSpec
         */
        Builder wrappingAlgorithm(AlgorithmSpec wrappingAlgorithm);

        /**
         * <p>
         * The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are supported.
         * </p>
         * 
         * @param wrappingKeySpec
         *        The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are
         *        supported.
         * @see WrappingKeySpec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WrappingKeySpec
         */
        Builder wrappingKeySpec(String wrappingKeySpec);

        /**
         * <p>
         * The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are supported.
         * </p>
         * 
         * @param wrappingKeySpec
         *        The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are
         *        supported.
         * @see WrappingKeySpec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WrappingKeySpec
         */
        Builder wrappingKeySpec(WrappingKeySpec wrappingKeySpec);
    }

    private static final class BuilderImpl implements Builder {
        private String keyId;

        private String wrappingAlgorithm;

        private String wrappingKeySpec;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersForImportRequest model) {
            setKeyId(model.keyId);
            setWrappingAlgorithm(model.wrappingAlgorithm);
            setWrappingKeySpec(model.wrappingKeySpec);
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getWrappingAlgorithm() {
            return wrappingAlgorithm;
        }

        @Override
        public final Builder wrappingAlgorithm(String wrappingAlgorithm) {
            this.wrappingAlgorithm = wrappingAlgorithm;
            return this;
        }

        @Override
        public final Builder wrappingAlgorithm(AlgorithmSpec wrappingAlgorithm) {
            this.wrappingAlgorithm(wrappingAlgorithm.toString());
            return this;
        }

        public final void setWrappingAlgorithm(String wrappingAlgorithm) {
            this.wrappingAlgorithm = wrappingAlgorithm;
        }

        public final void setWrappingAlgorithm(AlgorithmSpec wrappingAlgorithm) {
            this.wrappingAlgorithm(wrappingAlgorithm.toString());
        }

        public final String getWrappingKeySpec() {
            return wrappingKeySpec;
        }

        @Override
        public final Builder wrappingKeySpec(String wrappingKeySpec) {
            this.wrappingKeySpec = wrappingKeySpec;
            return this;
        }

        @Override
        public final Builder wrappingKeySpec(WrappingKeySpec wrappingKeySpec) {
            this.wrappingKeySpec(wrappingKeySpec.toString());
            return this;
        }

        public final void setWrappingKeySpec(String wrappingKeySpec) {
            this.wrappingKeySpec = wrappingKeySpec;
        }

        public final void setWrappingKeySpec(WrappingKeySpec wrappingKeySpec) {
            this.wrappingKeySpec(wrappingKeySpec.toString());
        }

        @Override
        public GetParametersForImportRequest build() {
            return new GetParametersForImportRequest(this);
        }
    }
}
