/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetKeyRotationStatusResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetKeyRotationStatusResponse.Builder, GetKeyRotationStatusResponse> {
    private final Boolean keyRotationEnabled;

    private GetKeyRotationStatusResponse(BuilderImpl builder) {
        this.keyRotationEnabled = builder.keyRotationEnabled;
    }

    /**
     * <p>
     * A Boolean value that specifies whether key rotation is enabled.
     * </p>
     * 
     * @return A Boolean value that specifies whether key rotation is enabled.
     */
    public Boolean keyRotationEnabled() {
        return keyRotationEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyRotationEnabled() == null) ? 0 : keyRotationEnabled().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKeyRotationStatusResponse)) {
            return false;
        }
        GetKeyRotationStatusResponse other = (GetKeyRotationStatusResponse) obj;
        if (other.keyRotationEnabled() == null ^ this.keyRotationEnabled() == null) {
            return false;
        }
        if (other.keyRotationEnabled() != null && !other.keyRotationEnabled().equals(this.keyRotationEnabled())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (keyRotationEnabled() != null) {
            sb.append("KeyRotationEnabled: ").append(keyRotationEnabled()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetKeyRotationStatusResponse> {
        /**
         * <p>
         * A Boolean value that specifies whether key rotation is enabled.
         * </p>
         * 
         * @param keyRotationEnabled
         *        A Boolean value that specifies whether key rotation is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyRotationEnabled(Boolean keyRotationEnabled);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean keyRotationEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKeyRotationStatusResponse model) {
            setKeyRotationEnabled(model.keyRotationEnabled);
        }

        public final Boolean getKeyRotationEnabled() {
            return keyRotationEnabled;
        }

        @Override
        public final Builder keyRotationEnabled(Boolean keyRotationEnabled) {
            this.keyRotationEnabled = keyRotationEnabled;
            return this;
        }

        public final void setKeyRotationEnabled(Boolean keyRotationEnabled) {
            this.keyRotationEnabled = keyRotationEnabled;
        }

        @Override
        public GetKeyRotationStatusResponse build() {
            return new GetKeyRotationStatusResponse(this);
        }
    }
}
