/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetKeyPolicyRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetKeyPolicyRequest.Builder, GetKeyPolicyRequest> {
    private final String keyId;

    private final String policyName;

    private GetKeyPolicyRequest(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.policyName = builder.policyName;
    }

    /**
     * <p>
     * A unique identifier for the customer master key. This value can be a globally unique identifier or the fully
     * specified ARN to a key.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
     * </p>
     * </li>
     * <li>
     * <p>
     * Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
     * </p>
     * </li>
     * </ul>
     * 
     * @return A unique identifier for the customer master key. This value can be a globally unique identifier or the
     *         fully specified ARN to a key.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
     *         </p>
     *         </li>
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * String that contains the name of the policy. Currently, this must be "default". Policy names can be discovered by
     * calling <a>ListKeyPolicies</a>.
     * </p>
     * 
     * @return String that contains the name of the policy. Currently, this must be "default". Policy names can be
     *         discovered by calling <a>ListKeyPolicies</a>.
     */
    public String policyName() {
        return policyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyId() == null) ? 0 : keyId().hashCode());
        hashCode = 31 * hashCode + ((policyName() == null) ? 0 : policyName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKeyPolicyRequest)) {
            return false;
        }
        GetKeyPolicyRequest other = (GetKeyPolicyRequest) obj;
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (keyId() != null) {
            sb.append("KeyId: ").append(keyId()).append(",");
        }
        if (policyName() != null) {
            sb.append("PolicyName: ").append(policyName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetKeyPolicyRequest> {
        /**
         * <p>
         * A unique identifier for the customer master key. This value can be a globally unique identifier or the fully
         * specified ARN to a key.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
         * </p>
         * </li>
         * <li>
         * <p>
         * Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
         * </p>
         * </li>
         * </ul>
         * 
         * @param keyId
         *        A unique identifier for the customer master key. This value can be a globally unique identifier or the
         *        fully specified ARN to a key.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * String that contains the name of the policy. Currently, this must be "default". Policy names can be
         * discovered by calling <a>ListKeyPolicies</a>.
         * </p>
         * 
         * @param policyName
         *        String that contains the name of the policy. Currently, this must be "default". Policy names can be
         *        discovered by calling <a>ListKeyPolicies</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);
    }

    private static final class BuilderImpl implements Builder {
        private String keyId;

        private String policyName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKeyPolicyRequest model) {
            setKeyId(model.keyId);
            setPolicyName(model.policyName);
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public GetKeyPolicyRequest build() {
            return new GetKeyPolicyRequest(this);
        }
    }
}
