/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DisableKeyRotationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DisableKeyRotationRequest.Builder, DisableKeyRotationRequest> {
    private final String keyId;

    private DisableKeyRotationRequest(BuilderImpl builder) {
        this.keyId = builder.keyId;
    }

    /**
     * <p>
     * A unique identifier for the customer master key. This value can be a globally unique identifier or the fully
     * specified ARN to a key.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
     * </p>
     * </li>
     * <li>
     * <p>
     * Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
     * </p>
     * </li>
     * </ul>
     * 
     * @return A unique identifier for the customer master key. This value can be a globally unique identifier or the
     *         fully specified ARN to a key.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
     *         </p>
     *         </li>
     */
    public String keyId() {
        return keyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyId() == null) ? 0 : keyId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableKeyRotationRequest)) {
            return false;
        }
        DisableKeyRotationRequest other = (DisableKeyRotationRequest) obj;
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (keyId() != null) {
            sb.append("KeyId: ").append(keyId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DisableKeyRotationRequest> {
        /**
         * <p>
         * A unique identifier for the customer master key. This value can be a globally unique identifier or the fully
         * specified ARN to a key.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
         * </p>
         * </li>
         * <li>
         * <p>
         * Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
         * </p>
         * </li>
         * </ul>
         * 
         * @param keyId
         *        A unique identifier for the customer master key. This value can be a globally unique identifier or the
         *        fully specified ARN to a key.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);
    }

    private static final class BuilderImpl implements Builder {
        private String keyId;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableKeyRotationRequest model) {
            setKeyId(model.keyId);
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public DisableKeyRotationRequest build() {
            return new DisableKeyRotationRequest(this);
        }
    }
}
