/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateKeyRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateKeyRequest.Builder, CreateKeyRequest> {
    private final String policy;

    private final String description;

    private final String keyUsage;

    private final String origin;

    private final Boolean bypassPolicyLockoutSafetyCheck;

    private final List<Tag> tags;

    private CreateKeyRequest(BuilderImpl builder) {
        this.policy = builder.policy;
        this.description = builder.description;
        this.keyUsage = builder.keyUsage;
        this.origin = builder.origin;
        this.bypassPolicyLockoutSafetyCheck = builder.bypassPolicyLockoutSafetyCheck;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The key policy to attach to the CMK.
     * </p>
     * <p>
     * If you specify a policy and do not set <code>BypassPolicyLockoutSafetyCheck</code> to true, the policy must meet
     * the following criteria:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It must allow the principal that is making the <code>CreateKey</code> request to make a subsequent
     * <a>PutKeyPolicy</a> request on the CMK. This reduces the likelihood that the CMK becomes unmanageable. For more
     * information, refer to the scenario in the <a href=
     * "http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     * >Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The principals that are specified in the key policy must exist and be visible to AWS KMS. When you create a new
     * AWS principal (for example, an IAM user or role), you might need to enforce a delay before specifying the new
     * principal in a key policy because the new principal might not immediately be visible to AWS KMS. For more
     * information, see <a href=
     * "http://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency"
     * >Changes that I make are not always immediately visible</a> in the <i>IAM User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you do not specify a policy, AWS KMS attaches a default key policy to the CMK. For more information, see <a
     * href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default Key
     * Policy</a> in the <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * <p>
     * The policy size limit is 32 KiB (32768 bytes).
     * </p>
     * 
     * @return The key policy to attach to the CMK.</p>
     *         <p>
     *         If you specify a policy and do not set <code>BypassPolicyLockoutSafetyCheck</code> to true, the policy
     *         must meet the following criteria:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         It must allow the principal that is making the <code>CreateKey</code> request to make a subsequent
     *         <a>PutKeyPolicy</a> request on the CMK. This reduces the likelihood that the CMK becomes unmanageable.
     *         For more information, refer to the scenario in the <a href=
     *         "http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     *         >Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The principals that are specified in the key policy must exist and be visible to AWS KMS. When you create
     *         a new AWS principal (for example, an IAM user or role), you might need to enforce a delay before
     *         specifying the new principal in a key policy because the new principal might not immediately be visible
     *         to AWS KMS. For more information, see <a href=
     *         "http://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency"
     *         >Changes that I make are not always immediately visible</a> in the <i>IAM User Guide</i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you do not specify a policy, AWS KMS attaches a default key policy to the CMK. For more information,
     *         see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">
     *         Default Key Policy</a> in the <i>AWS Key Management Service Developer Guide</i>.
     *         </p>
     *         <p>
     *         The policy size limit is 32 KiB (32768 bytes).
     */
    public String policy() {
        return policy;
    }

    /**
     * <p>
     * A description of the CMK.
     * </p>
     * <p>
     * Use a description that helps you decide whether the CMK is appropriate for a task.
     * </p>
     * 
     * @return A description of the CMK.</p>
     *         <p>
     *         Use a description that helps you decide whether the CMK is appropriate for a task.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The intended use of the CMK.
     * </p>
     * <p>
     * You can use CMKs only for symmetric encryption and decryption.
     * </p>
     * 
     * @return The intended use of the CMK.</p>
     *         <p>
     *         You can use CMKs only for symmetric encryption and decryption.
     * @see KeyUsageType
     */
    public String keyUsage() {
        return keyUsage;
    }

    /**
     * <p>
     * The source of the CMK's key material.
     * </p>
     * <p>
     * The default is <code>AWS_KMS</code>, which means AWS KMS creates the key material. When this parameter is set to
     * <code>EXTERNAL</code>, the request creates a CMK without key material so that you can import key material from
     * your existing key management infrastructure. For more information about importing key material into AWS KMS, see
     * <a href="http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">Importing Key Material</a> in
     * the <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * <p>
     * The CMK's <code>Origin</code> is immutable and is set when the CMK is created.
     * </p>
     * 
     * @return The source of the CMK's key material.</p>
     *         <p>
     *         The default is <code>AWS_KMS</code>, which means AWS KMS creates the key material. When this parameter is
     *         set to <code>EXTERNAL</code>, the request creates a CMK without key material so that you can import key
     *         material from your existing key management infrastructure. For more information about importing key
     *         material into AWS KMS, see <a
     *         href="http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">Importing Key
     *         Material</a> in the <i>AWS Key Management Service Developer Guide</i>.
     *         </p>
     *         <p>
     *         The CMK's <code>Origin</code> is immutable and is set when the CMK is created.
     * @see OriginType
     */
    public String origin() {
        return origin;
    }

    /**
     * <p>
     * A flag to indicate whether to bypass the key policy lockout safety check.
     * </p>
     * <important>
     * <p>
     * Setting this value to true increases the likelihood that the CMK becomes unmanageable. Do not set this value to
     * true indiscriminately.
     * </p>
     * <p>
     * For more information, refer to the scenario in the <a href=
     * "http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     * >Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * Use this parameter only when you include a policy in the request and you intend to prevent the principal that is
     * making the request from making a subsequent <a>PutKeyPolicy</a> request on the CMK.
     * </p>
     * <p>
     * The default value is false.
     * </p>
     * 
     * @return A flag to indicate whether to bypass the key policy lockout safety check.</p> <important>
     *         <p>
     *         Setting this value to true increases the likelihood that the CMK becomes unmanageable. Do not set this
     *         value to true indiscriminately.
     *         </p>
     *         <p>
     *         For more information, refer to the scenario in the <a href=
     *         "http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     *         >Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.
     *         </p>
     *         </important>
     *         <p>
     *         Use this parameter only when you include a policy in the request and you intend to prevent the principal
     *         that is making the request from making a subsequent <a>PutKeyPolicy</a> request on the CMK.
     *         </p>
     *         <p>
     *         The default value is false.
     */
    public Boolean bypassPolicyLockoutSafetyCheck() {
        return bypassPolicyLockoutSafetyCheck;
    }

    /**
     * <p>
     * One or more tags. Each tag consists of a tag key and a tag value. Tag keys and tag values are both required, but
     * tag values can be empty (null) strings.
     * </p>
     * <p>
     * Use this parameter to tag the CMK when it is created. Alternately, you can omit this parameter and instead tag
     * the CMK after it is created using <a>TagResource</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more tags. Each tag consists of a tag key and a tag value. Tag keys and tag values are both
     *         required, but tag values can be empty (null) strings.</p>
     *         <p>
     *         Use this parameter to tag the CMK when it is created. Alternately, you can omit this parameter and
     *         instead tag the CMK after it is created using <a>TagResource</a>.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((policy() == null) ? 0 : policy().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((keyUsage() == null) ? 0 : keyUsage().hashCode());
        hashCode = 31 * hashCode + ((origin() == null) ? 0 : origin().hashCode());
        hashCode = 31 * hashCode + ((bypassPolicyLockoutSafetyCheck() == null) ? 0 : bypassPolicyLockoutSafetyCheck().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyRequest)) {
            return false;
        }
        CreateKeyRequest other = (CreateKeyRequest) obj;
        if (other.policy() == null ^ this.policy() == null) {
            return false;
        }
        if (other.policy() != null && !other.policy().equals(this.policy())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.keyUsage() == null ^ this.keyUsage() == null) {
            return false;
        }
        if (other.keyUsage() != null && !other.keyUsage().equals(this.keyUsage())) {
            return false;
        }
        if (other.origin() == null ^ this.origin() == null) {
            return false;
        }
        if (other.origin() != null && !other.origin().equals(this.origin())) {
            return false;
        }
        if (other.bypassPolicyLockoutSafetyCheck() == null ^ this.bypassPolicyLockoutSafetyCheck() == null) {
            return false;
        }
        if (other.bypassPolicyLockoutSafetyCheck() != null
                && !other.bypassPolicyLockoutSafetyCheck().equals(this.bypassPolicyLockoutSafetyCheck())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (policy() != null) {
            sb.append("Policy: ").append(policy()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (keyUsage() != null) {
            sb.append("KeyUsage: ").append(keyUsage()).append(",");
        }
        if (origin() != null) {
            sb.append("Origin: ").append(origin()).append(",");
        }
        if (bypassPolicyLockoutSafetyCheck() != null) {
            sb.append("BypassPolicyLockoutSafetyCheck: ").append(bypassPolicyLockoutSafetyCheck()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateKeyRequest> {
        /**
         * <p>
         * The key policy to attach to the CMK.
         * </p>
         * <p>
         * If you specify a policy and do not set <code>BypassPolicyLockoutSafetyCheck</code> to true, the policy must
         * meet the following criteria:
         * </p>
         * <ul>
         * <li>
         * <p>
         * It must allow the principal that is making the <code>CreateKey</code> request to make a subsequent
         * <a>PutKeyPolicy</a> request on the CMK. This reduces the likelihood that the CMK becomes unmanageable. For
         * more information, refer to the scenario in the <a href=
         * "http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
         * >Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The principals that are specified in the key policy must exist and be visible to AWS KMS. When you create a
         * new AWS principal (for example, an IAM user or role), you might need to enforce a delay before specifying the
         * new principal in a key policy because the new principal might not immediately be visible to AWS KMS. For more
         * information, see <a href=
         * "http://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency"
         * >Changes that I make are not always immediately visible</a> in the <i>IAM User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you do not specify a policy, AWS KMS attaches a default key policy to the CMK. For more information, see
         * <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default
         * Key Policy</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * <p>
         * The policy size limit is 32 KiB (32768 bytes).
         * </p>
         * 
         * @param policy
         *        The key policy to attach to the CMK.</p>
         *        <p>
         *        If you specify a policy and do not set <code>BypassPolicyLockoutSafetyCheck</code> to true, the policy
         *        must meet the following criteria:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        It must allow the principal that is making the <code>CreateKey</code> request to make a subsequent
         *        <a>PutKeyPolicy</a> request on the CMK. This reduces the likelihood that the CMK becomes unmanageable.
         *        For more information, refer to the scenario in the <a href=
         *        "http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
         *        >Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The principals that are specified in the key policy must exist and be visible to AWS KMS. When you
         *        create a new AWS principal (for example, an IAM user or role), you might need to enforce a delay
         *        before specifying the new principal in a key policy because the new principal might not immediately be
         *        visible to AWS KMS. For more information, see <a href=
         *        "http://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency"
         *        >Changes that I make are not always immediately visible</a> in the <i>IAM User Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you do not specify a policy, AWS KMS attaches a default key policy to the CMK. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default"
         *        >Default Key Policy</a> in the <i>AWS Key Management Service Developer Guide</i>.
         *        </p>
         *        <p>
         *        The policy size limit is 32 KiB (32768 bytes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * A description of the CMK.
         * </p>
         * <p>
         * Use a description that helps you decide whether the CMK is appropriate for a task.
         * </p>
         * 
         * @param description
         *        A description of the CMK.</p>
         *        <p>
         *        Use a description that helps you decide whether the CMK is appropriate for a task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The intended use of the CMK.
         * </p>
         * <p>
         * You can use CMKs only for symmetric encryption and decryption.
         * </p>
         * 
         * @param keyUsage
         *        The intended use of the CMK.</p>
         *        <p>
         *        You can use CMKs only for symmetric encryption and decryption.
         * @see KeyUsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyUsageType
         */
        Builder keyUsage(String keyUsage);

        /**
         * <p>
         * The intended use of the CMK.
         * </p>
         * <p>
         * You can use CMKs only for symmetric encryption and decryption.
         * </p>
         * 
         * @param keyUsage
         *        The intended use of the CMK.</p>
         *        <p>
         *        You can use CMKs only for symmetric encryption and decryption.
         * @see KeyUsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyUsageType
         */
        Builder keyUsage(KeyUsageType keyUsage);

        /**
         * <p>
         * The source of the CMK's key material.
         * </p>
         * <p>
         * The default is <code>AWS_KMS</code>, which means AWS KMS creates the key material. When this parameter is set
         * to <code>EXTERNAL</code>, the request creates a CMK without key material so that you can import key material
         * from your existing key management infrastructure. For more information about importing key material into AWS
         * KMS, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">Importing Key
         * Material</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * <p>
         * The CMK's <code>Origin</code> is immutable and is set when the CMK is created.
         * </p>
         * 
         * @param origin
         *        The source of the CMK's key material.</p>
         *        <p>
         *        The default is <code>AWS_KMS</code>, which means AWS KMS creates the key material. When this parameter
         *        is set to <code>EXTERNAL</code>, the request creates a CMK without key material so that you can import
         *        key material from your existing key management infrastructure. For more information about importing
         *        key material into AWS KMS, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">Importing Key
         *        Material</a> in the <i>AWS Key Management Service Developer Guide</i>.
         *        </p>
         *        <p>
         *        The CMK's <code>Origin</code> is immutable and is set when the CMK is created.
         * @see OriginType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginType
         */
        Builder origin(String origin);

        /**
         * <p>
         * The source of the CMK's key material.
         * </p>
         * <p>
         * The default is <code>AWS_KMS</code>, which means AWS KMS creates the key material. When this parameter is set
         * to <code>EXTERNAL</code>, the request creates a CMK without key material so that you can import key material
         * from your existing key management infrastructure. For more information about importing key material into AWS
         * KMS, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">Importing Key
         * Material</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * <p>
         * The CMK's <code>Origin</code> is immutable and is set when the CMK is created.
         * </p>
         * 
         * @param origin
         *        The source of the CMK's key material.</p>
         *        <p>
         *        The default is <code>AWS_KMS</code>, which means AWS KMS creates the key material. When this parameter
         *        is set to <code>EXTERNAL</code>, the request creates a CMK without key material so that you can import
         *        key material from your existing key management infrastructure. For more information about importing
         *        key material into AWS KMS, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">Importing Key
         *        Material</a> in the <i>AWS Key Management Service Developer Guide</i>.
         *        </p>
         *        <p>
         *        The CMK's <code>Origin</code> is immutable and is set when the CMK is created.
         * @see OriginType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginType
         */
        Builder origin(OriginType origin);

        /**
         * <p>
         * A flag to indicate whether to bypass the key policy lockout safety check.
         * </p>
         * <important>
         * <p>
         * Setting this value to true increases the likelihood that the CMK becomes unmanageable. Do not set this value
         * to true indiscriminately.
         * </p>
         * <p>
         * For more information, refer to the scenario in the <a href=
         * "http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
         * >Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * </important>
         * <p>
         * Use this parameter only when you include a policy in the request and you intend to prevent the principal that
         * is making the request from making a subsequent <a>PutKeyPolicy</a> request on the CMK.
         * </p>
         * <p>
         * The default value is false.
         * </p>
         * 
         * @param bypassPolicyLockoutSafetyCheck
         *        A flag to indicate whether to bypass the key policy lockout safety check.</p> <important>
         *        <p>
         *        Setting this value to true increases the likelihood that the CMK becomes unmanageable. Do not set this
         *        value to true indiscriminately.
         *        </p>
         *        <p>
         *        For more information, refer to the scenario in the <a href=
         *        "http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
         *        >Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.
         *        </p>
         *        </important>
         *        <p>
         *        Use this parameter only when you include a policy in the request and you intend to prevent the
         *        principal that is making the request from making a subsequent <a>PutKeyPolicy</a> request on the CMK.
         *        </p>
         *        <p>
         *        The default value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck);

        /**
         * <p>
         * One or more tags. Each tag consists of a tag key and a tag value. Tag keys and tag values are both required,
         * but tag values can be empty (null) strings.
         * </p>
         * <p>
         * Use this parameter to tag the CMK when it is created. Alternately, you can omit this parameter and instead
         * tag the CMK after it is created using <a>TagResource</a>.
         * </p>
         * 
         * @param tags
         *        One or more tags. Each tag consists of a tag key and a tag value. Tag keys and tag values are both
         *        required, but tag values can be empty (null) strings.</p>
         *        <p>
         *        Use this parameter to tag the CMK when it is created. Alternately, you can omit this parameter and
         *        instead tag the CMK after it is created using <a>TagResource</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tags. Each tag consists of a tag key and a tag value. Tag keys and tag values are both required,
         * but tag values can be empty (null) strings.
         * </p>
         * <p>
         * Use this parameter to tag the CMK when it is created. Alternately, you can omit this parameter and instead
         * tag the CMK after it is created using <a>TagResource</a>.
         * </p>
         * 
         * @param tags
         *        One or more tags. Each tag consists of a tag key and a tag value. Tag keys and tag values are both
         *        required, but tag values can be empty (null) strings.</p>
         *        <p>
         *        Use this parameter to tag the CMK when it is created. Alternately, you can omit this parameter and
         *        instead tag the CMK after it is created using <a>TagResource</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    private static final class BuilderImpl implements Builder {
        private String policy;

        private String description;

        private String keyUsage;

        private String origin;

        private Boolean bypassPolicyLockoutSafetyCheck;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyRequest model) {
            setPolicy(model.policy);
            setDescription(model.description);
            setKeyUsage(model.keyUsage);
            setOrigin(model.origin);
            setBypassPolicyLockoutSafetyCheck(model.bypassPolicyLockoutSafetyCheck);
            setTags(model.tags);
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKeyUsage() {
            return keyUsage;
        }

        @Override
        public final Builder keyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        @Override
        public final Builder keyUsage(KeyUsageType keyUsage) {
            this.keyUsage(keyUsage.toString());
            return this;
        }

        public final void setKeyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
        }

        public final void setKeyUsage(KeyUsageType keyUsage) {
            this.keyUsage(keyUsage.toString());
        }

        public final String getOrigin() {
            return origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(OriginType origin) {
            this.origin(origin.toString());
            return this;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        public final void setOrigin(OriginType origin) {
            this.origin(origin.toString());
        }

        public final Boolean getBypassPolicyLockoutSafetyCheck() {
            return bypassPolicyLockoutSafetyCheck;
        }

        @Override
        public final Builder bypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
            return this;
        }

        public final void setBypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag... tags) {
            tags(Arrays.asList(tags));
        }

        @Override
        public CreateKeyRequest build() {
            return new CreateKeyRequest(this);
        }
    }
}
