/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateGrantRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateGrantRequest.Builder, CreateGrantRequest> {
    private final String keyId;

    private final String granteePrincipal;

    private final String retiringPrincipal;

    private final List<String> operations;

    private final GrantConstraints constraints;

    private final List<String> grantTokens;

    private final String name;

    private CreateGrantRequest(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.granteePrincipal = builder.granteePrincipal;
        this.retiringPrincipal = builder.retiringPrincipal;
        this.operations = builder.operations;
        this.constraints = builder.constraints;
        this.grantTokens = builder.grantTokens;
        this.name = builder.name;
    }

    /**
     * <p>
     * The unique identifier for the customer master key (CMK) that the grant applies to.
     * </p>
     * <p>
     * To specify this value, use the globally unique key ID or the Amazon Resource Name (ARN) of the key. Examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Globally unique key ID: 12345678-1234-1234-1234-123456789012
     * </p>
     * </li>
     * <li>
     * <p>
     * Key ARN: arn:aws:kms:us-west-2:123456789012:key/12345678-1234-1234-1234-123456789012
     * </p>
     * </li>
     * </ul>
     * 
     * @return The unique identifier for the customer master key (CMK) that the grant applies to.</p>
     *         <p>
     *         To specify this value, use the globally unique key ID or the Amazon Resource Name (ARN) of the key.
     *         Examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Globally unique key ID: 12345678-1234-1234-1234-123456789012
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key ARN: arn:aws:kms:us-west-2:123456789012:key/12345678-1234-1234-1234-123456789012
     *         </p>
     *         </li>
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * The principal that is given permission to perform the operations that the grant permits.
     * </p>
     * <p>
     * To specify the principal, use the <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a>
     * of an AWS principal. Valid AWS principals include AWS accounts (root), IAM users, IAM roles, federated users, and
     * assumed role users. For examples of the ARN syntax to use for specifying a principal, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity and
     * Access Management (IAM)</a> in the Example ARNs section of the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The principal that is given permission to perform the operations that the grant permits.</p>
     *         <p>
     *         To specify the principal, use the <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> of an AWS principal. Valid AWS principals include AWS accounts (root), IAM users, IAM roles,
     *         federated users, and assumed role users. For examples of the ARN syntax to use for specifying a
     *         principal, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS
     *         Identity and Access Management (IAM)</a> in the Example ARNs section of the <i>AWS General Reference</i>.
     */
    public String granteePrincipal() {
        return granteePrincipal;
    }

    /**
     * <p>
     * The principal that is given permission to retire the grant by using <a>RetireGrant</a> operation.
     * </p>
     * <p>
     * To specify the principal, use the <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a>
     * of an AWS principal. Valid AWS principals include AWS accounts (root), IAM users, federated users, and assumed
     * role users. For examples of the ARN syntax to use for specifying a principal, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity and
     * Access Management (IAM)</a> in the Example ARNs section of the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The principal that is given permission to retire the grant by using <a>RetireGrant</a> operation.</p>
     *         <p>
     *         To specify the principal, use the <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> of an AWS principal. Valid AWS principals include AWS accounts (root), IAM users, federated
     *         users, and assumed role users. For examples of the ARN syntax to use for specifying a principal, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS
     *         Identity and Access Management (IAM)</a> in the Example ARNs section of the <i>AWS General Reference</i>.
     */
    public String retiringPrincipal() {
        return retiringPrincipal;
    }

    /**
     * <p>
     * A list of operations that the grant permits.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of operations that the grant permits.
     * @see GrantOperation
     */
    public List<String> operations() {
        return operations;
    }

    /**
     * <p>
     * A structure that you can use to allow certain operations in the grant only when the desired encryption context is
     * present. For more information about encryption context, see <a
     * href="http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html">Encryption Context</a> in the
     * <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * 
     * @return A structure that you can use to allow certain operations in the grant only when the desired encryption
     *         context is present. For more information about encryption context, see <a
     *         href="http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html">Encryption
     *         Context</a> in the <i>AWS Key Management Service Developer Guide</i>.
     */
    public GrantConstraints constraints() {
        return constraints;
    }

    /**
     * <p>
     * A list of grant tokens.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the
     * <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of grant tokens.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in
     *         the <i>AWS Key Management Service Developer Guide</i>.
     */
    public List<String> grantTokens() {
        return grantTokens;
    }

    /**
     * <p>
     * A friendly name for identifying the grant. Use this value to prevent unintended creation of duplicate grants when
     * retrying this request.
     * </p>
     * <p>
     * When this value is absent, all <code>CreateGrant</code> requests result in a new grant with a unique
     * <code>GrantId</code> even if all the supplied parameters are identical. This can result in unintended duplicates
     * when you retry the <code>CreateGrant</code> request.
     * </p>
     * <p>
     * When this value is present, you can retry a <code>CreateGrant</code> request with identical parameters; if the
     * grant already exists, the original <code>GrantId</code> is returned without creating a new grant. Note that the
     * returned grant token is unique with every <code>CreateGrant</code> request, even when a duplicate
     * <code>GrantId</code> is returned. All grant tokens obtained in this way can be used interchangeably.
     * </p>
     * 
     * @return A friendly name for identifying the grant. Use this value to prevent unintended creation of duplicate
     *         grants when retrying this request.</p>
     *         <p>
     *         When this value is absent, all <code>CreateGrant</code> requests result in a new grant with a unique
     *         <code>GrantId</code> even if all the supplied parameters are identical. This can result in unintended
     *         duplicates when you retry the <code>CreateGrant</code> request.
     *         </p>
     *         <p>
     *         When this value is present, you can retry a <code>CreateGrant</code> request with identical parameters;
     *         if the grant already exists, the original <code>GrantId</code> is returned without creating a new grant.
     *         Note that the returned grant token is unique with every <code>CreateGrant</code> request, even when a
     *         duplicate <code>GrantId</code> is returned. All grant tokens obtained in this way can be used
     *         interchangeably.
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyId() == null) ? 0 : keyId().hashCode());
        hashCode = 31 * hashCode + ((granteePrincipal() == null) ? 0 : granteePrincipal().hashCode());
        hashCode = 31 * hashCode + ((retiringPrincipal() == null) ? 0 : retiringPrincipal().hashCode());
        hashCode = 31 * hashCode + ((operations() == null) ? 0 : operations().hashCode());
        hashCode = 31 * hashCode + ((constraints() == null) ? 0 : constraints().hashCode());
        hashCode = 31 * hashCode + ((grantTokens() == null) ? 0 : grantTokens().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGrantRequest)) {
            return false;
        }
        CreateGrantRequest other = (CreateGrantRequest) obj;
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.granteePrincipal() == null ^ this.granteePrincipal() == null) {
            return false;
        }
        if (other.granteePrincipal() != null && !other.granteePrincipal().equals(this.granteePrincipal())) {
            return false;
        }
        if (other.retiringPrincipal() == null ^ this.retiringPrincipal() == null) {
            return false;
        }
        if (other.retiringPrincipal() != null && !other.retiringPrincipal().equals(this.retiringPrincipal())) {
            return false;
        }
        if (other.operations() == null ^ this.operations() == null) {
            return false;
        }
        if (other.operations() != null && !other.operations().equals(this.operations())) {
            return false;
        }
        if (other.constraints() == null ^ this.constraints() == null) {
            return false;
        }
        if (other.constraints() != null && !other.constraints().equals(this.constraints())) {
            return false;
        }
        if (other.grantTokens() == null ^ this.grantTokens() == null) {
            return false;
        }
        if (other.grantTokens() != null && !other.grantTokens().equals(this.grantTokens())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (keyId() != null) {
            sb.append("KeyId: ").append(keyId()).append(",");
        }
        if (granteePrincipal() != null) {
            sb.append("GranteePrincipal: ").append(granteePrincipal()).append(",");
        }
        if (retiringPrincipal() != null) {
            sb.append("RetiringPrincipal: ").append(retiringPrincipal()).append(",");
        }
        if (operations() != null) {
            sb.append("Operations: ").append(operations()).append(",");
        }
        if (constraints() != null) {
            sb.append("Constraints: ").append(constraints()).append(",");
        }
        if (grantTokens() != null) {
            sb.append("GrantTokens: ").append(grantTokens()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateGrantRequest> {
        /**
         * <p>
         * The unique identifier for the customer master key (CMK) that the grant applies to.
         * </p>
         * <p>
         * To specify this value, use the globally unique key ID or the Amazon Resource Name (ARN) of the key. Examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Globally unique key ID: 12345678-1234-1234-1234-123456789012
         * </p>
         * </li>
         * <li>
         * <p>
         * Key ARN: arn:aws:kms:us-west-2:123456789012:key/12345678-1234-1234-1234-123456789012
         * </p>
         * </li>
         * </ul>
         * 
         * @param keyId
         *        The unique identifier for the customer master key (CMK) that the grant applies to.</p>
         *        <p>
         *        To specify this value, use the globally unique key ID or the Amazon Resource Name (ARN) of the key.
         *        Examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Globally unique key ID: 12345678-1234-1234-1234-123456789012
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key ARN: arn:aws:kms:us-west-2:123456789012:key/12345678-1234-1234-1234-123456789012
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * The principal that is given permission to perform the operations that the grant permits.
         * </p>
         * <p>
         * To specify the principal, use the <a
         * href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN)</a> of an AWS principal. Valid AWS principals include AWS accounts (root), IAM users, IAM roles,
         * federated users, and assumed role users. For examples of the ARN syntax to use for specifying a principal,
         * see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS
         * Identity and Access Management (IAM)</a> in the Example ARNs section of the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param granteePrincipal
         *        The principal that is given permission to perform the operations that the grant permits.</p>
         *        <p>
         *        To specify the principal, use the <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         *        (ARN)</a> of an AWS principal. Valid AWS principals include AWS accounts (root), IAM users, IAM roles,
         *        federated users, and assumed role users. For examples of the ARN syntax to use for specifying a
         *        principal, see <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS
         *        Identity and Access Management (IAM)</a> in the Example ARNs section of the <i>AWS General
         *        Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder granteePrincipal(String granteePrincipal);

        /**
         * <p>
         * The principal that is given permission to retire the grant by using <a>RetireGrant</a> operation.
         * </p>
         * <p>
         * To specify the principal, use the <a
         * href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN)</a> of an AWS principal. Valid AWS principals include AWS accounts (root), IAM users, federated users,
         * and assumed role users. For examples of the ARN syntax to use for specifying a principal, see <a
         * href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity
         * and Access Management (IAM)</a> in the Example ARNs section of the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param retiringPrincipal
         *        The principal that is given permission to retire the grant by using <a>RetireGrant</a> operation.</p>
         *        <p>
         *        To specify the principal, use the <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         *        (ARN)</a> of an AWS principal. Valid AWS principals include AWS accounts (root), IAM users, federated
         *        users, and assumed role users. For examples of the ARN syntax to use for specifying a principal, see
         *        <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS
         *        Identity and Access Management (IAM)</a> in the Example ARNs section of the <i>AWS General
         *        Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retiringPrincipal(String retiringPrincipal);

        /**
         * <p>
         * A list of operations that the grant permits.
         * </p>
         * 
         * @param operations
         *        A list of operations that the grant permits.
         * @see GrantOperation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrantOperation
         */
        Builder operations(Collection<String> operations);

        /**
         * <p>
         * A list of operations that the grant permits.
         * </p>
         * 
         * @param operations
         *        A list of operations that the grant permits.
         * @see GrantOperation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrantOperation
         */
        Builder operations(String... operations);

        /**
         * <p>
         * A list of operations that the grant permits.
         * </p>
         * 
         * @param operations
         *        A list of operations that the grant permits.
         * @see GrantOperation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrantOperation
         */
        Builder operations(GrantOperation... operations);

        /**
         * <p>
         * A structure that you can use to allow certain operations in the grant only when the desired encryption
         * context is present. For more information about encryption context, see <a
         * href="http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html">Encryption Context</a> in
         * the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param constraints
         *        A structure that you can use to allow certain operations in the grant only when the desired encryption
         *        context is present. For more information about encryption context, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html">Encryption
         *        Context</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraints(GrantConstraints constraints);

        /**
         * <p>
         * A list of grant tokens.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the
         * <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param grantTokens
         *        A list of grant tokens.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a>
         *        in the <i>AWS Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantTokens(Collection<String> grantTokens);

        /**
         * <p>
         * A list of grant tokens.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the
         * <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param grantTokens
         *        A list of grant tokens.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a>
         *        in the <i>AWS Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantTokens(String... grantTokens);

        /**
         * <p>
         * A friendly name for identifying the grant. Use this value to prevent unintended creation of duplicate grants
         * when retrying this request.
         * </p>
         * <p>
         * When this value is absent, all <code>CreateGrant</code> requests result in a new grant with a unique
         * <code>GrantId</code> even if all the supplied parameters are identical. This can result in unintended
         * duplicates when you retry the <code>CreateGrant</code> request.
         * </p>
         * <p>
         * When this value is present, you can retry a <code>CreateGrant</code> request with identical parameters; if
         * the grant already exists, the original <code>GrantId</code> is returned without creating a new grant. Note
         * that the returned grant token is unique with every <code>CreateGrant</code> request, even when a duplicate
         * <code>GrantId</code> is returned. All grant tokens obtained in this way can be used interchangeably.
         * </p>
         * 
         * @param name
         *        A friendly name for identifying the grant. Use this value to prevent unintended creation of duplicate
         *        grants when retrying this request.</p>
         *        <p>
         *        When this value is absent, all <code>CreateGrant</code> requests result in a new grant with a unique
         *        <code>GrantId</code> even if all the supplied parameters are identical. This can result in unintended
         *        duplicates when you retry the <code>CreateGrant</code> request.
         *        </p>
         *        <p>
         *        When this value is present, you can retry a <code>CreateGrant</code> request with identical
         *        parameters; if the grant already exists, the original <code>GrantId</code> is returned without
         *        creating a new grant. Note that the returned grant token is unique with every <code>CreateGrant</code>
         *        request, even when a duplicate <code>GrantId</code> is returned. All grant tokens obtained in this way
         *        can be used interchangeably.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    private static final class BuilderImpl implements Builder {
        private String keyId;

        private String granteePrincipal;

        private String retiringPrincipal;

        private List<String> operations;

        private GrantConstraints constraints;

        private List<String> grantTokens;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGrantRequest model) {
            setKeyId(model.keyId);
            setGranteePrincipal(model.granteePrincipal);
            setRetiringPrincipal(model.retiringPrincipal);
            setOperations(model.operations);
            setConstraints(model.constraints);
            setGrantTokens(model.grantTokens);
            setName(model.name);
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getGranteePrincipal() {
            return granteePrincipal;
        }

        @Override
        public final Builder granteePrincipal(String granteePrincipal) {
            this.granteePrincipal = granteePrincipal;
            return this;
        }

        public final void setGranteePrincipal(String granteePrincipal) {
            this.granteePrincipal = granteePrincipal;
        }

        public final String getRetiringPrincipal() {
            return retiringPrincipal;
        }

        @Override
        public final Builder retiringPrincipal(String retiringPrincipal) {
            this.retiringPrincipal = retiringPrincipal;
            return this;
        }

        public final void setRetiringPrincipal(String retiringPrincipal) {
            this.retiringPrincipal = retiringPrincipal;
        }

        public final Collection<String> getOperations() {
            return operations;
        }

        @Override
        public final Builder operations(Collection<String> operations) {
            this.operations = GrantOperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(String... operations) {
            operations(Arrays.asList(operations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(GrantOperation... operations) {
            operations(Arrays.asList(operations).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setOperations(Collection<String> operations) {
            this.operations = GrantOperationListCopier.copy(operations);
        }

        @SafeVarargs
        public final void setOperations(String... operations) {
            operations(Arrays.asList(operations));
        }

        @SafeVarargs
        public final void setOperations(GrantOperation... operations) {
            operations(Arrays.asList(operations).stream().map(Object::toString).collect(Collectors.toList()));
        }

        public final GrantConstraints getConstraints() {
            return constraints;
        }

        @Override
        public final Builder constraints(GrantConstraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public final void setConstraints(GrantConstraints constraints) {
            this.constraints = constraints;
        }

        public final Collection<String> getGrantTokens() {
            return grantTokens;
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String... grantTokens) {
            grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        @SafeVarargs
        public final void setGrantTokens(String... grantTokens) {
            grantTokens(Arrays.asList(grantTokens));
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public CreateGrantRequest build() {
            return new CreateGrantRequest(this);
        }
    }
}
