/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateAliasRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateAliasRequest.Builder, CreateAliasRequest> {
    private final String aliasName;

    private final String targetKeyId;

    private CreateAliasRequest(BuilderImpl builder) {
        this.aliasName = builder.aliasName;
        this.targetKeyId = builder.targetKeyId;
    }

    /**
     * <p>
     * String that contains the display name. The name must start with the word "alias" followed by a forward slash
     * (alias/). Aliases that begin with "alias/AWS" are reserved.
     * </p>
     * 
     * @return String that contains the display name. The name must start with the word "alias" followed by a forward
     *         slash (alias/). Aliases that begin with "alias/AWS" are reserved.
     */
    public String aliasName() {
        return aliasName;
    }

    /**
     * <p>
     * An identifier of the key for which you are creating the alias. This value cannot be another alias but can be a
     * globally unique identifier or a fully specified ARN to a key.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
     * </p>
     * </li>
     * <li>
     * <p>
     * Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
     * </p>
     * </li>
     * </ul>
     * 
     * @return An identifier of the key for which you are creating the alias. This value cannot be another alias but can
     *         be a globally unique identifier or a fully specified ARN to a key.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
     *         </p>
     *         </li>
     */
    public String targetKeyId() {
        return targetKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((aliasName() == null) ? 0 : aliasName().hashCode());
        hashCode = 31 * hashCode + ((targetKeyId() == null) ? 0 : targetKeyId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAliasRequest)) {
            return false;
        }
        CreateAliasRequest other = (CreateAliasRequest) obj;
        if (other.aliasName() == null ^ this.aliasName() == null) {
            return false;
        }
        if (other.aliasName() != null && !other.aliasName().equals(this.aliasName())) {
            return false;
        }
        if (other.targetKeyId() == null ^ this.targetKeyId() == null) {
            return false;
        }
        if (other.targetKeyId() != null && !other.targetKeyId().equals(this.targetKeyId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (aliasName() != null) {
            sb.append("AliasName: ").append(aliasName()).append(",");
        }
        if (targetKeyId() != null) {
            sb.append("TargetKeyId: ").append(targetKeyId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateAliasRequest> {
        /**
         * <p>
         * String that contains the display name. The name must start with the word "alias" followed by a forward slash
         * (alias/). Aliases that begin with "alias/AWS" are reserved.
         * </p>
         * 
         * @param aliasName
         *        String that contains the display name. The name must start with the word "alias" followed by a forward
         *        slash (alias/). Aliases that begin with "alias/AWS" are reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasName(String aliasName);

        /**
         * <p>
         * An identifier of the key for which you are creating the alias. This value cannot be another alias but can be
         * a globally unique identifier or a fully specified ARN to a key.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
         * </p>
         * </li>
         * <li>
         * <p>
         * Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetKeyId
         *        An identifier of the key for which you are creating the alias. This value cannot be another alias but
         *        can be a globally unique identifier or a fully specified ARN to a key.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetKeyId(String targetKeyId);
    }

    private static final class BuilderImpl implements Builder {
        private String aliasName;

        private String targetKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAliasRequest model) {
            setAliasName(model.aliasName);
            setTargetKeyId(model.targetKeyId);
        }

        public final String getAliasName() {
            return aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        public final String getTargetKeyId() {
            return targetKeyId;
        }

        @Override
        public final Builder targetKeyId(String targetKeyId) {
            this.targetKeyId = targetKeyId;
            return this;
        }

        public final void setTargetKeyId(String targetKeyId) {
            this.targetKeyId = targetKeyId;
        }

        @Override
        public CreateAliasRequest build() {
            return new CreateAliasRequest(this);
        }
    }
}
