/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kms.model.ReEncryptRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReEncryptRequestModelMarshaller {
    private static final MarshallingInfo<SdkBytes> CIPHERTEXTBLOB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.SDK_BYTES).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CiphertextBlob").isBinary(false).build();
    private static final MarshallingInfo<Map> SOURCEENCRYPTIONCONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceEncryptionContext").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATIONKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationKeyId").isBinary(false).build();
    private static final MarshallingInfo<Map> DESTINATIONENCRYPTIONCONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationEncryptionContext").isBinary(false).build();
    private static final MarshallingInfo<List> GRANTTOKENS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrantTokens").isBinary(false).build();
    private static final ReEncryptRequestModelMarshaller INSTANCE = new ReEncryptRequestModelMarshaller();

    private ReEncryptRequestModelMarshaller() {
    }

    public static ReEncryptRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReEncryptRequest reEncryptRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)reEncryptRequest), (String)"reEncryptRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)reEncryptRequest.ciphertextBlob(), CIPHERTEXTBLOB_BINDING);
            protocolMarshaller.marshall(reEncryptRequest.sourceEncryptionContext(), SOURCEENCRYPTIONCONTEXT_BINDING);
            protocolMarshaller.marshall((Object)reEncryptRequest.destinationKeyId(), DESTINATIONKEYID_BINDING);
            protocolMarshaller.marshall(reEncryptRequest.destinationEncryptionContext(), DESTINATIONENCRYPTIONCONTEXT_BINDING);
            protocolMarshaller.marshall(reEncryptRequest.grantTokens(), GRANTTOKENS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

