/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kms.model.GrantConstraints;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GrantConstraintsMarshaller {
    private static final MarshallingInfo<Map> ENCRYPTIONCONTEXTSUBSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionContextSubset").isBinary(false).build();
    private static final MarshallingInfo<Map> ENCRYPTIONCONTEXTEQUALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionContextEquals").isBinary(false).build();
    private static final GrantConstraintsMarshaller INSTANCE = new GrantConstraintsMarshaller();

    private GrantConstraintsMarshaller() {
    }

    public static GrantConstraintsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GrantConstraints grantConstraints, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)grantConstraints, (String)"grantConstraints");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(grantConstraints.encryptionContextSubset(), ENCRYPTIONCONTEXTSUBSET_BINDING);
            protocolMarshaller.marshall(grantConstraints.encryptionContextEquals(), ENCRYPTIONCONTEXTEQUALS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

