/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.kms.model.GenerateRandomRequest;
import software.amazon.awssdk.services.kms.transform.GenerateRandomRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GenerateRandomRequestMarshaller
implements Marshaller<Request<GenerateRandomRequest>, GenerateRandomRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("TrentService.GenerateRandom").serviceName("KMS").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public GenerateRandomRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GenerateRandomRequest> marshall(GenerateRandomRequest generateRandomRequest) {
        Validate.paramNotNull((Object)((Object)generateRandomRequest), (String)"generateRandomRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)generateRandomRequest);
            protocolMarshaller.startMarshalling();
            GenerateRandomRequestModelMarshaller.getInstance().marshall(generateRandomRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

