/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kms.model.ImportKeyMaterialRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ImportKeyMaterialRequestModelMarshaller {
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").isBinary(false).build();
    private static final MarshallingInfo<SdkBytes> IMPORTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.SDK_BYTES).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImportToken").isBinary(false).build();
    private static final MarshallingInfo<SdkBytes> ENCRYPTEDKEYMATERIAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.SDK_BYTES).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptedKeyMaterial").isBinary(false).build();
    private static final MarshallingInfo<Instant> VALIDTO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidTo").isBinary(false).build();
    private static final MarshallingInfo<String> EXPIRATIONMODEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpirationModel").isBinary(false).build();
    private static final ImportKeyMaterialRequestModelMarshaller INSTANCE = new ImportKeyMaterialRequestModelMarshaller();

    private ImportKeyMaterialRequestModelMarshaller() {
    }

    public static ImportKeyMaterialRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ImportKeyMaterialRequest importKeyMaterialRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)importKeyMaterialRequest), (String)"importKeyMaterialRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)importKeyMaterialRequest.keyId(), KEYID_BINDING);
            protocolMarshaller.marshall((Object)importKeyMaterialRequest.importToken(), IMPORTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)importKeyMaterialRequest.encryptedKeyMaterial(), ENCRYPTEDKEYMATERIAL_BINDING);
            protocolMarshaller.marshall((Object)importKeyMaterialRequest.validTo(), VALIDTO_BINDING);
            protocolMarshaller.marshall((Object)importKeyMaterialRequest.expirationModelAsString(), EXPIRATIONMODEL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

