/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kms.model.KeyMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KeyMetadataMarshaller {
    private static final MarshallingInfo<String> AWSACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AWSAccountId").isBinary(false).build();
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> KEYUSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyUsage").isBinary(false).build();
    private static final MarshallingInfo<String> KEYSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyState").isBinary(false).build();
    private static final MarshallingInfo<Instant> DELETIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeletionDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> VALIDTO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidTo").isBinary(false).build();
    private static final MarshallingInfo<String> ORIGIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Origin").isBinary(false).build();
    private static final MarshallingInfo<String> EXPIRATIONMODEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpirationModel").isBinary(false).build();
    private static final MarshallingInfo<String> KEYMANAGER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyManager").isBinary(false).build();
    private static final KeyMetadataMarshaller INSTANCE = new KeyMetadataMarshaller();

    private KeyMetadataMarshaller() {
    }

    public static KeyMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KeyMetadata keyMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)keyMetadata, (String)"keyMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)keyMetadata.awsAccountId(), AWSACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)keyMetadata.keyId(), KEYID_BINDING);
            protocolMarshaller.marshall((Object)keyMetadata.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)keyMetadata.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)keyMetadata.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)keyMetadata.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)keyMetadata.keyUsageAsString(), KEYUSAGE_BINDING);
            protocolMarshaller.marshall((Object)keyMetadata.keyStateAsString(), KEYSTATE_BINDING);
            protocolMarshaller.marshall((Object)keyMetadata.deletionDate(), DELETIONDATE_BINDING);
            protocolMarshaller.marshall((Object)keyMetadata.validTo(), VALIDTO_BINDING);
            protocolMarshaller.marshall((Object)keyMetadata.originAsString(), ORIGIN_BINDING);
            protocolMarshaller.marshall((Object)keyMetadata.expirationModelAsString(), EXPIRATIONMODEL_BINDING);
            protocolMarshaller.marshall((Object)keyMetadata.keyManagerAsString(), KEYMANAGER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

