/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kms.model.ExpirationModelType;
import software.amazon.awssdk.services.kms.model.KeyManagerType;
import software.amazon.awssdk.services.kms.model.KeyState;
import software.amazon.awssdk.services.kms.model.KeyUsageType;
import software.amazon.awssdk.services.kms.model.OriginType;
import software.amazon.awssdk.services.kms.transform.KeyMetadataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class KeyMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, KeyMetadata> {
    private final String awsAccountId;
    private final String keyId;
    private final String arn;
    private final Instant creationDate;
    private final Boolean enabled;
    private final String description;
    private final String keyUsage;
    private final String keyState;
    private final Instant deletionDate;
    private final Instant validTo;
    private final String origin;
    private final String expirationModel;
    private final String keyManager;

    private KeyMetadata(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.keyId = builder.keyId;
        this.arn = builder.arn;
        this.creationDate = builder.creationDate;
        this.enabled = builder.enabled;
        this.description = builder.description;
        this.keyUsage = builder.keyUsage;
        this.keyState = builder.keyState;
        this.deletionDate = builder.deletionDate;
        this.validTo = builder.validTo;
        this.origin = builder.origin;
        this.expirationModel = builder.expirationModel;
        this.keyManager = builder.keyManager;
    }

    public String awsAccountId() {
        return this.awsAccountId;
    }

    public String keyId() {
        return this.keyId;
    }

    public String arn() {
        return this.arn;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String description() {
        return this.description;
    }

    public KeyUsageType keyUsage() {
        return KeyUsageType.fromValue(this.keyUsage);
    }

    public String keyUsageAsString() {
        return this.keyUsage;
    }

    public KeyState keyState() {
        return KeyState.fromValue(this.keyState);
    }

    public String keyStateAsString() {
        return this.keyState;
    }

    public Instant deletionDate() {
        return this.deletionDate;
    }

    public Instant validTo() {
        return this.validTo;
    }

    public OriginType origin() {
        return OriginType.fromValue(this.origin);
    }

    public String originAsString() {
        return this.origin;
    }

    public ExpirationModelType expirationModel() {
        return ExpirationModelType.fromValue(this.expirationModel);
    }

    public String expirationModelAsString() {
        return this.expirationModel;
    }

    public KeyManagerType keyManager() {
        return KeyManagerType.fromValue(this.keyManager);
    }

    public String keyManagerAsString() {
        return this.keyManager;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyUsageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.validTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyManagerAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyMetadata)) {
            return false;
        }
        KeyMetadata other = (KeyMetadata)obj;
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.keyUsageAsString(), other.keyUsageAsString()) && Objects.equals(this.keyStateAsString(), other.keyStateAsString()) && Objects.equals(this.deletionDate(), other.deletionDate()) && Objects.equals(this.validTo(), other.validTo()) && Objects.equals(this.originAsString(), other.originAsString()) && Objects.equals(this.expirationModelAsString(), other.expirationModelAsString()) && Objects.equals(this.keyManagerAsString(), other.keyManagerAsString());
    }

    public String toString() {
        return ToString.builder((String)"KeyMetadata").add("AWSAccountId", (Object)this.awsAccountId()).add("KeyId", (Object)this.keyId()).add("Arn", (Object)this.arn()).add("CreationDate", (Object)this.creationDate()).add("Enabled", (Object)this.enabled()).add("Description", (Object)this.description()).add("KeyUsage", (Object)this.keyUsageAsString()).add("KeyState", (Object)this.keyStateAsString()).add("DeletionDate", (Object)this.deletionDate()).add("ValidTo", (Object)this.validTo()).add("Origin", (Object)this.originAsString()).add("ExpirationModel", (Object)this.expirationModelAsString()).add("KeyManager", (Object)this.keyManagerAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AWSAccountId": {
                return Optional.of(clazz.cast(this.awsAccountId()));
            }
            case "KeyId": {
                return Optional.of(clazz.cast(this.keyId()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "CreationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "KeyUsage": {
                return Optional.of(clazz.cast(this.keyUsageAsString()));
            }
            case "KeyState": {
                return Optional.of(clazz.cast(this.keyStateAsString()));
            }
            case "DeletionDate": {
                return Optional.of(clazz.cast(this.deletionDate()));
            }
            case "ValidTo": {
                return Optional.of(clazz.cast(this.validTo()));
            }
            case "Origin": {
                return Optional.of(clazz.cast(this.originAsString()));
            }
            case "ExpirationModel": {
                return Optional.of(clazz.cast(this.expirationModelAsString()));
            }
            case "KeyManager": {
                return Optional.of(clazz.cast(this.keyManagerAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeyMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String keyId;
        private String arn;
        private Instant creationDate;
        private Boolean enabled;
        private String description;
        private String keyUsage;
        private String keyState;
        private Instant deletionDate;
        private Instant validTo;
        private String origin;
        private String expirationModel;
        private String keyManager;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyMetadata model) {
            this.awsAccountId(model.awsAccountId);
            this.keyId(model.keyId);
            this.arn(model.arn);
            this.creationDate(model.creationDate);
            this.enabled(model.enabled);
            this.description(model.description);
            this.keyUsage(model.keyUsage);
            this.keyState(model.keyState);
            this.deletionDate(model.deletionDate);
            this.validTo(model.validTo);
            this.origin(model.origin);
            this.expirationModel(model.expirationModel);
            this.keyManager(model.keyManager);
        }

        public final String getAWSAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAWSAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKeyUsage() {
            return this.keyUsage;
        }

        @Override
        public final Builder keyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        @Override
        public final Builder keyUsage(KeyUsageType keyUsage) {
            this.keyUsage(keyUsage.toString());
            return this;
        }

        public final void setKeyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
        }

        public final String getKeyState() {
            return this.keyState;
        }

        @Override
        public final Builder keyState(String keyState) {
            this.keyState = keyState;
            return this;
        }

        @Override
        public final Builder keyState(KeyState keyState) {
            this.keyState(keyState.toString());
            return this;
        }

        public final void setKeyState(String keyState) {
            this.keyState = keyState;
        }

        public final Instant getDeletionDate() {
            return this.deletionDate;
        }

        @Override
        public final Builder deletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
            return this;
        }

        public final void setDeletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
        }

        public final Instant getValidTo() {
            return this.validTo;
        }

        @Override
        public final Builder validTo(Instant validTo) {
            this.validTo = validTo;
            return this;
        }

        public final void setValidTo(Instant validTo) {
            this.validTo = validTo;
        }

        public final String getOrigin() {
            return this.origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(OriginType origin) {
            this.origin(origin.toString());
            return this;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        public final String getExpirationModel() {
            return this.expirationModel;
        }

        @Override
        public final Builder expirationModel(String expirationModel) {
            this.expirationModel = expirationModel;
            return this;
        }

        @Override
        public final Builder expirationModel(ExpirationModelType expirationModel) {
            this.expirationModel(expirationModel.toString());
            return this;
        }

        public final void setExpirationModel(String expirationModel) {
            this.expirationModel = expirationModel;
        }

        public final String getKeyManager() {
            return this.keyManager;
        }

        @Override
        public final Builder keyManager(String keyManager) {
            this.keyManager = keyManager;
            return this;
        }

        @Override
        public final Builder keyManager(KeyManagerType keyManager) {
            this.keyManager(keyManager.toString());
            return this;
        }

        public final void setKeyManager(String keyManager) {
            this.keyManager = keyManager;
        }

        public KeyMetadata build() {
            return new KeyMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KeyMetadata> {
        public Builder awsAccountId(String var1);

        public Builder keyId(String var1);

        public Builder arn(String var1);

        public Builder creationDate(Instant var1);

        public Builder enabled(Boolean var1);

        public Builder description(String var1);

        public Builder keyUsage(String var1);

        public Builder keyUsage(KeyUsageType var1);

        public Builder keyState(String var1);

        public Builder keyState(KeyState var1);

        public Builder deletionDate(Instant var1);

        public Builder validTo(Instant var1);

        public Builder origin(String var1);

        public Builder origin(OriginType var1);

        public Builder expirationModel(String var1);

        public Builder expirationModel(ExpirationModelType var1);

        public Builder keyManager(String var1);

        public Builder keyManager(KeyManagerType var1);
    }
}

