/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.kms.model.AlgorithmSpec;
import software.amazon.awssdk.services.kms.model.KMSRequest;
import software.amazon.awssdk.services.kms.model.WrappingKeySpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetParametersForImportRequest
extends KMSRequest
implements ToCopyableBuilder<Builder, GetParametersForImportRequest> {
    private final String keyId;
    private final String wrappingAlgorithm;
    private final String wrappingKeySpec;

    private GetParametersForImportRequest(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.wrappingAlgorithm = builder.wrappingAlgorithm;
        this.wrappingKeySpec = builder.wrappingKeySpec;
    }

    public String keyId() {
        return this.keyId;
    }

    public AlgorithmSpec wrappingAlgorithm() {
        return AlgorithmSpec.fromValue(this.wrappingAlgorithm);
    }

    public String wrappingAlgorithmAsString() {
        return this.wrappingAlgorithm;
    }

    public WrappingKeySpec wrappingKeySpec() {
        return WrappingKeySpec.fromValue(this.wrappingKeySpec);
    }

    public String wrappingKeySpecAsString() {
        return this.wrappingKeySpec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappingAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappingKeySpecAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersForImportRequest)) {
            return false;
        }
        GetParametersForImportRequest other = (GetParametersForImportRequest)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.wrappingAlgorithmAsString(), other.wrappingAlgorithmAsString()) && Objects.equals(this.wrappingKeySpecAsString(), other.wrappingKeySpecAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetParametersForImportRequest").add("KeyId", (Object)this.keyId()).add("WrappingAlgorithm", (Object)this.wrappingAlgorithmAsString()).add("WrappingKeySpec", (Object)this.wrappingKeySpecAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.of(clazz.cast(this.keyId()));
            }
            case "WrappingAlgorithm": {
                return Optional.of(clazz.cast(this.wrappingAlgorithmAsString()));
            }
            case "WrappingKeySpec": {
                return Optional.of(clazz.cast(this.wrappingKeySpecAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KMSRequest.BuilderImpl
    implements Builder {
        private String keyId;
        private String wrappingAlgorithm;
        private String wrappingKeySpec;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersForImportRequest model) {
            super(model);
            this.keyId(model.keyId);
            this.wrappingAlgorithm(model.wrappingAlgorithm);
            this.wrappingKeySpec(model.wrappingKeySpec);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getWrappingAlgorithm() {
            return this.wrappingAlgorithm;
        }

        @Override
        public final Builder wrappingAlgorithm(String wrappingAlgorithm) {
            this.wrappingAlgorithm = wrappingAlgorithm;
            return this;
        }

        @Override
        public final Builder wrappingAlgorithm(AlgorithmSpec wrappingAlgorithm) {
            this.wrappingAlgorithm(wrappingAlgorithm.toString());
            return this;
        }

        public final void setWrappingAlgorithm(String wrappingAlgorithm) {
            this.wrappingAlgorithm = wrappingAlgorithm;
        }

        public final String getWrappingKeySpec() {
            return this.wrappingKeySpec;
        }

        @Override
        public final Builder wrappingKeySpec(String wrappingKeySpec) {
            this.wrappingKeySpec = wrappingKeySpec;
            return this;
        }

        @Override
        public final Builder wrappingKeySpec(WrappingKeySpec wrappingKeySpec) {
            this.wrappingKeySpec(wrappingKeySpec.toString());
            return this;
        }

        public final void setWrappingKeySpec(String wrappingKeySpec) {
            this.wrappingKeySpec = wrappingKeySpec;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetParametersForImportRequest build() {
            return new GetParametersForImportRequest(this);
        }
    }

    public static interface Builder
    extends KMSRequest.Builder,
    CopyableBuilder<Builder, GetParametersForImportRequest> {
        public Builder keyId(String var1);

        public Builder wrappingAlgorithm(String var1);

        public Builder wrappingAlgorithm(AlgorithmSpec var1);

        public Builder wrappingKeySpec(String var1);

        public Builder wrappingKeySpec(WrappingKeySpec var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

