/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.kms.model.KMSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateAliasRequest
extends KMSRequest
implements ToCopyableBuilder<Builder, CreateAliasRequest> {
    private final String aliasName;
    private final String targetKeyId;

    private CreateAliasRequest(BuilderImpl builder) {
        super(builder);
        this.aliasName = builder.aliasName;
        this.targetKeyId = builder.targetKeyId;
    }

    public String aliasName() {
        return this.aliasName;
    }

    public String targetKeyId() {
        return this.targetKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAliasRequest)) {
            return false;
        }
        CreateAliasRequest other = (CreateAliasRequest)((Object)obj);
        return Objects.equals(this.aliasName(), other.aliasName()) && Objects.equals(this.targetKeyId(), other.targetKeyId());
    }

    public String toString() {
        return ToString.builder((String)"CreateAliasRequest").add("AliasName", (Object)this.aliasName()).add("TargetKeyId", (Object)this.targetKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AliasName": {
                return Optional.of(clazz.cast(this.aliasName()));
            }
            case "TargetKeyId": {
                return Optional.of(clazz.cast(this.targetKeyId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KMSRequest.BuilderImpl
    implements Builder {
        private String aliasName;
        private String targetKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAliasRequest model) {
            super(model);
            this.aliasName(model.aliasName);
            this.targetKeyId(model.targetKeyId);
        }

        public final String getAliasName() {
            return this.aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        public final String getTargetKeyId() {
            return this.targetKeyId;
        }

        @Override
        public final Builder targetKeyId(String targetKeyId) {
            this.targetKeyId = targetKeyId;
            return this;
        }

        public final void setTargetKeyId(String targetKeyId) {
            this.targetKeyId = targetKeyId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateAliasRequest build() {
            return new CreateAliasRequest(this);
        }
    }

    public static interface Builder
    extends KMSRequest.Builder,
    CopyableBuilder<Builder, CreateAliasRequest> {
        public Builder aliasName(String var1);

        public Builder targetKeyId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

