/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOption;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionsCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Request;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.Tag;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationRequest
extends KinesisAnalyticsV2Request
implements ToCopyableBuilder<Builder, CreateApplicationRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApplicationRequest.getter(CreateApplicationRequest::applicationName)).setter(CreateApplicationRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> APPLICATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApplicationRequest.getter(CreateApplicationRequest::applicationDescription)).setter(CreateApplicationRequest.setter(Builder::applicationDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationDescription").build()}).build();
    private static final SdkField<String> RUNTIME_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApplicationRequest.getter(CreateApplicationRequest::runtimeEnvironmentAsString)).setter(CreateApplicationRequest.setter(Builder::runtimeEnvironment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeEnvironment").build()}).build();
    private static final SdkField<String> SERVICE_EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApplicationRequest.getter(CreateApplicationRequest::serviceExecutionRole)).setter(CreateApplicationRequest.setter(Builder::serviceExecutionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceExecutionRole").build()}).build();
    private static final SdkField<ApplicationConfiguration> APPLICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateApplicationRequest.getter(CreateApplicationRequest::applicationConfiguration)).setter(CreateApplicationRequest.setter(Builder::applicationConfiguration)).constructor(ApplicationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationConfiguration").build()}).build();
    private static final SdkField<List<CloudWatchLoggingOption>> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateApplicationRequest.getter(CreateApplicationRequest::cloudWatchLoggingOptions)).setter(CreateApplicationRequest.setter(Builder::cloudWatchLoggingOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudWatchLoggingOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateApplicationRequest.getter(CreateApplicationRequest::tags)).setter(CreateApplicationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, APPLICATION_DESCRIPTION_FIELD, RUNTIME_ENVIRONMENT_FIELD, SERVICE_EXECUTION_ROLE_FIELD, APPLICATION_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, TAGS_FIELD));
    private final String applicationName;
    private final String applicationDescription;
    private final String runtimeEnvironment;
    private final String serviceExecutionRole;
    private final ApplicationConfiguration applicationConfiguration;
    private final List<CloudWatchLoggingOption> cloudWatchLoggingOptions;
    private final List<Tag> tags;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.applicationDescription = builder.applicationDescription;
        this.runtimeEnvironment = builder.runtimeEnvironment;
        this.serviceExecutionRole = builder.serviceExecutionRole;
        this.applicationConfiguration = builder.applicationConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.tags = builder.tags;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String applicationDescription() {
        return this.applicationDescription;
    }

    public RuntimeEnvironment runtimeEnvironment() {
        return RuntimeEnvironment.fromValue(this.runtimeEnvironment);
    }

    public String runtimeEnvironmentAsString() {
        return this.runtimeEnvironment;
    }

    public String serviceExecutionRole() {
        return this.serviceExecutionRole;
    }

    public ApplicationConfiguration applicationConfiguration() {
        return this.applicationConfiguration;
    }

    public List<CloudWatchLoggingOption> cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeEnvironmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceExecutionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.applicationDescription(), other.applicationDescription()) && Objects.equals(this.runtimeEnvironmentAsString(), other.runtimeEnvironmentAsString()) && Objects.equals(this.serviceExecutionRole(), other.serviceExecutionRole()) && Objects.equals(this.applicationConfiguration(), other.applicationConfiguration()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateApplicationRequest").add("ApplicationName", (Object)this.applicationName()).add("ApplicationDescription", (Object)this.applicationDescription()).add("RuntimeEnvironment", (Object)this.runtimeEnvironmentAsString()).add("ServiceExecutionRole", (Object)this.serviceExecutionRole()).add("ApplicationConfiguration", (Object)this.applicationConfiguration()).add("CloudWatchLoggingOptions", this.cloudWatchLoggingOptions()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "ApplicationDescription": {
                return Optional.ofNullable(clazz.cast(this.applicationDescription()));
            }
            case "RuntimeEnvironment": {
                return Optional.ofNullable(clazz.cast(this.runtimeEnvironmentAsString()));
            }
            case "ServiceExecutionRole": {
                return Optional.ofNullable(clazz.cast(this.serviceExecutionRole()));
            }
            case "ApplicationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.applicationConfiguration()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Request.BuilderImpl
    implements Builder {
        private String applicationName;
        private String applicationDescription;
        private String runtimeEnvironment;
        private String serviceExecutionRole;
        private ApplicationConfiguration applicationConfiguration;
        private List<CloudWatchLoggingOption> cloudWatchLoggingOptions = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.applicationDescription(model.applicationDescription);
            this.runtimeEnvironment(model.runtimeEnvironment);
            this.serviceExecutionRole(model.serviceExecutionRole);
            this.applicationConfiguration(model.applicationConfiguration);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.tags(model.tags);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getApplicationDescription() {
            return this.applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        public final String getRuntimeEnvironmentAsString() {
            return this.runtimeEnvironment;
        }

        @Override
        public final Builder runtimeEnvironment(String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
            return this;
        }

        @Override
        public final Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
            this.runtimeEnvironment(runtimeEnvironment.toString());
            return this;
        }

        public final void setRuntimeEnvironment(String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
        }

        public final String getServiceExecutionRole() {
            return this.serviceExecutionRole;
        }

        @Override
        public final Builder serviceExecutionRole(String serviceExecutionRole) {
            this.serviceExecutionRole = serviceExecutionRole;
            return this;
        }

        public final void setServiceExecutionRole(String serviceExecutionRole) {
            this.serviceExecutionRole = serviceExecutionRole;
        }

        public final ApplicationConfiguration.Builder getApplicationConfiguration() {
            return this.applicationConfiguration != null ? this.applicationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder applicationConfiguration(ApplicationConfiguration applicationConfiguration) {
            this.applicationConfiguration = applicationConfiguration;
            return this;
        }

        public final void setApplicationConfiguration(ApplicationConfiguration.BuilderImpl applicationConfiguration) {
            this.applicationConfiguration = applicationConfiguration != null ? applicationConfiguration.build() : null;
        }

        public final Collection<CloudWatchLoggingOption.Builder> getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? (Collection)this.cloudWatchLoggingOptions.stream().map(CloudWatchLoggingOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = CloudWatchLoggingOptionsCopier.copy(cloudWatchLoggingOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOption ... cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions(Arrays.asList(cloudWatchLoggingOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOption.Builder> ... cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions(Stream.of(cloudWatchLoggingOptions).map(c -> (CloudWatchLoggingOption)((CloudWatchLoggingOption.Builder)CloudWatchLoggingOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCloudWatchLoggingOptions(Collection<CloudWatchLoggingOption.BuilderImpl> cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = CloudWatchLoggingOptionsCopier.copyFromBuilder(cloudWatchLoggingOptions);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationRequest> {
        public Builder applicationName(String var1);

        public Builder applicationDescription(String var1);

        public Builder runtimeEnvironment(String var1);

        public Builder runtimeEnvironment(RuntimeEnvironment var1);

        public Builder serviceExecutionRole(String var1);

        public Builder applicationConfiguration(ApplicationConfiguration var1);

        default public Builder applicationConfiguration(Consumer<ApplicationConfiguration.Builder> applicationConfiguration) {
            return this.applicationConfiguration((ApplicationConfiguration)((ApplicationConfiguration.Builder)ApplicationConfiguration.builder().applyMutation(applicationConfiguration)).build());
        }

        public Builder cloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> var1);

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOption ... var1);

        public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOption.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

