/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ConfigurationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckpointConfigurationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CheckpointConfigurationDescription> {
    private static final SdkField<String> CONFIGURATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CheckpointConfigurationDescription.getter(CheckpointConfigurationDescription::configurationTypeAsString)).setter(CheckpointConfigurationDescription.setter(Builder::configurationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationType").build()}).build();
    private static final SdkField<Boolean> CHECKPOINTING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CheckpointConfigurationDescription.getter(CheckpointConfigurationDescription::checkpointingEnabled)).setter(CheckpointConfigurationDescription.setter(Builder::checkpointingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointingEnabled").build()}).build();
    private static final SdkField<Long> CHECKPOINT_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(CheckpointConfigurationDescription.getter(CheckpointConfigurationDescription::checkpointInterval)).setter(CheckpointConfigurationDescription.setter(Builder::checkpointInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointInterval").build()}).build();
    private static final SdkField<Long> MIN_PAUSE_BETWEEN_CHECKPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(CheckpointConfigurationDescription.getter(CheckpointConfigurationDescription::minPauseBetweenCheckpoints)).setter(CheckpointConfigurationDescription.setter(Builder::minPauseBetweenCheckpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinPauseBetweenCheckpoints").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_TYPE_FIELD, CHECKPOINTING_ENABLED_FIELD, CHECKPOINT_INTERVAL_FIELD, MIN_PAUSE_BETWEEN_CHECKPOINTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String configurationType;
    private final Boolean checkpointingEnabled;
    private final Long checkpointInterval;
    private final Long minPauseBetweenCheckpoints;

    private CheckpointConfigurationDescription(BuilderImpl builder) {
        this.configurationType = builder.configurationType;
        this.checkpointingEnabled = builder.checkpointingEnabled;
        this.checkpointInterval = builder.checkpointInterval;
        this.minPauseBetweenCheckpoints = builder.minPauseBetweenCheckpoints;
    }

    public ConfigurationType configurationType() {
        return ConfigurationType.fromValue(this.configurationType);
    }

    public String configurationTypeAsString() {
        return this.configurationType;
    }

    public Boolean checkpointingEnabled() {
        return this.checkpointingEnabled;
    }

    public Long checkpointInterval() {
        return this.checkpointInterval;
    }

    public Long minPauseBetweenCheckpoints() {
        return this.minPauseBetweenCheckpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkpointingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkpointInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.minPauseBetweenCheckpoints());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckpointConfigurationDescription)) {
            return false;
        }
        CheckpointConfigurationDescription other = (CheckpointConfigurationDescription)obj;
        return Objects.equals(this.configurationTypeAsString(), other.configurationTypeAsString()) && Objects.equals(this.checkpointingEnabled(), other.checkpointingEnabled()) && Objects.equals(this.checkpointInterval(), other.checkpointInterval()) && Objects.equals(this.minPauseBetweenCheckpoints(), other.minPauseBetweenCheckpoints());
    }

    public String toString() {
        return ToString.builder((String)"CheckpointConfigurationDescription").add("ConfigurationType", (Object)this.configurationTypeAsString()).add("CheckpointingEnabled", (Object)this.checkpointingEnabled()).add("CheckpointInterval", (Object)this.checkpointInterval()).add("MinPauseBetweenCheckpoints", (Object)this.minPauseBetweenCheckpoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationType": {
                return Optional.ofNullable(clazz.cast(this.configurationTypeAsString()));
            }
            case "CheckpointingEnabled": {
                return Optional.ofNullable(clazz.cast(this.checkpointingEnabled()));
            }
            case "CheckpointInterval": {
                return Optional.ofNullable(clazz.cast(this.checkpointInterval()));
            }
            case "MinPauseBetweenCheckpoints": {
                return Optional.ofNullable(clazz.cast(this.minPauseBetweenCheckpoints()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckpointConfigurationDescription, T> g) {
        return obj -> g.apply((CheckpointConfigurationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationType;
        private Boolean checkpointingEnabled;
        private Long checkpointInterval;
        private Long minPauseBetweenCheckpoints;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckpointConfigurationDescription model) {
            this.configurationType(model.configurationType);
            this.checkpointingEnabled(model.checkpointingEnabled);
            this.checkpointInterval(model.checkpointInterval);
            this.minPauseBetweenCheckpoints(model.minPauseBetweenCheckpoints);
        }

        public final String getConfigurationTypeAsString() {
            return this.configurationType;
        }

        @Override
        public final Builder configurationType(String configurationType) {
            this.configurationType = configurationType;
            return this;
        }

        @Override
        public final Builder configurationType(ConfigurationType configurationType) {
            this.configurationType(configurationType.toString());
            return this;
        }

        public final void setConfigurationType(String configurationType) {
            this.configurationType = configurationType;
        }

        public final Boolean getCheckpointingEnabled() {
            return this.checkpointingEnabled;
        }

        @Override
        public final Builder checkpointingEnabled(Boolean checkpointingEnabled) {
            this.checkpointingEnabled = checkpointingEnabled;
            return this;
        }

        public final void setCheckpointingEnabled(Boolean checkpointingEnabled) {
            this.checkpointingEnabled = checkpointingEnabled;
        }

        public final Long getCheckpointInterval() {
            return this.checkpointInterval;
        }

        @Override
        public final Builder checkpointInterval(Long checkpointInterval) {
            this.checkpointInterval = checkpointInterval;
            return this;
        }

        public final void setCheckpointInterval(Long checkpointInterval) {
            this.checkpointInterval = checkpointInterval;
        }

        public final Long getMinPauseBetweenCheckpoints() {
            return this.minPauseBetweenCheckpoints;
        }

        @Override
        public final Builder minPauseBetweenCheckpoints(Long minPauseBetweenCheckpoints) {
            this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
            return this;
        }

        public final void setMinPauseBetweenCheckpoints(Long minPauseBetweenCheckpoints) {
            this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
        }

        public CheckpointConfigurationDescription build() {
            return new CheckpointConfigurationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CheckpointConfigurationDescription> {
        public Builder configurationType(String var1);

        public Builder configurationType(ConfigurationType var1);

        public Builder checkpointingEnabled(Boolean var1);

        public Builder checkpointInterval(Long var1);

        public Builder minPauseBetweenCheckpoints(Long var1);
    }
}

