/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteApplicationInputProcessingConfigurationResponse
extends KinesisAnalyticsV2Response
implements ToCopyableBuilder<Builder, DeleteApplicationInputProcessingConfigurationResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteApplicationInputProcessingConfigurationResponse.getter(DeleteApplicationInputProcessingConfigurationResponse::applicationARN)).setter(DeleteApplicationInputProcessingConfigurationResponse.setter(Builder::applicationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()}).build();
    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DeleteApplicationInputProcessingConfigurationResponse.getter(DeleteApplicationInputProcessingConfigurationResponse::applicationVersionId)).setter(DeleteApplicationInputProcessingConfigurationResponse.setter(Builder::applicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, APPLICATION_VERSION_ID_FIELD));
    private final String applicationARN;
    private final Long applicationVersionId;

    private DeleteApplicationInputProcessingConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationARN = builder.applicationARN;
        this.applicationVersionId = builder.applicationVersionId;
    }

    public String applicationARN() {
        return this.applicationARN;
    }

    public Long applicationVersionId() {
        return this.applicationVersionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationInputProcessingConfigurationResponse)) {
            return false;
        }
        DeleteApplicationInputProcessingConfigurationResponse other = (DeleteApplicationInputProcessingConfigurationResponse)((Object)obj);
        return Objects.equals(this.applicationARN(), other.applicationARN()) && Objects.equals(this.applicationVersionId(), other.applicationVersionId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteApplicationInputProcessingConfigurationResponse").add("ApplicationARN", (Object)this.applicationARN()).add("ApplicationVersionId", (Object)this.applicationVersionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationARN": {
                return Optional.ofNullable(clazz.cast(this.applicationARN()));
            }
            case "ApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteApplicationInputProcessingConfigurationResponse, T> g) {
        return obj -> g.apply((DeleteApplicationInputProcessingConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Response.BuilderImpl
    implements Builder {
        private String applicationARN;
        private Long applicationVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationInputProcessingConfigurationResponse model) {
            super(model);
            this.applicationARN(model.applicationARN);
            this.applicationVersionId(model.applicationVersionId);
        }

        public final String getApplicationARN() {
            return this.applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        public final Long getApplicationVersionId() {
            return this.applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        @Override
        public DeleteApplicationInputProcessingConfigurationResponse build() {
            return new DeleteApplicationInputProcessingConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteApplicationInputProcessingConfigurationResponse> {
        public Builder applicationARN(String var1);

        public Builder applicationVersionId(Long var1);
    }
}

