/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordColumn;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordColumnsCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceSchema
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceSchema> {
    private static final SdkField<RecordFormat> RECORD_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SourceSchema.getter(SourceSchema::recordFormat)).setter(SourceSchema.setter(Builder::recordFormat)).constructor(RecordFormat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordFormat").build()}).build();
    private static final SdkField<String> RECORD_ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SourceSchema.getter(SourceSchema::recordEncoding)).setter(SourceSchema.setter(Builder::recordEncoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordEncoding").build()}).build();
    private static final SdkField<List<RecordColumn>> RECORD_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SourceSchema.getter(SourceSchema::recordColumns)).setter(SourceSchema.setter(Builder::recordColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecordColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_FORMAT_FIELD, RECORD_ENCODING_FIELD, RECORD_COLUMNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final RecordFormat recordFormat;
    private final String recordEncoding;
    private final List<RecordColumn> recordColumns;

    private SourceSchema(BuilderImpl builder) {
        this.recordFormat = builder.recordFormat;
        this.recordEncoding = builder.recordEncoding;
        this.recordColumns = builder.recordColumns;
    }

    public RecordFormat recordFormat() {
        return this.recordFormat;
    }

    public String recordEncoding() {
        return this.recordEncoding;
    }

    public List<RecordColumn> recordColumns() {
        return this.recordColumns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordEncoding());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordColumns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceSchema)) {
            return false;
        }
        SourceSchema other = (SourceSchema)obj;
        return Objects.equals(this.recordFormat(), other.recordFormat()) && Objects.equals(this.recordEncoding(), other.recordEncoding()) && Objects.equals(this.recordColumns(), other.recordColumns());
    }

    public String toString() {
        return ToString.builder((String)"SourceSchema").add("RecordFormat", (Object)this.recordFormat()).add("RecordEncoding", (Object)this.recordEncoding()).add("RecordColumns", this.recordColumns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordFormat": {
                return Optional.ofNullable(clazz.cast(this.recordFormat()));
            }
            case "RecordEncoding": {
                return Optional.ofNullable(clazz.cast(this.recordEncoding()));
            }
            case "RecordColumns": {
                return Optional.ofNullable(clazz.cast(this.recordColumns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceSchema, T> g) {
        return obj -> g.apply((SourceSchema)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RecordFormat recordFormat;
        private String recordEncoding;
        private List<RecordColumn> recordColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SourceSchema model) {
            this.recordFormat(model.recordFormat);
            this.recordEncoding(model.recordEncoding);
            this.recordColumns(model.recordColumns);
        }

        public final RecordFormat.Builder getRecordFormat() {
            return this.recordFormat != null ? this.recordFormat.toBuilder() : null;
        }

        @Override
        public final Builder recordFormat(RecordFormat recordFormat) {
            this.recordFormat = recordFormat;
            return this;
        }

        public final void setRecordFormat(RecordFormat.BuilderImpl recordFormat) {
            this.recordFormat = recordFormat != null ? recordFormat.build() : null;
        }

        public final String getRecordEncoding() {
            return this.recordEncoding;
        }

        @Override
        public final Builder recordEncoding(String recordEncoding) {
            this.recordEncoding = recordEncoding;
            return this;
        }

        public final void setRecordEncoding(String recordEncoding) {
            this.recordEncoding = recordEncoding;
        }

        public final Collection<RecordColumn.Builder> getRecordColumns() {
            return this.recordColumns != null ? (Collection)this.recordColumns.stream().map(RecordColumn::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recordColumns(Collection<RecordColumn> recordColumns) {
            this.recordColumns = RecordColumnsCopier.copy(recordColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordColumns(RecordColumn ... recordColumns) {
            this.recordColumns(Arrays.asList(recordColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordColumns(Consumer<RecordColumn.Builder> ... recordColumns) {
            this.recordColumns(Stream.of(recordColumns).map(c -> (RecordColumn)((RecordColumn.Builder)RecordColumn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecordColumns(Collection<RecordColumn.BuilderImpl> recordColumns) {
            this.recordColumns = RecordColumnsCopier.copyFromBuilder(recordColumns);
        }

        public SourceSchema build() {
            return new SourceSchema(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceSchema> {
        public Builder recordFormat(RecordFormat var1);

        default public Builder recordFormat(Consumer<RecordFormat.Builder> recordFormat) {
            return this.recordFormat((RecordFormat)((RecordFormat.Builder)RecordFormat.builder().applyMutation(recordFormat)).build());
        }

        public Builder recordEncoding(String var1);

        public Builder recordColumns(Collection<RecordColumn> var1);

        public Builder recordColumns(RecordColumn ... var1);

        public Builder recordColumns(Consumer<RecordColumn.Builder> ... var1);
    }
}

