/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ReferenceDataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ReferenceDataSource> {
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketARN").getter(S3ReferenceDataSource.getter(S3ReferenceDataSource::bucketARN)).setter(S3ReferenceDataSource.setter(Builder::bucketARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketARN").build()}).build();
    private static final SdkField<String> FILE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileKey").getter(S3ReferenceDataSource.getter(S3ReferenceDataSource::fileKey)).setter(S3ReferenceDataSource.setter(Builder::fileKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_FIELD, FILE_KEY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketARN;
    private final String fileKey;

    private S3ReferenceDataSource(BuilderImpl builder) {
        this.bucketARN = builder.bucketARN;
        this.fileKey = builder.fileKey;
    }

    public final String bucketARN() {
        return this.bucketARN;
    }

    public final String fileKey() {
        return this.fileKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ReferenceDataSource)) {
            return false;
        }
        S3ReferenceDataSource other = (S3ReferenceDataSource)obj;
        return Objects.equals(this.bucketARN(), other.bucketARN()) && Objects.equals(this.fileKey(), other.fileKey());
    }

    public final String toString() {
        return ToString.builder((String)"S3ReferenceDataSource").add("BucketARN", (Object)this.bucketARN()).add("FileKey", (Object)this.fileKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketARN": {
                return Optional.ofNullable(clazz.cast(this.bucketARN()));
            }
            case "FileKey": {
                return Optional.ofNullable(clazz.cast(this.fileKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ReferenceDataSource, T> g) {
        return obj -> g.apply((S3ReferenceDataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketARN;
        private String fileKey;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ReferenceDataSource model) {
            this.bucketARN(model.bucketARN);
            this.fileKey(model.fileKey);
        }

        public final String getBucketARN() {
            return this.bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        public final String getFileKey() {
            return this.fileKey;
        }

        @Override
        public final Builder fileKey(String fileKey) {
            this.fileKey = fileKey;
            return this;
        }

        public final void setFileKey(String fileKey) {
            this.fileKey = fileKey;
        }

        public S3ReferenceDataSource build() {
            return new S3ReferenceDataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ReferenceDataSource> {
        public Builder bucketARN(String var1);

        public Builder fileKey(String var1);
    }
}

