/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an update for the Amazon S3 code content location for a Flink-based Kinesis Data Analytics application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ContentLocationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<S3ContentLocationUpdate.Builder, S3ContentLocationUpdate> {
    private static final SdkField<String> BUCKET_ARN_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketARNUpdate").getter(getter(S3ContentLocationUpdate::bucketARNUpdate))
            .setter(setter(Builder::bucketARNUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketARNUpdate").build()).build();

    private static final SdkField<String> FILE_KEY_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileKeyUpdate").getter(getter(S3ContentLocationUpdate::fileKeyUpdate))
            .setter(setter(Builder::fileKeyUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileKeyUpdate").build()).build();

    private static final SdkField<String> OBJECT_VERSION_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectVersionUpdate").getter(getter(S3ContentLocationUpdate::objectVersionUpdate))
            .setter(setter(Builder::objectVersionUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectVersionUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_UPDATE_FIELD,
            FILE_KEY_UPDATE_FIELD, OBJECT_VERSION_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketARNUpdate;

    private final String fileKeyUpdate;

    private final String objectVersionUpdate;

    private S3ContentLocationUpdate(BuilderImpl builder) {
        this.bucketARNUpdate = builder.bucketARNUpdate;
        this.fileKeyUpdate = builder.fileKeyUpdate;
        this.objectVersionUpdate = builder.objectVersionUpdate;
    }

    /**
     * <p>
     * The new Amazon Resource Name (ARN) for the S3 bucket containing the application code.
     * </p>
     * 
     * @return The new Amazon Resource Name (ARN) for the S3 bucket containing the application code.
     */
    public final String bucketARNUpdate() {
        return bucketARNUpdate;
    }

    /**
     * <p>
     * The new file key for the object containing the application code.
     * </p>
     * 
     * @return The new file key for the object containing the application code.
     */
    public final String fileKeyUpdate() {
        return fileKeyUpdate;
    }

    /**
     * <p>
     * The new version of the object containing the application code.
     * </p>
     * 
     * @return The new version of the object containing the application code.
     */
    public final String objectVersionUpdate() {
        return objectVersionUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketARNUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(fileKeyUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(objectVersionUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ContentLocationUpdate)) {
            return false;
        }
        S3ContentLocationUpdate other = (S3ContentLocationUpdate) obj;
        return Objects.equals(bucketARNUpdate(), other.bucketARNUpdate())
                && Objects.equals(fileKeyUpdate(), other.fileKeyUpdate())
                && Objects.equals(objectVersionUpdate(), other.objectVersionUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ContentLocationUpdate").add("BucketARNUpdate", bucketARNUpdate())
                .add("FileKeyUpdate", fileKeyUpdate()).add("ObjectVersionUpdate", objectVersionUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketARNUpdate":
            return Optional.ofNullable(clazz.cast(bucketARNUpdate()));
        case "FileKeyUpdate":
            return Optional.ofNullable(clazz.cast(fileKeyUpdate()));
        case "ObjectVersionUpdate":
            return Optional.ofNullable(clazz.cast(objectVersionUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ContentLocationUpdate, T> g) {
        return obj -> g.apply((S3ContentLocationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ContentLocationUpdate> {
        /**
         * <p>
         * The new Amazon Resource Name (ARN) for the S3 bucket containing the application code.
         * </p>
         * 
         * @param bucketARNUpdate
         *        The new Amazon Resource Name (ARN) for the S3 bucket containing the application code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketARNUpdate(String bucketARNUpdate);

        /**
         * <p>
         * The new file key for the object containing the application code.
         * </p>
         * 
         * @param fileKeyUpdate
         *        The new file key for the object containing the application code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileKeyUpdate(String fileKeyUpdate);

        /**
         * <p>
         * The new version of the object containing the application code.
         * </p>
         * 
         * @param objectVersionUpdate
         *        The new version of the object containing the application code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectVersionUpdate(String objectVersionUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String bucketARNUpdate;

        private String fileKeyUpdate;

        private String objectVersionUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ContentLocationUpdate model) {
            bucketARNUpdate(model.bucketARNUpdate);
            fileKeyUpdate(model.fileKeyUpdate);
            objectVersionUpdate(model.objectVersionUpdate);
        }

        public final String getBucketARNUpdate() {
            return bucketARNUpdate;
        }

        @Override
        public final Builder bucketARNUpdate(String bucketARNUpdate) {
            this.bucketARNUpdate = bucketARNUpdate;
            return this;
        }

        public final void setBucketARNUpdate(String bucketARNUpdate) {
            this.bucketARNUpdate = bucketARNUpdate;
        }

        public final String getFileKeyUpdate() {
            return fileKeyUpdate;
        }

        @Override
        public final Builder fileKeyUpdate(String fileKeyUpdate) {
            this.fileKeyUpdate = fileKeyUpdate;
            return this;
        }

        public final void setFileKeyUpdate(String fileKeyUpdate) {
            this.fileKeyUpdate = fileKeyUpdate;
        }

        public final String getObjectVersionUpdate() {
            return objectVersionUpdate;
        }

        @Override
        public final Builder objectVersionUpdate(String objectVersionUpdate) {
            this.objectVersionUpdate = objectVersionUpdate;
            return this;
        }

        public final void setObjectVersionUpdate(String objectVersionUpdate) {
            this.objectVersionUpdate = objectVersionUpdate;
        }

        @Override
        public S3ContentLocationUpdate build() {
            return new S3ContentLocationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
