/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes parameters for how a Flink-based Kinesis Data Analytics application executes multiple tasks simultaneously.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParallelismConfigurationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ParallelismConfigurationDescription.Builder, ParallelismConfigurationDescription> {
    private static final SdkField<String> CONFIGURATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationType").getter(getter(ParallelismConfigurationDescription::configurationTypeAsString))
            .setter(setter(Builder::configurationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationType").build()).build();

    private static final SdkField<Integer> PARALLELISM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Parallelism").getter(getter(ParallelismConfigurationDescription::parallelism))
            .setter(setter(Builder::parallelism))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parallelism").build()).build();

    private static final SdkField<Integer> PARALLELISM_PER_KPU_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParallelismPerKPU").getter(getter(ParallelismConfigurationDescription::parallelismPerKPU))
            .setter(setter(Builder::parallelismPerKPU))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelismPerKPU").build()).build();

    private static final SdkField<Integer> CURRENT_PARALLELISM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CurrentParallelism").getter(getter(ParallelismConfigurationDescription::currentParallelism))
            .setter(setter(Builder::currentParallelism))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentParallelism").build())
            .build();

    private static final SdkField<Boolean> AUTO_SCALING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoScalingEnabled").getter(getter(ParallelismConfigurationDescription::autoScalingEnabled))
            .setter(setter(Builder::autoScalingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_TYPE_FIELD,
            PARALLELISM_FIELD, PARALLELISM_PER_KPU_FIELD, CURRENT_PARALLELISM_FIELD, AUTO_SCALING_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configurationType;

    private final Integer parallelism;

    private final Integer parallelismPerKPU;

    private final Integer currentParallelism;

    private final Boolean autoScalingEnabled;

    private ParallelismConfigurationDescription(BuilderImpl builder) {
        this.configurationType = builder.configurationType;
        this.parallelism = builder.parallelism;
        this.parallelismPerKPU = builder.parallelismPerKPU;
        this.currentParallelism = builder.currentParallelism;
        this.autoScalingEnabled = builder.autoScalingEnabled;
    }

    /**
     * <p>
     * Describes whether the application uses the default parallelism for the Kinesis Data Analytics service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configurationType}
     * will return {@link ConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configurationTypeAsString}.
     * </p>
     * 
     * @return Describes whether the application uses the default parallelism for the Kinesis Data Analytics service.
     * @see ConfigurationType
     */
    public final ConfigurationType configurationType() {
        return ConfigurationType.fromValue(configurationType);
    }

    /**
     * <p>
     * Describes whether the application uses the default parallelism for the Kinesis Data Analytics service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configurationType}
     * will return {@link ConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configurationTypeAsString}.
     * </p>
     * 
     * @return Describes whether the application uses the default parallelism for the Kinesis Data Analytics service.
     * @see ConfigurationType
     */
    public final String configurationTypeAsString() {
        return configurationType;
    }

    /**
     * <p>
     * Describes the initial number of parallel tasks that a Flink-based Kinesis Data Analytics application can perform.
     * If <code>AutoScalingEnabled</code> is set to True, then Kinesis Data Analytics can increase the
     * <code>CurrentParallelism</code> value in response to application load. The service can increase
     * <code>CurrentParallelism</code> up to the maximum parallelism, which is <code>ParalellismPerKPU</code> times the
     * maximum KPUs for the application. The maximum KPUs for an application is 32 by default, and can be increased by
     * requesting a limit increase. If application load is reduced, the service can reduce the
     * <code>CurrentParallelism</code> value down to the <code>Parallelism</code> setting.
     * </p>
     * 
     * @return Describes the initial number of parallel tasks that a Flink-based Kinesis Data Analytics application can
     *         perform. If <code>AutoScalingEnabled</code> is set to True, then Kinesis Data Analytics can increase the
     *         <code>CurrentParallelism</code> value in response to application load. The service can increase
     *         <code>CurrentParallelism</code> up to the maximum parallelism, which is <code>ParalellismPerKPU</code>
     *         times the maximum KPUs for the application. The maximum KPUs for an application is 32 by default, and can
     *         be increased by requesting a limit increase. If application load is reduced, the service can reduce the
     *         <code>CurrentParallelism</code> value down to the <code>Parallelism</code> setting.
     */
    public final Integer parallelism() {
        return parallelism;
    }

    /**
     * <p>
     * Describes the number of parallel tasks that a Flink-based Kinesis Data Analytics application can perform per
     * Kinesis Processing Unit (KPU) used by the application.
     * </p>
     * 
     * @return Describes the number of parallel tasks that a Flink-based Kinesis Data Analytics application can perform
     *         per Kinesis Processing Unit (KPU) used by the application.
     */
    public final Integer parallelismPerKPU() {
        return parallelismPerKPU;
    }

    /**
     * <p>
     * Describes the current number of parallel tasks that a Flink-based Kinesis Data Analytics application can perform.
     * If <code>AutoScalingEnabled</code> is set to True, Kinesis Data Analytics can increase this value in response to
     * application load. The service can increase this value up to the maximum parallelism, which is
     * <code>ParalellismPerKPU</code> times the maximum KPUs for the application. The maximum KPUs for an application is
     * 32 by default, and can be increased by requesting a limit increase. If application load is reduced, the service
     * can reduce the <code>CurrentParallelism</code> value down to the <code>Parallelism</code> setting.
     * </p>
     * 
     * @return Describes the current number of parallel tasks that a Flink-based Kinesis Data Analytics application can
     *         perform. If <code>AutoScalingEnabled</code> is set to True, Kinesis Data Analytics can increase this
     *         value in response to application load. The service can increase this value up to the maximum parallelism,
     *         which is <code>ParalellismPerKPU</code> times the maximum KPUs for the application. The maximum KPUs for
     *         an application is 32 by default, and can be increased by requesting a limit increase. If application load
     *         is reduced, the service can reduce the <code>CurrentParallelism</code> value down to the
     *         <code>Parallelism</code> setting.
     */
    public final Integer currentParallelism() {
        return currentParallelism;
    }

    /**
     * <p>
     * Describes whether the Kinesis Data Analytics service can increase the parallelism of the application in response
     * to increased throughput.
     * </p>
     * 
     * @return Describes whether the Kinesis Data Analytics service can increase the parallelism of the application in
     *         response to increased throughput.
     */
    public final Boolean autoScalingEnabled() {
        return autoScalingEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parallelism());
        hashCode = 31 * hashCode + Objects.hashCode(parallelismPerKPU());
        hashCode = 31 * hashCode + Objects.hashCode(currentParallelism());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParallelismConfigurationDescription)) {
            return false;
        }
        ParallelismConfigurationDescription other = (ParallelismConfigurationDescription) obj;
        return Objects.equals(configurationTypeAsString(), other.configurationTypeAsString())
                && Objects.equals(parallelism(), other.parallelism())
                && Objects.equals(parallelismPerKPU(), other.parallelismPerKPU())
                && Objects.equals(currentParallelism(), other.currentParallelism())
                && Objects.equals(autoScalingEnabled(), other.autoScalingEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParallelismConfigurationDescription").add("ConfigurationType", configurationTypeAsString())
                .add("Parallelism", parallelism()).add("ParallelismPerKPU", parallelismPerKPU())
                .add("CurrentParallelism", currentParallelism()).add("AutoScalingEnabled", autoScalingEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationType":
            return Optional.ofNullable(clazz.cast(configurationTypeAsString()));
        case "Parallelism":
            return Optional.ofNullable(clazz.cast(parallelism()));
        case "ParallelismPerKPU":
            return Optional.ofNullable(clazz.cast(parallelismPerKPU()));
        case "CurrentParallelism":
            return Optional.ofNullable(clazz.cast(currentParallelism()));
        case "AutoScalingEnabled":
            return Optional.ofNullable(clazz.cast(autoScalingEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParallelismConfigurationDescription, T> g) {
        return obj -> g.apply((ParallelismConfigurationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParallelismConfigurationDescription> {
        /**
         * <p>
         * Describes whether the application uses the default parallelism for the Kinesis Data Analytics service.
         * </p>
         * 
         * @param configurationType
         *        Describes whether the application uses the default parallelism for the Kinesis Data Analytics service.
         * @see ConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationType
         */
        Builder configurationType(String configurationType);

        /**
         * <p>
         * Describes whether the application uses the default parallelism for the Kinesis Data Analytics service.
         * </p>
         * 
         * @param configurationType
         *        Describes whether the application uses the default parallelism for the Kinesis Data Analytics service.
         * @see ConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationType
         */
        Builder configurationType(ConfigurationType configurationType);

        /**
         * <p>
         * Describes the initial number of parallel tasks that a Flink-based Kinesis Data Analytics application can
         * perform. If <code>AutoScalingEnabled</code> is set to True, then Kinesis Data Analytics can increase the
         * <code>CurrentParallelism</code> value in response to application load. The service can increase
         * <code>CurrentParallelism</code> up to the maximum parallelism, which is <code>ParalellismPerKPU</code> times
         * the maximum KPUs for the application. The maximum KPUs for an application is 32 by default, and can be
         * increased by requesting a limit increase. If application load is reduced, the service can reduce the
         * <code>CurrentParallelism</code> value down to the <code>Parallelism</code> setting.
         * </p>
         * 
         * @param parallelism
         *        Describes the initial number of parallel tasks that a Flink-based Kinesis Data Analytics application
         *        can perform. If <code>AutoScalingEnabled</code> is set to True, then Kinesis Data Analytics can
         *        increase the <code>CurrentParallelism</code> value in response to application load. The service can
         *        increase <code>CurrentParallelism</code> up to the maximum parallelism, which is
         *        <code>ParalellismPerKPU</code> times the maximum KPUs for the application. The maximum KPUs for an
         *        application is 32 by default, and can be increased by requesting a limit increase. If application load
         *        is reduced, the service can reduce the <code>CurrentParallelism</code> value down to the
         *        <code>Parallelism</code> setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelism(Integer parallelism);

        /**
         * <p>
         * Describes the number of parallel tasks that a Flink-based Kinesis Data Analytics application can perform per
         * Kinesis Processing Unit (KPU) used by the application.
         * </p>
         * 
         * @param parallelismPerKPU
         *        Describes the number of parallel tasks that a Flink-based Kinesis Data Analytics application can
         *        perform per Kinesis Processing Unit (KPU) used by the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelismPerKPU(Integer parallelismPerKPU);

        /**
         * <p>
         * Describes the current number of parallel tasks that a Flink-based Kinesis Data Analytics application can
         * perform. If <code>AutoScalingEnabled</code> is set to True, Kinesis Data Analytics can increase this value in
         * response to application load. The service can increase this value up to the maximum parallelism, which is
         * <code>ParalellismPerKPU</code> times the maximum KPUs for the application. The maximum KPUs for an
         * application is 32 by default, and can be increased by requesting a limit increase. If application load is
         * reduced, the service can reduce the <code>CurrentParallelism</code> value down to the
         * <code>Parallelism</code> setting.
         * </p>
         * 
         * @param currentParallelism
         *        Describes the current number of parallel tasks that a Flink-based Kinesis Data Analytics application
         *        can perform. If <code>AutoScalingEnabled</code> is set to True, Kinesis Data Analytics can increase
         *        this value in response to application load. The service can increase this value up to the maximum
         *        parallelism, which is <code>ParalellismPerKPU</code> times the maximum KPUs for the application. The
         *        maximum KPUs for an application is 32 by default, and can be increased by requesting a limit increase.
         *        If application load is reduced, the service can reduce the <code>CurrentParallelism</code> value down
         *        to the <code>Parallelism</code> setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentParallelism(Integer currentParallelism);

        /**
         * <p>
         * Describes whether the Kinesis Data Analytics service can increase the parallelism of the application in
         * response to increased throughput.
         * </p>
         * 
         * @param autoScalingEnabled
         *        Describes whether the Kinesis Data Analytics service can increase the parallelism of the application
         *        in response to increased throughput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingEnabled(Boolean autoScalingEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String configurationType;

        private Integer parallelism;

        private Integer parallelismPerKPU;

        private Integer currentParallelism;

        private Boolean autoScalingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ParallelismConfigurationDescription model) {
            configurationType(model.configurationType);
            parallelism(model.parallelism);
            parallelismPerKPU(model.parallelismPerKPU);
            currentParallelism(model.currentParallelism);
            autoScalingEnabled(model.autoScalingEnabled);
        }

        public final String getConfigurationType() {
            return configurationType;
        }

        @Override
        public final Builder configurationType(String configurationType) {
            this.configurationType = configurationType;
            return this;
        }

        @Override
        public final Builder configurationType(ConfigurationType configurationType) {
            this.configurationType(configurationType == null ? null : configurationType.toString());
            return this;
        }

        public final void setConfigurationType(String configurationType) {
            this.configurationType = configurationType;
        }

        public final Integer getParallelism() {
            return parallelism;
        }

        @Override
        public final Builder parallelism(Integer parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public final void setParallelism(Integer parallelism) {
            this.parallelism = parallelism;
        }

        public final Integer getParallelismPerKPU() {
            return parallelismPerKPU;
        }

        @Override
        public final Builder parallelismPerKPU(Integer parallelismPerKPU) {
            this.parallelismPerKPU = parallelismPerKPU;
            return this;
        }

        public final void setParallelismPerKPU(Integer parallelismPerKPU) {
            this.parallelismPerKPU = parallelismPerKPU;
        }

        public final Integer getCurrentParallelism() {
            return currentParallelism;
        }

        @Override
        public final Builder currentParallelism(Integer currentParallelism) {
            this.currentParallelism = currentParallelism;
            return this;
        }

        public final void setCurrentParallelism(Integer currentParallelism) {
            this.currentParallelism = currentParallelism;
        }

        public final Boolean getAutoScalingEnabled() {
            return autoScalingEnabled;
        }

        @Override
        public final Builder autoScalingEnabled(Boolean autoScalingEnabled) {
            this.autoScalingEnabled = autoScalingEnabled;
            return this;
        }

        public final void setAutoScalingEnabled(Boolean autoScalingEnabled) {
            this.autoScalingEnabled = autoScalingEnabled;
        }

        @Override
        public ParallelismConfigurationDescription build() {
            return new ParallelismConfigurationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
