/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates to configuration parameters for Amazon CloudWatch logging for a Flink-based Kinesis Data Analytics
 * application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringConfigurationUpdate.Builder, MonitoringConfigurationUpdate> {
    private static final SdkField<String> CONFIGURATION_TYPE_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationTypeUpdate").getter(getter(MonitoringConfigurationUpdate::configurationTypeUpdateAsString))
            .setter(setter(Builder::configurationTypeUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationTypeUpdate").build())
            .build();

    private static final SdkField<String> METRICS_LEVEL_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricsLevelUpdate").getter(getter(MonitoringConfigurationUpdate::metricsLevelUpdateAsString))
            .setter(setter(Builder::metricsLevelUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricsLevelUpdate").build())
            .build();

    private static final SdkField<String> LOG_LEVEL_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogLevelUpdate").getter(getter(MonitoringConfigurationUpdate::logLevelUpdateAsString))
            .setter(setter(Builder::logLevelUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLevelUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_TYPE_UPDATE_FIELD, METRICS_LEVEL_UPDATE_FIELD, LOG_LEVEL_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configurationTypeUpdate;

    private final String metricsLevelUpdate;

    private final String logLevelUpdate;

    private MonitoringConfigurationUpdate(BuilderImpl builder) {
        this.configurationTypeUpdate = builder.configurationTypeUpdate;
        this.metricsLevelUpdate = builder.metricsLevelUpdate;
        this.logLevelUpdate = builder.logLevelUpdate;
    }

    /**
     * <p>
     * Describes updates to whether to use the default CloudWatch logging configuration for an application. You must set
     * this property to <code>CUSTOM</code> in order to set the <code>LogLevel</code> or <code>MetricsLevel</code>
     * parameters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationTypeUpdate} will return {@link ConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #configurationTypeUpdateAsString}.
     * </p>
     * 
     * @return Describes updates to whether to use the default CloudWatch logging configuration for an application. You
     *         must set this property to <code>CUSTOM</code> in order to set the <code>LogLevel</code> or
     *         <code>MetricsLevel</code> parameters.
     * @see ConfigurationType
     */
    public final ConfigurationType configurationTypeUpdate() {
        return ConfigurationType.fromValue(configurationTypeUpdate);
    }

    /**
     * <p>
     * Describes updates to whether to use the default CloudWatch logging configuration for an application. You must set
     * this property to <code>CUSTOM</code> in order to set the <code>LogLevel</code> or <code>MetricsLevel</code>
     * parameters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationTypeUpdate} will return {@link ConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #configurationTypeUpdateAsString}.
     * </p>
     * 
     * @return Describes updates to whether to use the default CloudWatch logging configuration for an application. You
     *         must set this property to <code>CUSTOM</code> in order to set the <code>LogLevel</code> or
     *         <code>MetricsLevel</code> parameters.
     * @see ConfigurationType
     */
    public final String configurationTypeUpdateAsString() {
        return configurationTypeUpdate;
    }

    /**
     * <p>
     * Describes updates to the granularity of the CloudWatch Logs for an application. The <code>Parallelism</code>
     * level is not recommended for applications with a Parallelism over 64 due to excessive costs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #metricsLevelUpdate} will return {@link MetricsLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #metricsLevelUpdateAsString}.
     * </p>
     * 
     * @return Describes updates to the granularity of the CloudWatch Logs for an application. The
     *         <code>Parallelism</code> level is not recommended for applications with a Parallelism over 64 due to
     *         excessive costs.
     * @see MetricsLevel
     */
    public final MetricsLevel metricsLevelUpdate() {
        return MetricsLevel.fromValue(metricsLevelUpdate);
    }

    /**
     * <p>
     * Describes updates to the granularity of the CloudWatch Logs for an application. The <code>Parallelism</code>
     * level is not recommended for applications with a Parallelism over 64 due to excessive costs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #metricsLevelUpdate} will return {@link MetricsLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #metricsLevelUpdateAsString}.
     * </p>
     * 
     * @return Describes updates to the granularity of the CloudWatch Logs for an application. The
     *         <code>Parallelism</code> level is not recommended for applications with a Parallelism over 64 due to
     *         excessive costs.
     * @see MetricsLevel
     */
    public final String metricsLevelUpdateAsString() {
        return metricsLevelUpdate;
    }

    /**
     * <p>
     * Describes updates to the verbosity of the CloudWatch Logs for an application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevelUpdate}
     * will return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelUpdateAsString}.
     * </p>
     * 
     * @return Describes updates to the verbosity of the CloudWatch Logs for an application.
     * @see LogLevel
     */
    public final LogLevel logLevelUpdate() {
        return LogLevel.fromValue(logLevelUpdate);
    }

    /**
     * <p>
     * Describes updates to the verbosity of the CloudWatch Logs for an application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevelUpdate}
     * will return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelUpdateAsString}.
     * </p>
     * 
     * @return Describes updates to the verbosity of the CloudWatch Logs for an application.
     * @see LogLevel
     */
    public final String logLevelUpdateAsString() {
        return logLevelUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationTypeUpdateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricsLevelUpdateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logLevelUpdateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringConfigurationUpdate)) {
            return false;
        }
        MonitoringConfigurationUpdate other = (MonitoringConfigurationUpdate) obj;
        return Objects.equals(configurationTypeUpdateAsString(), other.configurationTypeUpdateAsString())
                && Objects.equals(metricsLevelUpdateAsString(), other.metricsLevelUpdateAsString())
                && Objects.equals(logLevelUpdateAsString(), other.logLevelUpdateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringConfigurationUpdate")
                .add("ConfigurationTypeUpdate", configurationTypeUpdateAsString())
                .add("MetricsLevelUpdate", metricsLevelUpdateAsString()).add("LogLevelUpdate", logLevelUpdateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationTypeUpdate":
            return Optional.ofNullable(clazz.cast(configurationTypeUpdateAsString()));
        case "MetricsLevelUpdate":
            return Optional.ofNullable(clazz.cast(metricsLevelUpdateAsString()));
        case "LogLevelUpdate":
            return Optional.ofNullable(clazz.cast(logLevelUpdateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringConfigurationUpdate, T> g) {
        return obj -> g.apply((MonitoringConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringConfigurationUpdate> {
        /**
         * <p>
         * Describes updates to whether to use the default CloudWatch logging configuration for an application. You must
         * set this property to <code>CUSTOM</code> in order to set the <code>LogLevel</code> or
         * <code>MetricsLevel</code> parameters.
         * </p>
         * 
         * @param configurationTypeUpdate
         *        Describes updates to whether to use the default CloudWatch logging configuration for an application.
         *        You must set this property to <code>CUSTOM</code> in order to set the <code>LogLevel</code> or
         *        <code>MetricsLevel</code> parameters.
         * @see ConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationType
         */
        Builder configurationTypeUpdate(String configurationTypeUpdate);

        /**
         * <p>
         * Describes updates to whether to use the default CloudWatch logging configuration for an application. You must
         * set this property to <code>CUSTOM</code> in order to set the <code>LogLevel</code> or
         * <code>MetricsLevel</code> parameters.
         * </p>
         * 
         * @param configurationTypeUpdate
         *        Describes updates to whether to use the default CloudWatch logging configuration for an application.
         *        You must set this property to <code>CUSTOM</code> in order to set the <code>LogLevel</code> or
         *        <code>MetricsLevel</code> parameters.
         * @see ConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationType
         */
        Builder configurationTypeUpdate(ConfigurationType configurationTypeUpdate);

        /**
         * <p>
         * Describes updates to the granularity of the CloudWatch Logs for an application. The <code>Parallelism</code>
         * level is not recommended for applications with a Parallelism over 64 due to excessive costs.
         * </p>
         * 
         * @param metricsLevelUpdate
         *        Describes updates to the granularity of the CloudWatch Logs for an application. The
         *        <code>Parallelism</code> level is not recommended for applications with a Parallelism over 64 due to
         *        excessive costs.
         * @see MetricsLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsLevel
         */
        Builder metricsLevelUpdate(String metricsLevelUpdate);

        /**
         * <p>
         * Describes updates to the granularity of the CloudWatch Logs for an application. The <code>Parallelism</code>
         * level is not recommended for applications with a Parallelism over 64 due to excessive costs.
         * </p>
         * 
         * @param metricsLevelUpdate
         *        Describes updates to the granularity of the CloudWatch Logs for an application. The
         *        <code>Parallelism</code> level is not recommended for applications with a Parallelism over 64 due to
         *        excessive costs.
         * @see MetricsLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsLevel
         */
        Builder metricsLevelUpdate(MetricsLevel metricsLevelUpdate);

        /**
         * <p>
         * Describes updates to the verbosity of the CloudWatch Logs for an application.
         * </p>
         * 
         * @param logLevelUpdate
         *        Describes updates to the verbosity of the CloudWatch Logs for an application.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevelUpdate(String logLevelUpdate);

        /**
         * <p>
         * Describes updates to the verbosity of the CloudWatch Logs for an application.
         * </p>
         * 
         * @param logLevelUpdate
         *        Describes updates to the verbosity of the CloudWatch Logs for an application.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevelUpdate(LogLevel logLevelUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String configurationTypeUpdate;

        private String metricsLevelUpdate;

        private String logLevelUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringConfigurationUpdate model) {
            configurationTypeUpdate(model.configurationTypeUpdate);
            metricsLevelUpdate(model.metricsLevelUpdate);
            logLevelUpdate(model.logLevelUpdate);
        }

        public final String getConfigurationTypeUpdate() {
            return configurationTypeUpdate;
        }

        @Override
        public final Builder configurationTypeUpdate(String configurationTypeUpdate) {
            this.configurationTypeUpdate = configurationTypeUpdate;
            return this;
        }

        @Override
        public final Builder configurationTypeUpdate(ConfigurationType configurationTypeUpdate) {
            this.configurationTypeUpdate(configurationTypeUpdate == null ? null : configurationTypeUpdate.toString());
            return this;
        }

        public final void setConfigurationTypeUpdate(String configurationTypeUpdate) {
            this.configurationTypeUpdate = configurationTypeUpdate;
        }

        public final String getMetricsLevelUpdate() {
            return metricsLevelUpdate;
        }

        @Override
        public final Builder metricsLevelUpdate(String metricsLevelUpdate) {
            this.metricsLevelUpdate = metricsLevelUpdate;
            return this;
        }

        @Override
        public final Builder metricsLevelUpdate(MetricsLevel metricsLevelUpdate) {
            this.metricsLevelUpdate(metricsLevelUpdate == null ? null : metricsLevelUpdate.toString());
            return this;
        }

        public final void setMetricsLevelUpdate(String metricsLevelUpdate) {
            this.metricsLevelUpdate = metricsLevelUpdate;
        }

        public final String getLogLevelUpdate() {
            return logLevelUpdate;
        }

        @Override
        public final Builder logLevelUpdate(String logLevelUpdate) {
            this.logLevelUpdate = logLevelUpdate;
            return this;
        }

        @Override
        public final Builder logLevelUpdate(LogLevel logLevelUpdate) {
            this.logLevelUpdate(logLevelUpdate == null ? null : logLevelUpdate.toString());
            return this;
        }

        public final void setLogLevelUpdate(String logLevelUpdate) {
            this.logLevelUpdate = logLevelUpdate;
        }

        @Override
        public MonitoringConfigurationUpdate build() {
            return new MonitoringConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
