/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the starting parameters for a Flink-based Kinesis Data Analytics application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlinkRunConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FlinkRunConfiguration.Builder, FlinkRunConfiguration> {
    private static final SdkField<Boolean> ALLOW_NON_RESTORED_STATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowNonRestoredState").getter(getter(FlinkRunConfiguration::allowNonRestoredState))
            .setter(setter(Builder::allowNonRestoredState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowNonRestoredState").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ALLOW_NON_RESTORED_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean allowNonRestoredState;

    private FlinkRunConfiguration(BuilderImpl builder) {
        this.allowNonRestoredState = builder.allowNonRestoredState;
    }

    /**
     * <p>
     * When restoring from a snapshot, specifies whether the runtime is allowed to skip a state that cannot be mapped to
     * the new program. This will happen if the program is updated between snapshots to remove stateful parameters, and
     * state data in the snapshot no longer corresponds to valid application data. For more information, see <a href=
     * "https://ci.apache.org/projects/flink/flink-docs-release-1.8/ops/state/savepoints.html#allowing-non-restored-state"
     * > Allowing Non-Restored State</a> in the <a
     * href="https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink documentation</a>.
     * </p>
     * <note>
     * <p>
     * This value defaults to <code>false</code>. If you update your application without specifying this parameter,
     * <code>AllowNonRestoredState</code> will be set to <code>false</code>, even if it was previously set to
     * <code>true</code>.
     * </p>
     * </note>
     * 
     * @return When restoring from a snapshot, specifies whether the runtime is allowed to skip a state that cannot be
     *         mapped to the new program. This will happen if the program is updated between snapshots to remove
     *         stateful parameters, and state data in the snapshot no longer corresponds to valid application data. For
     *         more information, see <a href=
     *         "https://ci.apache.org/projects/flink/flink-docs-release-1.8/ops/state/savepoints.html#allowing-non-restored-state"
     *         > Allowing Non-Restored State</a> in the <a
     *         href="https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink documentation</a>.</p>
     *         <note>
     *         <p>
     *         This value defaults to <code>false</code>. If you update your application without specifying this
     *         parameter, <code>AllowNonRestoredState</code> will be set to <code>false</code>, even if it was
     *         previously set to <code>true</code>.
     *         </p>
     */
    public final Boolean allowNonRestoredState() {
        return allowNonRestoredState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowNonRestoredState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlinkRunConfiguration)) {
            return false;
        }
        FlinkRunConfiguration other = (FlinkRunConfiguration) obj;
        return Objects.equals(allowNonRestoredState(), other.allowNonRestoredState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlinkRunConfiguration").add("AllowNonRestoredState", allowNonRestoredState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowNonRestoredState":
            return Optional.ofNullable(clazz.cast(allowNonRestoredState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlinkRunConfiguration, T> g) {
        return obj -> g.apply((FlinkRunConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlinkRunConfiguration> {
        /**
         * <p>
         * When restoring from a snapshot, specifies whether the runtime is allowed to skip a state that cannot be
         * mapped to the new program. This will happen if the program is updated between snapshots to remove stateful
         * parameters, and state data in the snapshot no longer corresponds to valid application data. For more
         * information, see <a href=
         * "https://ci.apache.org/projects/flink/flink-docs-release-1.8/ops/state/savepoints.html#allowing-non-restored-state"
         * > Allowing Non-Restored State</a> in the <a
         * href="https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink documentation</a>.
         * </p>
         * <note>
         * <p>
         * This value defaults to <code>false</code>. If you update your application without specifying this parameter,
         * <code>AllowNonRestoredState</code> will be set to <code>false</code>, even if it was previously set to
         * <code>true</code>.
         * </p>
         * </note>
         * 
         * @param allowNonRestoredState
         *        When restoring from a snapshot, specifies whether the runtime is allowed to skip a state that cannot
         *        be mapped to the new program. This will happen if the program is updated between snapshots to remove
         *        stateful parameters, and state data in the snapshot no longer corresponds to valid application data.
         *        For more information, see <a href=
         *        "https://ci.apache.org/projects/flink/flink-docs-release-1.8/ops/state/savepoints.html#allowing-non-restored-state"
         *        > Allowing Non-Restored State</a> in the <a
         *        href="https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink
         *        documentation</a>.</p> <note>
         *        <p>
         *        This value defaults to <code>false</code>. If you update your application without specifying this
         *        parameter, <code>AllowNonRestoredState</code> will be set to <code>false</code>, even if it was
         *        previously set to <code>true</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowNonRestoredState(Boolean allowNonRestoredState);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowNonRestoredState;

        private BuilderImpl() {
        }

        private BuilderImpl(FlinkRunConfiguration model) {
            allowNonRestoredState(model.allowNonRestoredState);
        }

        public final Boolean getAllowNonRestoredState() {
            return allowNonRestoredState;
        }

        @Override
        public final Builder allowNonRestoredState(Boolean allowNonRestoredState) {
            this.allowNonRestoredState = allowNonRestoredState;
            return this;
        }

        public final void setAllowNonRestoredState(Boolean allowNonRestoredState) {
            this.allowNonRestoredState = allowNonRestoredState;
        }

        @Override
        public FlinkRunConfiguration build() {
            return new FlinkRunConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
