/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes configuration parameters for a Flink-based Kinesis Data Analytics application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlinkApplicationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FlinkApplicationConfiguration.Builder, FlinkApplicationConfiguration> {
    private static final SdkField<CheckpointConfiguration> CHECKPOINT_CONFIGURATION_FIELD = SdkField
            .<CheckpointConfiguration> builder(MarshallingType.SDK_POJO).memberName("CheckpointConfiguration")
            .getter(getter(FlinkApplicationConfiguration::checkpointConfiguration))
            .setter(setter(Builder::checkpointConfiguration)).constructor(CheckpointConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointConfiguration").build())
            .build();

    private static final SdkField<MonitoringConfiguration> MONITORING_CONFIGURATION_FIELD = SdkField
            .<MonitoringConfiguration> builder(MarshallingType.SDK_POJO).memberName("MonitoringConfiguration")
            .getter(getter(FlinkApplicationConfiguration::monitoringConfiguration))
            .setter(setter(Builder::monitoringConfiguration)).constructor(MonitoringConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringConfiguration").build())
            .build();

    private static final SdkField<ParallelismConfiguration> PARALLELISM_CONFIGURATION_FIELD = SdkField
            .<ParallelismConfiguration> builder(MarshallingType.SDK_POJO).memberName("ParallelismConfiguration")
            .getter(getter(FlinkApplicationConfiguration::parallelismConfiguration))
            .setter(setter(Builder::parallelismConfiguration)).constructor(ParallelismConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelismConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CHECKPOINT_CONFIGURATION_FIELD, MONITORING_CONFIGURATION_FIELD, PARALLELISM_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final CheckpointConfiguration checkpointConfiguration;

    private final MonitoringConfiguration monitoringConfiguration;

    private final ParallelismConfiguration parallelismConfiguration;

    private FlinkApplicationConfiguration(BuilderImpl builder) {
        this.checkpointConfiguration = builder.checkpointConfiguration;
        this.monitoringConfiguration = builder.monitoringConfiguration;
        this.parallelismConfiguration = builder.parallelismConfiguration;
    }

    /**
     * <p>
     * Describes an application's checkpointing configuration. Checkpointing is the process of persisting application
     * state for fault tolerance. For more information, see <a href=
     * "https://ci.apache.org/projects/flink/flink-docs-release-1.8/concepts/programming-model.html#checkpoints-for-fault-tolerance"
     * > Checkpoints for Fault Tolerance</a> in the <a
     * href="https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink Documentation</a>.
     * </p>
     * 
     * @return Describes an application's checkpointing configuration. Checkpointing is the process of persisting
     *         application state for fault tolerance. For more information, see <a href=
     *         "https://ci.apache.org/projects/flink/flink-docs-release-1.8/concepts/programming-model.html#checkpoints-for-fault-tolerance"
     *         > Checkpoints for Fault Tolerance</a> in the <a
     *         href="https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink Documentation</a>.
     */
    public final CheckpointConfiguration checkpointConfiguration() {
        return checkpointConfiguration;
    }

    /**
     * <p>
     * Describes configuration parameters for Amazon CloudWatch logging for an application.
     * </p>
     * 
     * @return Describes configuration parameters for Amazon CloudWatch logging for an application.
     */
    public final MonitoringConfiguration monitoringConfiguration() {
        return monitoringConfiguration;
    }

    /**
     * <p>
     * Describes parameters for how an application executes multiple tasks simultaneously.
     * </p>
     * 
     * @return Describes parameters for how an application executes multiple tasks simultaneously.
     */
    public final ParallelismConfiguration parallelismConfiguration() {
        return parallelismConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(checkpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(parallelismConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlinkApplicationConfiguration)) {
            return false;
        }
        FlinkApplicationConfiguration other = (FlinkApplicationConfiguration) obj;
        return Objects.equals(checkpointConfiguration(), other.checkpointConfiguration())
                && Objects.equals(monitoringConfiguration(), other.monitoringConfiguration())
                && Objects.equals(parallelismConfiguration(), other.parallelismConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlinkApplicationConfiguration").add("CheckpointConfiguration", checkpointConfiguration())
                .add("MonitoringConfiguration", monitoringConfiguration())
                .add("ParallelismConfiguration", parallelismConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CheckpointConfiguration":
            return Optional.ofNullable(clazz.cast(checkpointConfiguration()));
        case "MonitoringConfiguration":
            return Optional.ofNullable(clazz.cast(monitoringConfiguration()));
        case "ParallelismConfiguration":
            return Optional.ofNullable(clazz.cast(parallelismConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlinkApplicationConfiguration, T> g) {
        return obj -> g.apply((FlinkApplicationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlinkApplicationConfiguration> {
        /**
         * <p>
         * Describes an application's checkpointing configuration. Checkpointing is the process of persisting
         * application state for fault tolerance. For more information, see <a href=
         * "https://ci.apache.org/projects/flink/flink-docs-release-1.8/concepts/programming-model.html#checkpoints-for-fault-tolerance"
         * > Checkpoints for Fault Tolerance</a> in the <a
         * href="https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink Documentation</a>.
         * </p>
         * 
         * @param checkpointConfiguration
         *        Describes an application's checkpointing configuration. Checkpointing is the process of persisting
         *        application state for fault tolerance. For more information, see <a href=
         *        "https://ci.apache.org/projects/flink/flink-docs-release-1.8/concepts/programming-model.html#checkpoints-for-fault-tolerance"
         *        > Checkpoints for Fault Tolerance</a> in the <a
         *        href="https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink Documentation</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkpointConfiguration(CheckpointConfiguration checkpointConfiguration);

        /**
         * <p>
         * Describes an application's checkpointing configuration. Checkpointing is the process of persisting
         * application state for fault tolerance. For more information, see <a href=
         * "https://ci.apache.org/projects/flink/flink-docs-release-1.8/concepts/programming-model.html#checkpoints-for-fault-tolerance"
         * > Checkpoints for Fault Tolerance</a> in the <a
         * href="https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink Documentation</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link CheckpointConfiguration.Builder} avoiding the
         * need to create one manually via {@link CheckpointConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CheckpointConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #checkpointConfiguration(CheckpointConfiguration)}.
         * 
         * @param checkpointConfiguration
         *        a consumer that will call methods on {@link CheckpointConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #checkpointConfiguration(CheckpointConfiguration)
         */
        default Builder checkpointConfiguration(Consumer<CheckpointConfiguration.Builder> checkpointConfiguration) {
            return checkpointConfiguration(CheckpointConfiguration.builder().applyMutation(checkpointConfiguration).build());
        }

        /**
         * <p>
         * Describes configuration parameters for Amazon CloudWatch logging for an application.
         * </p>
         * 
         * @param monitoringConfiguration
         *        Describes configuration parameters for Amazon CloudWatch logging for an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringConfiguration(MonitoringConfiguration monitoringConfiguration);

        /**
         * <p>
         * Describes configuration parameters for Amazon CloudWatch logging for an application.
         * </p>
         * This is a convenience that creates an instance of the {@link MonitoringConfiguration.Builder} avoiding the
         * need to create one manually via {@link MonitoringConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #monitoringConfiguration(MonitoringConfiguration)}.
         * 
         * @param monitoringConfiguration
         *        a consumer that will call methods on {@link MonitoringConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringConfiguration(MonitoringConfiguration)
         */
        default Builder monitoringConfiguration(Consumer<MonitoringConfiguration.Builder> monitoringConfiguration) {
            return monitoringConfiguration(MonitoringConfiguration.builder().applyMutation(monitoringConfiguration).build());
        }

        /**
         * <p>
         * Describes parameters for how an application executes multiple tasks simultaneously.
         * </p>
         * 
         * @param parallelismConfiguration
         *        Describes parameters for how an application executes multiple tasks simultaneously.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelismConfiguration(ParallelismConfiguration parallelismConfiguration);

        /**
         * <p>
         * Describes parameters for how an application executes multiple tasks simultaneously.
         * </p>
         * This is a convenience that creates an instance of the {@link ParallelismConfiguration.Builder} avoiding the
         * need to create one manually via {@link ParallelismConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ParallelismConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #parallelismConfiguration(ParallelismConfiguration)}.
         * 
         * @param parallelismConfiguration
         *        a consumer that will call methods on {@link ParallelismConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parallelismConfiguration(ParallelismConfiguration)
         */
        default Builder parallelismConfiguration(Consumer<ParallelismConfiguration.Builder> parallelismConfiguration) {
            return parallelismConfiguration(ParallelismConfiguration.builder().applyMutation(parallelismConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CheckpointConfiguration checkpointConfiguration;

        private MonitoringConfiguration monitoringConfiguration;

        private ParallelismConfiguration parallelismConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(FlinkApplicationConfiguration model) {
            checkpointConfiguration(model.checkpointConfiguration);
            monitoringConfiguration(model.monitoringConfiguration);
            parallelismConfiguration(model.parallelismConfiguration);
        }

        public final CheckpointConfiguration.Builder getCheckpointConfiguration() {
            return checkpointConfiguration != null ? checkpointConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder checkpointConfiguration(CheckpointConfiguration checkpointConfiguration) {
            this.checkpointConfiguration = checkpointConfiguration;
            return this;
        }

        public final void setCheckpointConfiguration(CheckpointConfiguration.BuilderImpl checkpointConfiguration) {
            this.checkpointConfiguration = checkpointConfiguration != null ? checkpointConfiguration.build() : null;
        }

        public final MonitoringConfiguration.Builder getMonitoringConfiguration() {
            return monitoringConfiguration != null ? monitoringConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder monitoringConfiguration(MonitoringConfiguration monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration;
            return this;
        }

        public final void setMonitoringConfiguration(MonitoringConfiguration.BuilderImpl monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration != null ? monitoringConfiguration.build() : null;
        }

        public final ParallelismConfiguration.Builder getParallelismConfiguration() {
            return parallelismConfiguration != null ? parallelismConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder parallelismConfiguration(ParallelismConfiguration parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration;
            return this;
        }

        public final void setParallelismConfiguration(ParallelismConfiguration.BuilderImpl parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration != null ? parallelismConfiguration.build() : null;
        }

        @Override
        public FlinkApplicationConfiguration build() {
            return new FlinkApplicationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
