/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes execution properties for a Flink-based Kinesis Data Analytics application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentProperties.Builder, EnvironmentProperties> {
    private static final SdkField<List<PropertyGroup>> PROPERTY_GROUPS_FIELD = SdkField
            .<List<PropertyGroup>> builder(MarshallingType.LIST)
            .memberName("PropertyGroups")
            .getter(getter(EnvironmentProperties::propertyGroups))
            .setter(setter(Builder::propertyGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PropertyGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_GROUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<PropertyGroup> propertyGroups;

    private EnvironmentProperties(BuilderImpl builder) {
        this.propertyGroups = builder.propertyGroups;
    }

    /**
     * Returns true if the PropertyGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPropertyGroups() {
        return propertyGroups != null && !(propertyGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the execution property groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPropertyGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Describes the execution property groups.
     */
    public final List<PropertyGroup> propertyGroups() {
        return propertyGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyGroups() ? propertyGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentProperties)) {
            return false;
        }
        EnvironmentProperties other = (EnvironmentProperties) obj;
        return hasPropertyGroups() == other.hasPropertyGroups() && Objects.equals(propertyGroups(), other.propertyGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentProperties").add("PropertyGroups", hasPropertyGroups() ? propertyGroups() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PropertyGroups":
            return Optional.ofNullable(clazz.cast(propertyGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentProperties, T> g) {
        return obj -> g.apply((EnvironmentProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentProperties> {
        /**
         * <p>
         * Describes the execution property groups.
         * </p>
         * 
         * @param propertyGroups
         *        Describes the execution property groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyGroups(Collection<PropertyGroup> propertyGroups);

        /**
         * <p>
         * Describes the execution property groups.
         * </p>
         * 
         * @param propertyGroups
         *        Describes the execution property groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyGroups(PropertyGroup... propertyGroups);

        /**
         * <p>
         * Describes the execution property groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PropertyGroup>.Builder} avoiding the need
         * to create one manually via {@link List<PropertyGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PropertyGroup>.Builder#build()} is called immediately and
         * its result is passed to {@link #propertyGroups(List<PropertyGroup>)}.
         * 
         * @param propertyGroups
         *        a consumer that will call methods on {@link List<PropertyGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propertyGroups(List<PropertyGroup>)
         */
        Builder propertyGroups(Consumer<PropertyGroup.Builder>... propertyGroups);
    }

    static final class BuilderImpl implements Builder {
        private List<PropertyGroup> propertyGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentProperties model) {
            propertyGroups(model.propertyGroups);
        }

        public final Collection<PropertyGroup.Builder> getPropertyGroups() {
            if (propertyGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return propertyGroups != null ? propertyGroups.stream().map(PropertyGroup::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder propertyGroups(Collection<PropertyGroup> propertyGroups) {
            this.propertyGroups = PropertyGroupsCopier.copy(propertyGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyGroups(PropertyGroup... propertyGroups) {
            propertyGroups(Arrays.asList(propertyGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyGroups(Consumer<PropertyGroup.Builder>... propertyGroups) {
            propertyGroups(Stream.of(propertyGroups).map(c -> PropertyGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPropertyGroups(Collection<PropertyGroup.BuilderImpl> propertyGroups) {
            this.propertyGroups = PropertyGroupsCopier.copyFromBuilder(propertyGroups);
        }

        @Override
        public EnvironmentProperties build() {
            return new EnvironmentProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
