/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a description of Amazon CloudWatch logging options, including the log stream Amazon Resource Name (ARN).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchLoggingOption implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchLoggingOption.Builder, CloudWatchLoggingOption> {
    private static final SdkField<String> LOG_STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogStreamARN").getter(getter(CloudWatchLoggingOption::logStreamARN))
            .setter(setter(Builder::logStreamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStreamARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_STREAM_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logStreamARN;

    private CloudWatchLoggingOption(BuilderImpl builder) {
        this.logStreamARN = builder.logStreamARN;
    }

    /**
     * <p>
     * The ARN of the CloudWatch log to receive application messages.
     * </p>
     * 
     * @return The ARN of the CloudWatch log to receive application messages.
     */
    public final String logStreamARN() {
        return logStreamARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logStreamARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLoggingOption)) {
            return false;
        }
        CloudWatchLoggingOption other = (CloudWatchLoggingOption) obj;
        return Objects.equals(logStreamARN(), other.logStreamARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchLoggingOption").add("LogStreamARN", logStreamARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogStreamARN":
            return Optional.ofNullable(clazz.cast(logStreamARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLoggingOption, T> g) {
        return obj -> g.apply((CloudWatchLoggingOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchLoggingOption> {
        /**
         * <p>
         * The ARN of the CloudWatch log to receive application messages.
         * </p>
         * 
         * @param logStreamARN
         *        The ARN of the CloudWatch log to receive application messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamARN(String logStreamARN);
    }

    static final class BuilderImpl implements Builder {
        private String logStreamARN;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLoggingOption model) {
            logStreamARN(model.logStreamARN);
        }

        public final String getLogStreamARN() {
            return logStreamARN;
        }

        @Override
        public final Builder logStreamARN(String logStreamARN) {
            this.logStreamARN = logStreamARN;
            return this;
        }

        public final void setLogStreamARN(String logStreamARN) {
            this.logStreamARN = logStreamARN;
        }

        @Override
        public CloudWatchLoggingOption build() {
            return new CloudWatchLoggingOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
