/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an application's checkpointing configuration. Checkpointing is the process of persisting application state
 * for fault tolerance. For more information, see <a href=
 * "https://ci.apache.org/projects/flink/flink-docs-release-1.8/concepts/programming-model.html#checkpoints-for-fault-tolerance"
 * > Checkpoints for Fault Tolerance</a> in the <a
 * href="https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink Documentation</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckpointConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CheckpointConfiguration.Builder, CheckpointConfiguration> {
    private static final SdkField<String> CONFIGURATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationType").getter(getter(CheckpointConfiguration::configurationTypeAsString))
            .setter(setter(Builder::configurationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationType").build()).build();

    private static final SdkField<Boolean> CHECKPOINTING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CheckpointingEnabled").getter(getter(CheckpointConfiguration::checkpointingEnabled))
            .setter(setter(Builder::checkpointingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointingEnabled").build())
            .build();

    private static final SdkField<Long> CHECKPOINT_INTERVAL_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CheckpointInterval").getter(getter(CheckpointConfiguration::checkpointInterval))
            .setter(setter(Builder::checkpointInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointInterval").build())
            .build();

    private static final SdkField<Long> MIN_PAUSE_BETWEEN_CHECKPOINTS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("MinPauseBetweenCheckpoints")
            .getter(getter(CheckpointConfiguration::minPauseBetweenCheckpoints))
            .setter(setter(Builder::minPauseBetweenCheckpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinPauseBetweenCheckpoints").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_TYPE_FIELD,
            CHECKPOINTING_ENABLED_FIELD, CHECKPOINT_INTERVAL_FIELD, MIN_PAUSE_BETWEEN_CHECKPOINTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configurationType;

    private final Boolean checkpointingEnabled;

    private final Long checkpointInterval;

    private final Long minPauseBetweenCheckpoints;

    private CheckpointConfiguration(BuilderImpl builder) {
        this.configurationType = builder.configurationType;
        this.checkpointingEnabled = builder.checkpointingEnabled;
        this.checkpointInterval = builder.checkpointInterval;
        this.minPauseBetweenCheckpoints = builder.minPauseBetweenCheckpoints;
    }

    /**
     * <p>
     * Describes whether the application uses Kinesis Data Analytics' default checkpointing behavior. You must set this
     * property to <code>CUSTOM</code> in order to set the <code>CheckpointingEnabled</code>,
     * <code>CheckpointInterval</code>, or <code>MinPauseBetweenCheckpoints</code> parameters.
     * </p>
     * <note>
     * <p>
     * If this value is set to <code>DEFAULT</code>, the application will use the following values, even if they are set
     * to other values using APIs or application code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>CheckpointingEnabled:</b> true
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CheckpointInterval:</b> 60000
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MinPauseBetweenCheckpoints:</b> 5000
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configurationType}
     * will return {@link ConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configurationTypeAsString}.
     * </p>
     * 
     * @return Describes whether the application uses Kinesis Data Analytics' default checkpointing behavior. You must
     *         set this property to <code>CUSTOM</code> in order to set the <code>CheckpointingEnabled</code>,
     *         <code>CheckpointInterval</code>, or <code>MinPauseBetweenCheckpoints</code> parameters.</p> <note>
     *         <p>
     *         If this value is set to <code>DEFAULT</code>, the application will use the following values, even if they
     *         are set to other values using APIs or application code:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>CheckpointingEnabled:</b> true
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CheckpointInterval:</b> 60000
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MinPauseBetweenCheckpoints:</b> 5000
     *         </p>
     *         </li>
     *         </ul>
     * @see ConfigurationType
     */
    public final ConfigurationType configurationType() {
        return ConfigurationType.fromValue(configurationType);
    }

    /**
     * <p>
     * Describes whether the application uses Kinesis Data Analytics' default checkpointing behavior. You must set this
     * property to <code>CUSTOM</code> in order to set the <code>CheckpointingEnabled</code>,
     * <code>CheckpointInterval</code>, or <code>MinPauseBetweenCheckpoints</code> parameters.
     * </p>
     * <note>
     * <p>
     * If this value is set to <code>DEFAULT</code>, the application will use the following values, even if they are set
     * to other values using APIs or application code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>CheckpointingEnabled:</b> true
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CheckpointInterval:</b> 60000
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MinPauseBetweenCheckpoints:</b> 5000
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configurationType}
     * will return {@link ConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configurationTypeAsString}.
     * </p>
     * 
     * @return Describes whether the application uses Kinesis Data Analytics' default checkpointing behavior. You must
     *         set this property to <code>CUSTOM</code> in order to set the <code>CheckpointingEnabled</code>,
     *         <code>CheckpointInterval</code>, or <code>MinPauseBetweenCheckpoints</code> parameters.</p> <note>
     *         <p>
     *         If this value is set to <code>DEFAULT</code>, the application will use the following values, even if they
     *         are set to other values using APIs or application code:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>CheckpointingEnabled:</b> true
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CheckpointInterval:</b> 60000
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MinPauseBetweenCheckpoints:</b> 5000
     *         </p>
     *         </li>
     *         </ul>
     * @see ConfigurationType
     */
    public final String configurationTypeAsString() {
        return configurationType;
    }

    /**
     * <p>
     * Describes whether checkpointing is enabled for a Flink-based Kinesis Data Analytics application.
     * </p>
     * <note>
     * <p>
     * If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application will use a
     * <code>CheckpointingEnabled</code> value of <code>true</code>, even if this value is set to another value using
     * this API or in application code.
     * </p>
     * </note>
     * 
     * @return Describes whether checkpointing is enabled for a Flink-based Kinesis Data Analytics application.</p>
     *         <note>
     *         <p>
     *         If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application will
     *         use a <code>CheckpointingEnabled</code> value of <code>true</code>, even if this value is set to another
     *         value using this API or in application code.
     *         </p>
     */
    public final Boolean checkpointingEnabled() {
        return checkpointingEnabled;
    }

    /**
     * <p>
     * Describes the interval in milliseconds between checkpoint operations.
     * </p>
     * <note>
     * <p>
     * If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application will use a
     * <code>CheckpointInterval</code> vaue of 60000, even if this value is set to another value using this API or in
     * application code.
     * </p>
     * </note>
     * 
     * @return Describes the interval in milliseconds between checkpoint operations. </p> <note>
     *         <p>
     *         If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application will
     *         use a <code>CheckpointInterval</code> vaue of 60000, even if this value is set to another value using
     *         this API or in application code.
     *         </p>
     */
    public final Long checkpointInterval() {
        return checkpointInterval;
    }

    /**
     * <p>
     * Describes the minimum time in milliseconds after a checkpoint operation completes that a new checkpoint operation
     * can start. If a checkpoint operation takes longer than the <code>CheckpointInterval</code>, the application
     * otherwise performs continual checkpoint operations. For more information, see <a href=
     * "https://ci.apache.org/projects/flink/flink-docs-release-1.8/ops/state/large_state_tuning.html#tuning-checkpointing"
     * > Tuning Checkpointing</a> in the <a href="https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache
     * Flink Documentation</a>.
     * </p>
     * <note>
     * <p>
     * If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application will use a
     * <code>MinPauseBetweenCheckpoints</code> value of 5000, even if this value is set using this API or in application
     * code.
     * </p>
     * </note>
     * 
     * @return Describes the minimum time in milliseconds after a checkpoint operation completes that a new checkpoint
     *         operation can start. If a checkpoint operation takes longer than the <code>CheckpointInterval</code>, the
     *         application otherwise performs continual checkpoint operations. For more information, see <a href=
     *         "https://ci.apache.org/projects/flink/flink-docs-release-1.8/ops/state/large_state_tuning.html#tuning-checkpointing"
     *         > Tuning Checkpointing</a> in the <a
     *         href="https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink Documentation</a>.</p>
     *         <note>
     *         <p>
     *         If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application will
     *         use a <code>MinPauseBetweenCheckpoints</code> value of 5000, even if this value is set using this API or
     *         in application code.
     *         </p>
     */
    public final Long minPauseBetweenCheckpoints() {
        return minPauseBetweenCheckpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(checkpointingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(checkpointInterval());
        hashCode = 31 * hashCode + Objects.hashCode(minPauseBetweenCheckpoints());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckpointConfiguration)) {
            return false;
        }
        CheckpointConfiguration other = (CheckpointConfiguration) obj;
        return Objects.equals(configurationTypeAsString(), other.configurationTypeAsString())
                && Objects.equals(checkpointingEnabled(), other.checkpointingEnabled())
                && Objects.equals(checkpointInterval(), other.checkpointInterval())
                && Objects.equals(minPauseBetweenCheckpoints(), other.minPauseBetweenCheckpoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckpointConfiguration").add("ConfigurationType", configurationTypeAsString())
                .add("CheckpointingEnabled", checkpointingEnabled()).add("CheckpointInterval", checkpointInterval())
                .add("MinPauseBetweenCheckpoints", minPauseBetweenCheckpoints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationType":
            return Optional.ofNullable(clazz.cast(configurationTypeAsString()));
        case "CheckpointingEnabled":
            return Optional.ofNullable(clazz.cast(checkpointingEnabled()));
        case "CheckpointInterval":
            return Optional.ofNullable(clazz.cast(checkpointInterval()));
        case "MinPauseBetweenCheckpoints":
            return Optional.ofNullable(clazz.cast(minPauseBetweenCheckpoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckpointConfiguration, T> g) {
        return obj -> g.apply((CheckpointConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CheckpointConfiguration> {
        /**
         * <p>
         * Describes whether the application uses Kinesis Data Analytics' default checkpointing behavior. You must set
         * this property to <code>CUSTOM</code> in order to set the <code>CheckpointingEnabled</code>,
         * <code>CheckpointInterval</code>, or <code>MinPauseBetweenCheckpoints</code> parameters.
         * </p>
         * <note>
         * <p>
         * If this value is set to <code>DEFAULT</code>, the application will use the following values, even if they are
         * set to other values using APIs or application code:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>CheckpointingEnabled:</b> true
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CheckpointInterval:</b> 60000
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MinPauseBetweenCheckpoints:</b> 5000
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param configurationType
         *        Describes whether the application uses Kinesis Data Analytics' default checkpointing behavior. You
         *        must set this property to <code>CUSTOM</code> in order to set the <code>CheckpointingEnabled</code>,
         *        <code>CheckpointInterval</code>, or <code>MinPauseBetweenCheckpoints</code> parameters.</p> <note>
         *        <p>
         *        If this value is set to <code>DEFAULT</code>, the application will use the following values, even if
         *        they are set to other values using APIs or application code:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>CheckpointingEnabled:</b> true
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CheckpointInterval:</b> 60000
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MinPauseBetweenCheckpoints:</b> 5000
         *        </p>
         *        </li>
         *        </ul>
         * @see ConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationType
         */
        Builder configurationType(String configurationType);

        /**
         * <p>
         * Describes whether the application uses Kinesis Data Analytics' default checkpointing behavior. You must set
         * this property to <code>CUSTOM</code> in order to set the <code>CheckpointingEnabled</code>,
         * <code>CheckpointInterval</code>, or <code>MinPauseBetweenCheckpoints</code> parameters.
         * </p>
         * <note>
         * <p>
         * If this value is set to <code>DEFAULT</code>, the application will use the following values, even if they are
         * set to other values using APIs or application code:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>CheckpointingEnabled:</b> true
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CheckpointInterval:</b> 60000
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MinPauseBetweenCheckpoints:</b> 5000
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param configurationType
         *        Describes whether the application uses Kinesis Data Analytics' default checkpointing behavior. You
         *        must set this property to <code>CUSTOM</code> in order to set the <code>CheckpointingEnabled</code>,
         *        <code>CheckpointInterval</code>, or <code>MinPauseBetweenCheckpoints</code> parameters.</p> <note>
         *        <p>
         *        If this value is set to <code>DEFAULT</code>, the application will use the following values, even if
         *        they are set to other values using APIs or application code:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>CheckpointingEnabled:</b> true
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CheckpointInterval:</b> 60000
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MinPauseBetweenCheckpoints:</b> 5000
         *        </p>
         *        </li>
         *        </ul>
         * @see ConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationType
         */
        Builder configurationType(ConfigurationType configurationType);

        /**
         * <p>
         * Describes whether checkpointing is enabled for a Flink-based Kinesis Data Analytics application.
         * </p>
         * <note>
         * <p>
         * If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application will use a
         * <code>CheckpointingEnabled</code> value of <code>true</code>, even if this value is set to another value
         * using this API or in application code.
         * </p>
         * </note>
         * 
         * @param checkpointingEnabled
         *        Describes whether checkpointing is enabled for a Flink-based Kinesis Data Analytics application.</p>
         *        <note>
         *        <p>
         *        If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application
         *        will use a <code>CheckpointingEnabled</code> value of <code>true</code>, even if this value is set to
         *        another value using this API or in application code.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkpointingEnabled(Boolean checkpointingEnabled);

        /**
         * <p>
         * Describes the interval in milliseconds between checkpoint operations.
         * </p>
         * <note>
         * <p>
         * If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application will use a
         * <code>CheckpointInterval</code> vaue of 60000, even if this value is set to another value using this API or
         * in application code.
         * </p>
         * </note>
         * 
         * @param checkpointInterval
         *        Describes the interval in milliseconds between checkpoint operations. </p> <note>
         *        <p>
         *        If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application
         *        will use a <code>CheckpointInterval</code> vaue of 60000, even if this value is set to another value
         *        using this API or in application code.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkpointInterval(Long checkpointInterval);

        /**
         * <p>
         * Describes the minimum time in milliseconds after a checkpoint operation completes that a new checkpoint
         * operation can start. If a checkpoint operation takes longer than the <code>CheckpointInterval</code>, the
         * application otherwise performs continual checkpoint operations. For more information, see <a href=
         * "https://ci.apache.org/projects/flink/flink-docs-release-1.8/ops/state/large_state_tuning.html#tuning-checkpointing"
         * > Tuning Checkpointing</a> in the <a
         * href="https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink Documentation</a>.
         * </p>
         * <note>
         * <p>
         * If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application will use a
         * <code>MinPauseBetweenCheckpoints</code> value of 5000, even if this value is set using this API or in
         * application code.
         * </p>
         * </note>
         * 
         * @param minPauseBetweenCheckpoints
         *        Describes the minimum time in milliseconds after a checkpoint operation completes that a new
         *        checkpoint operation can start. If a checkpoint operation takes longer than the
         *        <code>CheckpointInterval</code>, the application otherwise performs continual checkpoint operations.
         *        For more information, see <a href=
         *        "https://ci.apache.org/projects/flink/flink-docs-release-1.8/ops/state/large_state_tuning.html#tuning-checkpointing"
         *        > Tuning Checkpointing</a> in the <a
         *        href="https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink
         *        Documentation</a>.</p> <note>
         *        <p>
         *        If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application
         *        will use a <code>MinPauseBetweenCheckpoints</code> value of 5000, even if this value is set using this
         *        API or in application code.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minPauseBetweenCheckpoints(Long minPauseBetweenCheckpoints);
    }

    static final class BuilderImpl implements Builder {
        private String configurationType;

        private Boolean checkpointingEnabled;

        private Long checkpointInterval;

        private Long minPauseBetweenCheckpoints;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckpointConfiguration model) {
            configurationType(model.configurationType);
            checkpointingEnabled(model.checkpointingEnabled);
            checkpointInterval(model.checkpointInterval);
            minPauseBetweenCheckpoints(model.minPauseBetweenCheckpoints);
        }

        public final String getConfigurationType() {
            return configurationType;
        }

        @Override
        public final Builder configurationType(String configurationType) {
            this.configurationType = configurationType;
            return this;
        }

        @Override
        public final Builder configurationType(ConfigurationType configurationType) {
            this.configurationType(configurationType == null ? null : configurationType.toString());
            return this;
        }

        public final void setConfigurationType(String configurationType) {
            this.configurationType = configurationType;
        }

        public final Boolean getCheckpointingEnabled() {
            return checkpointingEnabled;
        }

        @Override
        public final Builder checkpointingEnabled(Boolean checkpointingEnabled) {
            this.checkpointingEnabled = checkpointingEnabled;
            return this;
        }

        public final void setCheckpointingEnabled(Boolean checkpointingEnabled) {
            this.checkpointingEnabled = checkpointingEnabled;
        }

        public final Long getCheckpointInterval() {
            return checkpointInterval;
        }

        @Override
        public final Builder checkpointInterval(Long checkpointInterval) {
            this.checkpointInterval = checkpointInterval;
            return this;
        }

        public final void setCheckpointInterval(Long checkpointInterval) {
            this.checkpointInterval = checkpointInterval;
        }

        public final Long getMinPauseBetweenCheckpoints() {
            return minPauseBetweenCheckpoints;
        }

        @Override
        public final Builder minPauseBetweenCheckpoints(Long minPauseBetweenCheckpoints) {
            this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
            return this;
        }

        public final void setMinPauseBetweenCheckpoints(Long minPauseBetweenCheckpoints) {
            this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
        }

        @Override
        public CheckpointConfiguration build() {
            return new CheckpointConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
