/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the application, including the application Amazon Resource Name (ARN), status, latest version, and input
 * and output configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationDetail.Builder, ApplicationDetail> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationARN").getter(getter(ApplicationDetail::applicationARN))
            .setter(setter(Builder::applicationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()).build();

    private static final SdkField<String> APPLICATION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationDescription").getter(getter(ApplicationDetail::applicationDescription))
            .setter(setter(Builder::applicationDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationDescription").build())
            .build();

    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(ApplicationDetail::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> RUNTIME_ENVIRONMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuntimeEnvironment").getter(getter(ApplicationDetail::runtimeEnvironmentAsString))
            .setter(setter(Builder::runtimeEnvironment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeEnvironment").build())
            .build();

    private static final SdkField<String> SERVICE_EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceExecutionRole").getter(getter(ApplicationDetail::serviceExecutionRole))
            .setter(setter(Builder::serviceExecutionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceExecutionRole").build())
            .build();

    private static final SdkField<String> APPLICATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationStatus").getter(getter(ApplicationDetail::applicationStatusAsString))
            .setter(setter(Builder::applicationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationStatus").build()).build();

    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ApplicationVersionId").getter(getter(ApplicationDetail::applicationVersionId))
            .setter(setter(Builder::applicationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build())
            .build();

    private static final SdkField<Instant> CREATE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTimestamp").getter(getter(ApplicationDetail::createTimestamp))
            .setter(setter(Builder::createTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTimestamp").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTimestamp").getter(getter(ApplicationDetail::lastUpdateTimestamp))
            .setter(setter(Builder::lastUpdateTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimestamp").build())
            .build();

    private static final SdkField<ApplicationConfigurationDescription> APPLICATION_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<ApplicationConfigurationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationConfigurationDescription")
            .getter(getter(ApplicationDetail::applicationConfigurationDescription))
            .setter(setter(Builder::applicationConfigurationDescription))
            .constructor(ApplicationConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ApplicationConfigurationDescription").build()).build();

    private static final SdkField<List<CloudWatchLoggingOptionDescription>> CLOUD_WATCH_LOGGING_OPTION_DESCRIPTIONS_FIELD = SdkField
            .<List<CloudWatchLoggingOptionDescription>> builder(MarshallingType.LIST)
            .memberName("CloudWatchLoggingOptionDescriptions")
            .getter(getter(ApplicationDetail::cloudWatchLoggingOptionDescriptions))
            .setter(setter(Builder::cloudWatchLoggingOptionDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CloudWatchLoggingOptionDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CloudWatchLoggingOptionDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(CloudWatchLoggingOptionDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            APPLICATION_DESCRIPTION_FIELD, APPLICATION_NAME_FIELD, RUNTIME_ENVIRONMENT_FIELD, SERVICE_EXECUTION_ROLE_FIELD,
            APPLICATION_STATUS_FIELD, APPLICATION_VERSION_ID_FIELD, CREATE_TIMESTAMP_FIELD, LAST_UPDATE_TIMESTAMP_FIELD,
            APPLICATION_CONFIGURATION_DESCRIPTION_FIELD, CLOUD_WATCH_LOGGING_OPTION_DESCRIPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationARN;

    private final String applicationDescription;

    private final String applicationName;

    private final String runtimeEnvironment;

    private final String serviceExecutionRole;

    private final String applicationStatus;

    private final Long applicationVersionId;

    private final Instant createTimestamp;

    private final Instant lastUpdateTimestamp;

    private final ApplicationConfigurationDescription applicationConfigurationDescription;

    private final List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions;

    private ApplicationDetail(BuilderImpl builder) {
        this.applicationARN = builder.applicationARN;
        this.applicationDescription = builder.applicationDescription;
        this.applicationName = builder.applicationName;
        this.runtimeEnvironment = builder.runtimeEnvironment;
        this.serviceExecutionRole = builder.serviceExecutionRole;
        this.applicationStatus = builder.applicationStatus;
        this.applicationVersionId = builder.applicationVersionId;
        this.createTimestamp = builder.createTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.applicationConfigurationDescription = builder.applicationConfigurationDescription;
        this.cloudWatchLoggingOptionDescriptions = builder.cloudWatchLoggingOptionDescriptions;
    }

    /**
     * <p>
     * The ARN of the application.
     * </p>
     * 
     * @return The ARN of the application.
     */
    public final String applicationARN() {
        return applicationARN;
    }

    /**
     * <p>
     * The description of the application.
     * </p>
     * 
     * @return The description of the application.
     */
    public final String applicationDescription() {
        return applicationDescription;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The runtime environment for the application (<code>SQL-1.0</code>, <code>FLINK-1_6</code>, or
     * <code>FLINK-1_8</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #runtimeEnvironment} will return {@link RuntimeEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #runtimeEnvironmentAsString}.
     * </p>
     * 
     * @return The runtime environment for the application (<code>SQL-1.0</code>, <code>FLINK-1_6</code>, or
     *         <code>FLINK-1_8</code>).
     * @see RuntimeEnvironment
     */
    public final RuntimeEnvironment runtimeEnvironment() {
        return RuntimeEnvironment.fromValue(runtimeEnvironment);
    }

    /**
     * <p>
     * The runtime environment for the application (<code>SQL-1.0</code>, <code>FLINK-1_6</code>, or
     * <code>FLINK-1_8</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #runtimeEnvironment} will return {@link RuntimeEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #runtimeEnvironmentAsString}.
     * </p>
     * 
     * @return The runtime environment for the application (<code>SQL-1.0</code>, <code>FLINK-1_6</code>, or
     *         <code>FLINK-1_8</code>).
     * @see RuntimeEnvironment
     */
    public final String runtimeEnvironmentAsString() {
        return runtimeEnvironment;
    }

    /**
     * <p>
     * Specifies the IAM role that the application uses to access external resources.
     * </p>
     * 
     * @return Specifies the IAM role that the application uses to access external resources.
     */
    public final String serviceExecutionRole() {
        return serviceExecutionRole;
    }

    /**
     * <p>
     * The status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationStatus}
     * will return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStatusAsString}.
     * </p>
     * 
     * @return The status of the application.
     * @see ApplicationStatus
     */
    public final ApplicationStatus applicationStatus() {
        return ApplicationStatus.fromValue(applicationStatus);
    }

    /**
     * <p>
     * The status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationStatus}
     * will return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStatusAsString}.
     * </p>
     * 
     * @return The status of the application.
     * @see ApplicationStatus
     */
    public final String applicationStatusAsString() {
        return applicationStatus;
    }

    /**
     * <p>
     * Provides the current application version. Kinesis Data Analytics updates the <code>ApplicationVersionId</code>
     * each time you update the application.
     * </p>
     * 
     * @return Provides the current application version. Kinesis Data Analytics updates the
     *         <code>ApplicationVersionId</code> each time you update the application.
     */
    public final Long applicationVersionId() {
        return applicationVersionId;
    }

    /**
     * <p>
     * The current timestamp when the application was created.
     * </p>
     * 
     * @return The current timestamp when the application was created.
     */
    public final Instant createTimestamp() {
        return createTimestamp;
    }

    /**
     * <p>
     * The current timestamp when the application was last updated.
     * </p>
     * 
     * @return The current timestamp when the application was last updated.
     */
    public final Instant lastUpdateTimestamp() {
        return lastUpdateTimestamp;
    }

    /**
     * <p>
     * Provides details about the application's Java, SQL, or Scala code and starting parameters.
     * </p>
     * 
     * @return Provides details about the application's Java, SQL, or Scala code and starting parameters.
     */
    public final ApplicationConfigurationDescription applicationConfigurationDescription() {
        return applicationConfigurationDescription;
    }

    /**
     * Returns true if the CloudWatchLoggingOptionDescriptions property was specified by the sender (it may be empty),
     * or false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the
     * sender is the AWS service.
     */
    public final boolean hasCloudWatchLoggingOptionDescriptions() {
        return cloudWatchLoggingOptionDescriptions != null
                && !(cloudWatchLoggingOptionDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the application Amazon CloudWatch logging options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCloudWatchLoggingOptionDescriptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Describes the application Amazon CloudWatch logging options.
     */
    public final List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions() {
        return cloudWatchLoggingOptionDescriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(applicationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeEnvironmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceExecutionRole());
        hashCode = 31 * hashCode + Objects.hashCode(applicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(applicationConfigurationDescription());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCloudWatchLoggingOptionDescriptions() ? cloudWatchLoggingOptionDescriptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationDetail)) {
            return false;
        }
        ApplicationDetail other = (ApplicationDetail) obj;
        return Objects.equals(applicationARN(), other.applicationARN())
                && Objects.equals(applicationDescription(), other.applicationDescription())
                && Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(runtimeEnvironmentAsString(), other.runtimeEnvironmentAsString())
                && Objects.equals(serviceExecutionRole(), other.serviceExecutionRole())
                && Objects.equals(applicationStatusAsString(), other.applicationStatusAsString())
                && Objects.equals(applicationVersionId(), other.applicationVersionId())
                && Objects.equals(createTimestamp(), other.createTimestamp())
                && Objects.equals(lastUpdateTimestamp(), other.lastUpdateTimestamp())
                && Objects.equals(applicationConfigurationDescription(), other.applicationConfigurationDescription())
                && hasCloudWatchLoggingOptionDescriptions() == other.hasCloudWatchLoggingOptionDescriptions()
                && Objects.equals(cloudWatchLoggingOptionDescriptions(), other.cloudWatchLoggingOptionDescriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ApplicationDetail")
                .add("ApplicationARN", applicationARN())
                .add("ApplicationDescription", applicationDescription())
                .add("ApplicationName", applicationName())
                .add("RuntimeEnvironment", runtimeEnvironmentAsString())
                .add("ServiceExecutionRole", serviceExecutionRole())
                .add("ApplicationStatus", applicationStatusAsString())
                .add("ApplicationVersionId", applicationVersionId())
                .add("CreateTimestamp", createTimestamp())
                .add("LastUpdateTimestamp", lastUpdateTimestamp())
                .add("ApplicationConfigurationDescription", applicationConfigurationDescription())
                .add("CloudWatchLoggingOptionDescriptions",
                        hasCloudWatchLoggingOptionDescriptions() ? cloudWatchLoggingOptionDescriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationARN":
            return Optional.ofNullable(clazz.cast(applicationARN()));
        case "ApplicationDescription":
            return Optional.ofNullable(clazz.cast(applicationDescription()));
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "RuntimeEnvironment":
            return Optional.ofNullable(clazz.cast(runtimeEnvironmentAsString()));
        case "ServiceExecutionRole":
            return Optional.ofNullable(clazz.cast(serviceExecutionRole()));
        case "ApplicationStatus":
            return Optional.ofNullable(clazz.cast(applicationStatusAsString()));
        case "ApplicationVersionId":
            return Optional.ofNullable(clazz.cast(applicationVersionId()));
        case "CreateTimestamp":
            return Optional.ofNullable(clazz.cast(createTimestamp()));
        case "LastUpdateTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdateTimestamp()));
        case "ApplicationConfigurationDescription":
            return Optional.ofNullable(clazz.cast(applicationConfigurationDescription()));
        case "CloudWatchLoggingOptionDescriptions":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOptionDescriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationDetail, T> g) {
        return obj -> g.apply((ApplicationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationDetail> {
        /**
         * <p>
         * The ARN of the application.
         * </p>
         * 
         * @param applicationARN
         *        The ARN of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationARN(String applicationARN);

        /**
         * <p>
         * The description of the application.
         * </p>
         * 
         * @param applicationDescription
         *        The description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationDescription(String applicationDescription);

        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param applicationName
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The runtime environment for the application (<code>SQL-1.0</code>, <code>FLINK-1_6</code>, or
         * <code>FLINK-1_8</code>).
         * </p>
         * 
         * @param runtimeEnvironment
         *        The runtime environment for the application (<code>SQL-1.0</code>, <code>FLINK-1_6</code>, or
         *        <code>FLINK-1_8</code>).
         * @see RuntimeEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuntimeEnvironment
         */
        Builder runtimeEnvironment(String runtimeEnvironment);

        /**
         * <p>
         * The runtime environment for the application (<code>SQL-1.0</code>, <code>FLINK-1_6</code>, or
         * <code>FLINK-1_8</code>).
         * </p>
         * 
         * @param runtimeEnvironment
         *        The runtime environment for the application (<code>SQL-1.0</code>, <code>FLINK-1_6</code>, or
         *        <code>FLINK-1_8</code>).
         * @see RuntimeEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuntimeEnvironment
         */
        Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment);

        /**
         * <p>
         * Specifies the IAM role that the application uses to access external resources.
         * </p>
         * 
         * @param serviceExecutionRole
         *        Specifies the IAM role that the application uses to access external resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceExecutionRole(String serviceExecutionRole);

        /**
         * <p>
         * The status of the application.
         * </p>
         * 
         * @param applicationStatus
         *        The status of the application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(String applicationStatus);

        /**
         * <p>
         * The status of the application.
         * </p>
         * 
         * @param applicationStatus
         *        The status of the application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(ApplicationStatus applicationStatus);

        /**
         * <p>
         * Provides the current application version. Kinesis Data Analytics updates the
         * <code>ApplicationVersionId</code> each time you update the application.
         * </p>
         * 
         * @param applicationVersionId
         *        Provides the current application version. Kinesis Data Analytics updates the
         *        <code>ApplicationVersionId</code> each time you update the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionId(Long applicationVersionId);

        /**
         * <p>
         * The current timestamp when the application was created.
         * </p>
         * 
         * @param createTimestamp
         *        The current timestamp when the application was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTimestamp(Instant createTimestamp);

        /**
         * <p>
         * The current timestamp when the application was last updated.
         * </p>
         * 
         * @param lastUpdateTimestamp
         *        The current timestamp when the application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTimestamp(Instant lastUpdateTimestamp);

        /**
         * <p>
         * Provides details about the application's Java, SQL, or Scala code and starting parameters.
         * </p>
         * 
         * @param applicationConfigurationDescription
         *        Provides details about the application's Java, SQL, or Scala code and starting parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationConfigurationDescription(ApplicationConfigurationDescription applicationConfigurationDescription);

        /**
         * <p>
         * Provides details about the application's Java, SQL, or Scala code and starting parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationConfigurationDescription.Builder}
         * avoiding the need to create one manually via {@link ApplicationConfigurationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationConfigurationDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #applicationConfigurationDescription(ApplicationConfigurationDescription)}.
         * 
         * @param applicationConfigurationDescription
         *        a consumer that will call methods on {@link ApplicationConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationConfigurationDescription(ApplicationConfigurationDescription)
         */
        default Builder applicationConfigurationDescription(
                Consumer<ApplicationConfigurationDescription.Builder> applicationConfigurationDescription) {
            return applicationConfigurationDescription(ApplicationConfigurationDescription.builder()
                    .applyMutation(applicationConfigurationDescription).build());
        }

        /**
         * <p>
         * Describes the application Amazon CloudWatch logging options.
         * </p>
         * 
         * @param cloudWatchLoggingOptionDescriptions
         *        Describes the application Amazon CloudWatch logging options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptionDescriptions(
                Collection<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions);

        /**
         * <p>
         * Describes the application Amazon CloudWatch logging options.
         * </p>
         * 
         * @param cloudWatchLoggingOptionDescriptions
         *        Describes the application Amazon CloudWatch logging options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptionDescriptions(CloudWatchLoggingOptionDescription... cloudWatchLoggingOptionDescriptions);

        /**
         * <p>
         * Describes the application Amazon CloudWatch logging options.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <CloudWatchLoggingOptionDescription>.Builder} avoiding the need to create one manually via {@link List
         * <CloudWatchLoggingOptionDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CloudWatchLoggingOptionDescription>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #cloudWatchLoggingOptionDescriptions(List<CloudWatchLoggingOptionDescription>)}.
         * 
         * @param cloudWatchLoggingOptionDescriptions
         *        a consumer that will call methods on {@link List<CloudWatchLoggingOptionDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptionDescriptions(List<CloudWatchLoggingOptionDescription>)
         */
        Builder cloudWatchLoggingOptionDescriptions(
                Consumer<CloudWatchLoggingOptionDescription.Builder>... cloudWatchLoggingOptionDescriptions);
    }

    static final class BuilderImpl implements Builder {
        private String applicationARN;

        private String applicationDescription;

        private String applicationName;

        private String runtimeEnvironment;

        private String serviceExecutionRole;

        private String applicationStatus;

        private Long applicationVersionId;

        private Instant createTimestamp;

        private Instant lastUpdateTimestamp;

        private ApplicationConfigurationDescription applicationConfigurationDescription;

        private List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationDetail model) {
            applicationARN(model.applicationARN);
            applicationDescription(model.applicationDescription);
            applicationName(model.applicationName);
            runtimeEnvironment(model.runtimeEnvironment);
            serviceExecutionRole(model.serviceExecutionRole);
            applicationStatus(model.applicationStatus);
            applicationVersionId(model.applicationVersionId);
            createTimestamp(model.createTimestamp);
            lastUpdateTimestamp(model.lastUpdateTimestamp);
            applicationConfigurationDescription(model.applicationConfigurationDescription);
            cloudWatchLoggingOptionDescriptions(model.cloudWatchLoggingOptionDescriptions);
        }

        public final String getApplicationARN() {
            return applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        public final String getApplicationDescription() {
            return applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getRuntimeEnvironment() {
            return runtimeEnvironment;
        }

        @Override
        public final Builder runtimeEnvironment(String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
            return this;
        }

        @Override
        public final Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
            this.runtimeEnvironment(runtimeEnvironment == null ? null : runtimeEnvironment.toString());
            return this;
        }

        public final void setRuntimeEnvironment(String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
        }

        public final String getServiceExecutionRole() {
            return serviceExecutionRole;
        }

        @Override
        public final Builder serviceExecutionRole(String serviceExecutionRole) {
            this.serviceExecutionRole = serviceExecutionRole;
            return this;
        }

        public final void setServiceExecutionRole(String serviceExecutionRole) {
            this.serviceExecutionRole = serviceExecutionRole;
        }

        public final String getApplicationStatus() {
            return applicationStatus;
        }

        @Override
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus == null ? null : applicationStatus.toString());
            return this;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        public final Long getApplicationVersionId() {
            return applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        public final Instant getCreateTimestamp() {
            return createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        public final Instant getLastUpdateTimestamp() {
            return lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public final void setLastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        public final ApplicationConfigurationDescription.Builder getApplicationConfigurationDescription() {
            return applicationConfigurationDescription != null ? applicationConfigurationDescription.toBuilder() : null;
        }

        @Override
        public final Builder applicationConfigurationDescription(
                ApplicationConfigurationDescription applicationConfigurationDescription) {
            this.applicationConfigurationDescription = applicationConfigurationDescription;
            return this;
        }

        public final void setApplicationConfigurationDescription(
                ApplicationConfigurationDescription.BuilderImpl applicationConfigurationDescription) {
            this.applicationConfigurationDescription = applicationConfigurationDescription != null ? applicationConfigurationDescription
                    .build() : null;
        }

        public final Collection<CloudWatchLoggingOptionDescription.Builder> getCloudWatchLoggingOptionDescriptions() {
            if (cloudWatchLoggingOptionDescriptions instanceof SdkAutoConstructList) {
                return null;
            }
            return cloudWatchLoggingOptionDescriptions != null ? cloudWatchLoggingOptionDescriptions.stream()
                    .map(CloudWatchLoggingOptionDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptionDescriptions(
                Collection<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier
                    .copy(cloudWatchLoggingOptionDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionDescriptions(
                CloudWatchLoggingOptionDescription... cloudWatchLoggingOptionDescriptions) {
            cloudWatchLoggingOptionDescriptions(Arrays.asList(cloudWatchLoggingOptionDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionDescriptions(
                Consumer<CloudWatchLoggingOptionDescription.Builder>... cloudWatchLoggingOptionDescriptions) {
            cloudWatchLoggingOptionDescriptions(Stream.of(cloudWatchLoggingOptionDescriptions)
                    .map(c -> CloudWatchLoggingOptionDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCloudWatchLoggingOptionDescriptions(
                Collection<CloudWatchLoggingOptionDescription.BuilderImpl> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier
                    .copyFromBuilder(cloudWatchLoggingOptionDescriptions);
        }

        @Override
        public ApplicationDetail build() {
            return new ApplicationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
