/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates to an application's configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationConfigurationUpdate.Builder, ApplicationConfigurationUpdate> {
    private static final SdkField<SqlApplicationConfigurationUpdate> SQL_APPLICATION_CONFIGURATION_UPDATE_FIELD = SdkField
            .<SqlApplicationConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("SqlApplicationConfigurationUpdate")
            .getter(getter(ApplicationConfigurationUpdate::sqlApplicationConfigurationUpdate))
            .setter(setter(Builder::sqlApplicationConfigurationUpdate))
            .constructor(SqlApplicationConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlApplicationConfigurationUpdate")
                    .build()).build();

    private static final SdkField<ApplicationCodeConfigurationUpdate> APPLICATION_CODE_CONFIGURATION_UPDATE_FIELD = SdkField
            .<ApplicationCodeConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationCodeConfigurationUpdate")
            .getter(getter(ApplicationConfigurationUpdate::applicationCodeConfigurationUpdate))
            .setter(setter(Builder::applicationCodeConfigurationUpdate))
            .constructor(ApplicationCodeConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationCodeConfigurationUpdate")
                    .build()).build();

    private static final SdkField<FlinkApplicationConfigurationUpdate> FLINK_APPLICATION_CONFIGURATION_UPDATE_FIELD = SdkField
            .<FlinkApplicationConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("FlinkApplicationConfigurationUpdate")
            .getter(getter(ApplicationConfigurationUpdate::flinkApplicationConfigurationUpdate))
            .setter(setter(Builder::flinkApplicationConfigurationUpdate))
            .constructor(FlinkApplicationConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("FlinkApplicationConfigurationUpdate").build()).build();

    private static final SdkField<EnvironmentPropertyUpdates> ENVIRONMENT_PROPERTY_UPDATES_FIELD = SdkField
            .<EnvironmentPropertyUpdates> builder(MarshallingType.SDK_POJO)
            .memberName("EnvironmentPropertyUpdates")
            .getter(getter(ApplicationConfigurationUpdate::environmentPropertyUpdates))
            .setter(setter(Builder::environmentPropertyUpdates))
            .constructor(EnvironmentPropertyUpdates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentPropertyUpdates").build())
            .build();

    private static final SdkField<ApplicationSnapshotConfigurationUpdate> APPLICATION_SNAPSHOT_CONFIGURATION_UPDATE_FIELD = SdkField
            .<ApplicationSnapshotConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationSnapshotConfigurationUpdate")
            .getter(getter(ApplicationConfigurationUpdate::applicationSnapshotConfigurationUpdate))
            .setter(setter(Builder::applicationSnapshotConfigurationUpdate))
            .constructor(ApplicationSnapshotConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ApplicationSnapshotConfigurationUpdate").build()).build();

    private static final SdkField<List<VpcConfigurationUpdate>> VPC_CONFIGURATION_UPDATES_FIELD = SdkField
            .<List<VpcConfigurationUpdate>> builder(MarshallingType.LIST)
            .memberName("VpcConfigurationUpdates")
            .getter(getter(ApplicationConfigurationUpdate::vpcConfigurationUpdates))
            .setter(setter(Builder::vpcConfigurationUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfigurationUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcConfigurationUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcConfigurationUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SQL_APPLICATION_CONFIGURATION_UPDATE_FIELD, APPLICATION_CODE_CONFIGURATION_UPDATE_FIELD,
            FLINK_APPLICATION_CONFIGURATION_UPDATE_FIELD, ENVIRONMENT_PROPERTY_UPDATES_FIELD,
            APPLICATION_SNAPSHOT_CONFIGURATION_UPDATE_FIELD, VPC_CONFIGURATION_UPDATES_FIELD));

    private static final long serialVersionUID = 1L;

    private final SqlApplicationConfigurationUpdate sqlApplicationConfigurationUpdate;

    private final ApplicationCodeConfigurationUpdate applicationCodeConfigurationUpdate;

    private final FlinkApplicationConfigurationUpdate flinkApplicationConfigurationUpdate;

    private final EnvironmentPropertyUpdates environmentPropertyUpdates;

    private final ApplicationSnapshotConfigurationUpdate applicationSnapshotConfigurationUpdate;

    private final List<VpcConfigurationUpdate> vpcConfigurationUpdates;

    private ApplicationConfigurationUpdate(BuilderImpl builder) {
        this.sqlApplicationConfigurationUpdate = builder.sqlApplicationConfigurationUpdate;
        this.applicationCodeConfigurationUpdate = builder.applicationCodeConfigurationUpdate;
        this.flinkApplicationConfigurationUpdate = builder.flinkApplicationConfigurationUpdate;
        this.environmentPropertyUpdates = builder.environmentPropertyUpdates;
        this.applicationSnapshotConfigurationUpdate = builder.applicationSnapshotConfigurationUpdate;
        this.vpcConfigurationUpdates = builder.vpcConfigurationUpdates;
    }

    /**
     * <p>
     * Describes updates to a SQL-based Kinesis Data Analytics application's configuration.
     * </p>
     * 
     * @return Describes updates to a SQL-based Kinesis Data Analytics application's configuration.
     */
    public final SqlApplicationConfigurationUpdate sqlApplicationConfigurationUpdate() {
        return sqlApplicationConfigurationUpdate;
    }

    /**
     * <p>
     * Describes updates to a Flink-based Kinesis Data Analytics application's code configuration.
     * </p>
     * 
     * @return Describes updates to a Flink-based Kinesis Data Analytics application's code configuration.
     */
    public final ApplicationCodeConfigurationUpdate applicationCodeConfigurationUpdate() {
        return applicationCodeConfigurationUpdate;
    }

    /**
     * <p>
     * Describes updates to a Flink-based Kinesis Data Analytics application's configuration.
     * </p>
     * 
     * @return Describes updates to a Flink-based Kinesis Data Analytics application's configuration.
     */
    public final FlinkApplicationConfigurationUpdate flinkApplicationConfigurationUpdate() {
        return flinkApplicationConfigurationUpdate;
    }

    /**
     * <p>
     * Describes updates to the environment properties for a Flink-based Kinesis Data Analytics application.
     * </p>
     * 
     * @return Describes updates to the environment properties for a Flink-based Kinesis Data Analytics application.
     */
    public final EnvironmentPropertyUpdates environmentPropertyUpdates() {
        return environmentPropertyUpdates;
    }

    /**
     * <p>
     * Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
     * </p>
     * 
     * @return Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
     */
    public final ApplicationSnapshotConfigurationUpdate applicationSnapshotConfigurationUpdate() {
        return applicationSnapshotConfigurationUpdate;
    }

    /**
     * Returns true if the VpcConfigurationUpdates property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasVpcConfigurationUpdates() {
        return vpcConfigurationUpdates != null && !(vpcConfigurationUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Updates to the array of descriptions of VPC configurations available to the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcConfigurationUpdates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Updates to the array of descriptions of VPC configurations available to the application.
     */
    public final List<VpcConfigurationUpdate> vpcConfigurationUpdates() {
        return vpcConfigurationUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sqlApplicationConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(applicationCodeConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(flinkApplicationConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(environmentPropertyUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(applicationSnapshotConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcConfigurationUpdates() ? vpcConfigurationUpdates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationConfigurationUpdate)) {
            return false;
        }
        ApplicationConfigurationUpdate other = (ApplicationConfigurationUpdate) obj;
        return Objects.equals(sqlApplicationConfigurationUpdate(), other.sqlApplicationConfigurationUpdate())
                && Objects.equals(applicationCodeConfigurationUpdate(), other.applicationCodeConfigurationUpdate())
                && Objects.equals(flinkApplicationConfigurationUpdate(), other.flinkApplicationConfigurationUpdate())
                && Objects.equals(environmentPropertyUpdates(), other.environmentPropertyUpdates())
                && Objects.equals(applicationSnapshotConfigurationUpdate(), other.applicationSnapshotConfigurationUpdate())
                && hasVpcConfigurationUpdates() == other.hasVpcConfigurationUpdates()
                && Objects.equals(vpcConfigurationUpdates(), other.vpcConfigurationUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationConfigurationUpdate")
                .add("SqlApplicationConfigurationUpdate", sqlApplicationConfigurationUpdate())
                .add("ApplicationCodeConfigurationUpdate", applicationCodeConfigurationUpdate())
                .add("FlinkApplicationConfigurationUpdate", flinkApplicationConfigurationUpdate())
                .add("EnvironmentPropertyUpdates", environmentPropertyUpdates())
                .add("ApplicationSnapshotConfigurationUpdate", applicationSnapshotConfigurationUpdate())
                .add("VpcConfigurationUpdates", hasVpcConfigurationUpdates() ? vpcConfigurationUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SqlApplicationConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(sqlApplicationConfigurationUpdate()));
        case "ApplicationCodeConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(applicationCodeConfigurationUpdate()));
        case "FlinkApplicationConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(flinkApplicationConfigurationUpdate()));
        case "EnvironmentPropertyUpdates":
            return Optional.ofNullable(clazz.cast(environmentPropertyUpdates()));
        case "ApplicationSnapshotConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(applicationSnapshotConfigurationUpdate()));
        case "VpcConfigurationUpdates":
            return Optional.ofNullable(clazz.cast(vpcConfigurationUpdates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationConfigurationUpdate, T> g) {
        return obj -> g.apply((ApplicationConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationConfigurationUpdate> {
        /**
         * <p>
         * Describes updates to a SQL-based Kinesis Data Analytics application's configuration.
         * </p>
         * 
         * @param sqlApplicationConfigurationUpdate
         *        Describes updates to a SQL-based Kinesis Data Analytics application's configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlApplicationConfigurationUpdate(SqlApplicationConfigurationUpdate sqlApplicationConfigurationUpdate);

        /**
         * <p>
         * Describes updates to a SQL-based Kinesis Data Analytics application's configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link SqlApplicationConfigurationUpdate.Builder}
         * avoiding the need to create one manually via {@link SqlApplicationConfigurationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link SqlApplicationConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #sqlApplicationConfigurationUpdate(SqlApplicationConfigurationUpdate)}.
         * 
         * @param sqlApplicationConfigurationUpdate
         *        a consumer that will call methods on {@link SqlApplicationConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlApplicationConfigurationUpdate(SqlApplicationConfigurationUpdate)
         */
        default Builder sqlApplicationConfigurationUpdate(
                Consumer<SqlApplicationConfigurationUpdate.Builder> sqlApplicationConfigurationUpdate) {
            return sqlApplicationConfigurationUpdate(SqlApplicationConfigurationUpdate.builder()
                    .applyMutation(sqlApplicationConfigurationUpdate).build());
        }

        /**
         * <p>
         * Describes updates to a Flink-based Kinesis Data Analytics application's code configuration.
         * </p>
         * 
         * @param applicationCodeConfigurationUpdate
         *        Describes updates to a Flink-based Kinesis Data Analytics application's code configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationCodeConfigurationUpdate(ApplicationCodeConfigurationUpdate applicationCodeConfigurationUpdate);

        /**
         * <p>
         * Describes updates to a Flink-based Kinesis Data Analytics application's code configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationCodeConfigurationUpdate.Builder}
         * avoiding the need to create one manually via {@link ApplicationCodeConfigurationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationCodeConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #applicationCodeConfigurationUpdate(ApplicationCodeConfigurationUpdate)}.
         * 
         * @param applicationCodeConfigurationUpdate
         *        a consumer that will call methods on {@link ApplicationCodeConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationCodeConfigurationUpdate(ApplicationCodeConfigurationUpdate)
         */
        default Builder applicationCodeConfigurationUpdate(
                Consumer<ApplicationCodeConfigurationUpdate.Builder> applicationCodeConfigurationUpdate) {
            return applicationCodeConfigurationUpdate(ApplicationCodeConfigurationUpdate.builder()
                    .applyMutation(applicationCodeConfigurationUpdate).build());
        }

        /**
         * <p>
         * Describes updates to a Flink-based Kinesis Data Analytics application's configuration.
         * </p>
         * 
         * @param flinkApplicationConfigurationUpdate
         *        Describes updates to a Flink-based Kinesis Data Analytics application's configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flinkApplicationConfigurationUpdate(FlinkApplicationConfigurationUpdate flinkApplicationConfigurationUpdate);

        /**
         * <p>
         * Describes updates to a Flink-based Kinesis Data Analytics application's configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link FlinkApplicationConfigurationUpdate.Builder}
         * avoiding the need to create one manually via {@link FlinkApplicationConfigurationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link FlinkApplicationConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #flinkApplicationConfigurationUpdate(FlinkApplicationConfigurationUpdate)}.
         * 
         * @param flinkApplicationConfigurationUpdate
         *        a consumer that will call methods on {@link FlinkApplicationConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flinkApplicationConfigurationUpdate(FlinkApplicationConfigurationUpdate)
         */
        default Builder flinkApplicationConfigurationUpdate(
                Consumer<FlinkApplicationConfigurationUpdate.Builder> flinkApplicationConfigurationUpdate) {
            return flinkApplicationConfigurationUpdate(FlinkApplicationConfigurationUpdate.builder()
                    .applyMutation(flinkApplicationConfigurationUpdate).build());
        }

        /**
         * <p>
         * Describes updates to the environment properties for a Flink-based Kinesis Data Analytics application.
         * </p>
         * 
         * @param environmentPropertyUpdates
         *        Describes updates to the environment properties for a Flink-based Kinesis Data Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentPropertyUpdates(EnvironmentPropertyUpdates environmentPropertyUpdates);

        /**
         * <p>
         * Describes updates to the environment properties for a Flink-based Kinesis Data Analytics application.
         * </p>
         * This is a convenience that creates an instance of the {@link EnvironmentPropertyUpdates.Builder} avoiding the
         * need to create one manually via {@link EnvironmentPropertyUpdates#builder()}.
         *
         * When the {@link Consumer} completes, {@link EnvironmentPropertyUpdates.Builder#build()} is called immediately
         * and its result is passed to {@link #environmentPropertyUpdates(EnvironmentPropertyUpdates)}.
         * 
         * @param environmentPropertyUpdates
         *        a consumer that will call methods on {@link EnvironmentPropertyUpdates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentPropertyUpdates(EnvironmentPropertyUpdates)
         */
        default Builder environmentPropertyUpdates(Consumer<EnvironmentPropertyUpdates.Builder> environmentPropertyUpdates) {
            return environmentPropertyUpdates(EnvironmentPropertyUpdates.builder().applyMutation(environmentPropertyUpdates)
                    .build());
        }

        /**
         * <p>
         * Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
         * </p>
         * 
         * @param applicationSnapshotConfigurationUpdate
         *        Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSnapshotConfigurationUpdate(
                ApplicationSnapshotConfigurationUpdate applicationSnapshotConfigurationUpdate);

        /**
         * <p>
         * Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationSnapshotConfigurationUpdate.Builder}
         * avoiding the need to create one manually via {@link ApplicationSnapshotConfigurationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationSnapshotConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #applicationSnapshotConfigurationUpdate(ApplicationSnapshotConfigurationUpdate)}.
         * 
         * @param applicationSnapshotConfigurationUpdate
         *        a consumer that will call methods on {@link ApplicationSnapshotConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSnapshotConfigurationUpdate(ApplicationSnapshotConfigurationUpdate)
         */
        default Builder applicationSnapshotConfigurationUpdate(
                Consumer<ApplicationSnapshotConfigurationUpdate.Builder> applicationSnapshotConfigurationUpdate) {
            return applicationSnapshotConfigurationUpdate(ApplicationSnapshotConfigurationUpdate.builder()
                    .applyMutation(applicationSnapshotConfigurationUpdate).build());
        }

        /**
         * <p>
         * Updates to the array of descriptions of VPC configurations available to the application.
         * </p>
         * 
         * @param vpcConfigurationUpdates
         *        Updates to the array of descriptions of VPC configurations available to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfigurationUpdates(Collection<VpcConfigurationUpdate> vpcConfigurationUpdates);

        /**
         * <p>
         * Updates to the array of descriptions of VPC configurations available to the application.
         * </p>
         * 
         * @param vpcConfigurationUpdates
         *        Updates to the array of descriptions of VPC configurations available to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfigurationUpdates(VpcConfigurationUpdate... vpcConfigurationUpdates);

        /**
         * <p>
         * Updates to the array of descriptions of VPC configurations available to the application.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VpcConfigurationUpdate>.Builder} avoiding
         * the need to create one manually via {@link List<VpcConfigurationUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpcConfigurationUpdate>.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcConfigurationUpdates(List<VpcConfigurationUpdate>)}.
         * 
         * @param vpcConfigurationUpdates
         *        a consumer that will call methods on {@link List<VpcConfigurationUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfigurationUpdates(List<VpcConfigurationUpdate>)
         */
        Builder vpcConfigurationUpdates(Consumer<VpcConfigurationUpdate.Builder>... vpcConfigurationUpdates);
    }

    static final class BuilderImpl implements Builder {
        private SqlApplicationConfigurationUpdate sqlApplicationConfigurationUpdate;

        private ApplicationCodeConfigurationUpdate applicationCodeConfigurationUpdate;

        private FlinkApplicationConfigurationUpdate flinkApplicationConfigurationUpdate;

        private EnvironmentPropertyUpdates environmentPropertyUpdates;

        private ApplicationSnapshotConfigurationUpdate applicationSnapshotConfigurationUpdate;

        private List<VpcConfigurationUpdate> vpcConfigurationUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationConfigurationUpdate model) {
            sqlApplicationConfigurationUpdate(model.sqlApplicationConfigurationUpdate);
            applicationCodeConfigurationUpdate(model.applicationCodeConfigurationUpdate);
            flinkApplicationConfigurationUpdate(model.flinkApplicationConfigurationUpdate);
            environmentPropertyUpdates(model.environmentPropertyUpdates);
            applicationSnapshotConfigurationUpdate(model.applicationSnapshotConfigurationUpdate);
            vpcConfigurationUpdates(model.vpcConfigurationUpdates);
        }

        public final SqlApplicationConfigurationUpdate.Builder getSqlApplicationConfigurationUpdate() {
            return sqlApplicationConfigurationUpdate != null ? sqlApplicationConfigurationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder sqlApplicationConfigurationUpdate(SqlApplicationConfigurationUpdate sqlApplicationConfigurationUpdate) {
            this.sqlApplicationConfigurationUpdate = sqlApplicationConfigurationUpdate;
            return this;
        }

        public final void setSqlApplicationConfigurationUpdate(
                SqlApplicationConfigurationUpdate.BuilderImpl sqlApplicationConfigurationUpdate) {
            this.sqlApplicationConfigurationUpdate = sqlApplicationConfigurationUpdate != null ? sqlApplicationConfigurationUpdate
                    .build() : null;
        }

        public final ApplicationCodeConfigurationUpdate.Builder getApplicationCodeConfigurationUpdate() {
            return applicationCodeConfigurationUpdate != null ? applicationCodeConfigurationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder applicationCodeConfigurationUpdate(
                ApplicationCodeConfigurationUpdate applicationCodeConfigurationUpdate) {
            this.applicationCodeConfigurationUpdate = applicationCodeConfigurationUpdate;
            return this;
        }

        public final void setApplicationCodeConfigurationUpdate(
                ApplicationCodeConfigurationUpdate.BuilderImpl applicationCodeConfigurationUpdate) {
            this.applicationCodeConfigurationUpdate = applicationCodeConfigurationUpdate != null ? applicationCodeConfigurationUpdate
                    .build() : null;
        }

        public final FlinkApplicationConfigurationUpdate.Builder getFlinkApplicationConfigurationUpdate() {
            return flinkApplicationConfigurationUpdate != null ? flinkApplicationConfigurationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder flinkApplicationConfigurationUpdate(
                FlinkApplicationConfigurationUpdate flinkApplicationConfigurationUpdate) {
            this.flinkApplicationConfigurationUpdate = flinkApplicationConfigurationUpdate;
            return this;
        }

        public final void setFlinkApplicationConfigurationUpdate(
                FlinkApplicationConfigurationUpdate.BuilderImpl flinkApplicationConfigurationUpdate) {
            this.flinkApplicationConfigurationUpdate = flinkApplicationConfigurationUpdate != null ? flinkApplicationConfigurationUpdate
                    .build() : null;
        }

        public final EnvironmentPropertyUpdates.Builder getEnvironmentPropertyUpdates() {
            return environmentPropertyUpdates != null ? environmentPropertyUpdates.toBuilder() : null;
        }

        @Override
        public final Builder environmentPropertyUpdates(EnvironmentPropertyUpdates environmentPropertyUpdates) {
            this.environmentPropertyUpdates = environmentPropertyUpdates;
            return this;
        }

        public final void setEnvironmentPropertyUpdates(EnvironmentPropertyUpdates.BuilderImpl environmentPropertyUpdates) {
            this.environmentPropertyUpdates = environmentPropertyUpdates != null ? environmentPropertyUpdates.build() : null;
        }

        public final ApplicationSnapshotConfigurationUpdate.Builder getApplicationSnapshotConfigurationUpdate() {
            return applicationSnapshotConfigurationUpdate != null ? applicationSnapshotConfigurationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder applicationSnapshotConfigurationUpdate(
                ApplicationSnapshotConfigurationUpdate applicationSnapshotConfigurationUpdate) {
            this.applicationSnapshotConfigurationUpdate = applicationSnapshotConfigurationUpdate;
            return this;
        }

        public final void setApplicationSnapshotConfigurationUpdate(
                ApplicationSnapshotConfigurationUpdate.BuilderImpl applicationSnapshotConfigurationUpdate) {
            this.applicationSnapshotConfigurationUpdate = applicationSnapshotConfigurationUpdate != null ? applicationSnapshotConfigurationUpdate
                    .build() : null;
        }

        public final Collection<VpcConfigurationUpdate.Builder> getVpcConfigurationUpdates() {
            if (vpcConfigurationUpdates instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcConfigurationUpdates != null ? vpcConfigurationUpdates.stream().map(VpcConfigurationUpdate::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcConfigurationUpdates(Collection<VpcConfigurationUpdate> vpcConfigurationUpdates) {
            this.vpcConfigurationUpdates = VpcConfigurationUpdatesCopier.copy(vpcConfigurationUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConfigurationUpdates(VpcConfigurationUpdate... vpcConfigurationUpdates) {
            vpcConfigurationUpdates(Arrays.asList(vpcConfigurationUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConfigurationUpdates(Consumer<VpcConfigurationUpdate.Builder>... vpcConfigurationUpdates) {
            vpcConfigurationUpdates(Stream.of(vpcConfigurationUpdates)
                    .map(c -> VpcConfigurationUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcConfigurationUpdates(Collection<VpcConfigurationUpdate.BuilderImpl> vpcConfigurationUpdates) {
            this.vpcConfigurationUpdates = VpcConfigurationUpdatesCopier.copyFromBuilder(vpcConfigurationUpdates);
        }

        @Override
        public ApplicationConfigurationUpdate build() {
            return new ApplicationConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
