/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddApplicationVpcConfigurationResponse extends KinesisAnalyticsV2Response implements
        ToCopyableBuilder<AddApplicationVpcConfigurationResponse.Builder, AddApplicationVpcConfigurationResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationARN").getter(getter(AddApplicationVpcConfigurationResponse::applicationARN))
            .setter(setter(Builder::applicationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()).build();

    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ApplicationVersionId").getter(getter(AddApplicationVpcConfigurationResponse::applicationVersionId))
            .setter(setter(Builder::applicationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build())
            .build();

    private static final SdkField<VpcConfigurationDescription> VPC_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<VpcConfigurationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfigurationDescription")
            .getter(getter(AddApplicationVpcConfigurationResponse::vpcConfigurationDescription))
            .setter(setter(Builder::vpcConfigurationDescription))
            .constructor(VpcConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfigurationDescription")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            APPLICATION_VERSION_ID_FIELD, VPC_CONFIGURATION_DESCRIPTION_FIELD));

    private final String applicationARN;

    private final Long applicationVersionId;

    private final VpcConfigurationDescription vpcConfigurationDescription;

    private AddApplicationVpcConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationARN = builder.applicationARN;
        this.applicationVersionId = builder.applicationVersionId;
        this.vpcConfigurationDescription = builder.vpcConfigurationDescription;
    }

    /**
     * <p>
     * The ARN of the application.
     * </p>
     * 
     * @return The ARN of the application.
     */
    public final String applicationARN() {
        return applicationARN;
    }

    /**
     * <p>
     * Provides the current application version. Kinesis Data Analytics updates the ApplicationVersionId each time you
     * update the application.
     * </p>
     * 
     * @return Provides the current application version. Kinesis Data Analytics updates the ApplicationVersionId each
     *         time you update the application.
     */
    public final Long applicationVersionId() {
        return applicationVersionId;
    }

    /**
     * <p>
     * The parameters of the new VPC configuration.
     * </p>
     * 
     * @return The parameters of the new VPC configuration.
     */
    public final VpcConfigurationDescription vpcConfigurationDescription() {
        return vpcConfigurationDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfigurationDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationVpcConfigurationResponse)) {
            return false;
        }
        AddApplicationVpcConfigurationResponse other = (AddApplicationVpcConfigurationResponse) obj;
        return Objects.equals(applicationARN(), other.applicationARN())
                && Objects.equals(applicationVersionId(), other.applicationVersionId())
                && Objects.equals(vpcConfigurationDescription(), other.vpcConfigurationDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddApplicationVpcConfigurationResponse").add("ApplicationARN", applicationARN())
                .add("ApplicationVersionId", applicationVersionId())
                .add("VpcConfigurationDescription", vpcConfigurationDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationARN":
            return Optional.ofNullable(clazz.cast(applicationARN()));
        case "ApplicationVersionId":
            return Optional.ofNullable(clazz.cast(applicationVersionId()));
        case "VpcConfigurationDescription":
            return Optional.ofNullable(clazz.cast(vpcConfigurationDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddApplicationVpcConfigurationResponse, T> g) {
        return obj -> g.apply((AddApplicationVpcConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, AddApplicationVpcConfigurationResponse> {
        /**
         * <p>
         * The ARN of the application.
         * </p>
         * 
         * @param applicationARN
         *        The ARN of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationARN(String applicationARN);

        /**
         * <p>
         * Provides the current application version. Kinesis Data Analytics updates the ApplicationVersionId each time
         * you update the application.
         * </p>
         * 
         * @param applicationVersionId
         *        Provides the current application version. Kinesis Data Analytics updates the ApplicationVersionId each
         *        time you update the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionId(Long applicationVersionId);

        /**
         * <p>
         * The parameters of the new VPC configuration.
         * </p>
         * 
         * @param vpcConfigurationDescription
         *        The parameters of the new VPC configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfigurationDescription(VpcConfigurationDescription vpcConfigurationDescription);

        /**
         * <p>
         * The parameters of the new VPC configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfigurationDescription.Builder} avoiding
         * the need to create one manually via {@link VpcConfigurationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfigurationDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcConfigurationDescription(VpcConfigurationDescription)}.
         * 
         * @param vpcConfigurationDescription
         *        a consumer that will call methods on {@link VpcConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfigurationDescription(VpcConfigurationDescription)
         */
        default Builder vpcConfigurationDescription(Consumer<VpcConfigurationDescription.Builder> vpcConfigurationDescription) {
            return vpcConfigurationDescription(VpcConfigurationDescription.builder().applyMutation(vpcConfigurationDescription)
                    .build());
        }
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Response.BuilderImpl implements Builder {
        private String applicationARN;

        private Long applicationVersionId;

        private VpcConfigurationDescription vpcConfigurationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationVpcConfigurationResponse model) {
            super(model);
            applicationARN(model.applicationARN);
            applicationVersionId(model.applicationVersionId);
            vpcConfigurationDescription(model.vpcConfigurationDescription);
        }

        public final String getApplicationARN() {
            return applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        public final Long getApplicationVersionId() {
            return applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        public final VpcConfigurationDescription.Builder getVpcConfigurationDescription() {
            return vpcConfigurationDescription != null ? vpcConfigurationDescription.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfigurationDescription(VpcConfigurationDescription vpcConfigurationDescription) {
            this.vpcConfigurationDescription = vpcConfigurationDescription;
            return this;
        }

        public final void setVpcConfigurationDescription(VpcConfigurationDescription.BuilderImpl vpcConfigurationDescription) {
            this.vpcConfigurationDescription = vpcConfigurationDescription != null ? vpcConfigurationDescription.build() : null;
        }

        @Override
        public AddApplicationVpcConfigurationResponse build() {
            return new AddApplicationVpcConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
