/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InputProcessingConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InputStartingPositionConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Request;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.S3Configuration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiscoverInputSchemaRequest
extends KinesisAnalyticsV2Request
implements ToCopyableBuilder<Builder, DiscoverInputSchemaRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiscoverInputSchemaRequest.getter(DiscoverInputSchemaRequest::resourceARN)).setter(DiscoverInputSchemaRequest.setter(Builder::resourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()}).build();
    private static final SdkField<String> SERVICE_EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiscoverInputSchemaRequest.getter(DiscoverInputSchemaRequest::serviceExecutionRole)).setter(DiscoverInputSchemaRequest.setter(Builder::serviceExecutionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceExecutionRole").build()}).build();
    private static final SdkField<InputStartingPositionConfiguration> INPUT_STARTING_POSITION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DiscoverInputSchemaRequest.getter(DiscoverInputSchemaRequest::inputStartingPositionConfiguration)).setter(DiscoverInputSchemaRequest.setter(Builder::inputStartingPositionConfiguration)).constructor(InputStartingPositionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputStartingPositionConfiguration").build()}).build();
    private static final SdkField<S3Configuration> S3_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DiscoverInputSchemaRequest.getter(DiscoverInputSchemaRequest::s3Configuration)).setter(DiscoverInputSchemaRequest.setter(Builder::s3Configuration)).constructor(S3Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Configuration").build()}).build();
    private static final SdkField<InputProcessingConfiguration> INPUT_PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DiscoverInputSchemaRequest.getter(DiscoverInputSchemaRequest::inputProcessingConfiguration)).setter(DiscoverInputSchemaRequest.setter(Builder::inputProcessingConfiguration)).constructor(InputProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputProcessingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, SERVICE_EXECUTION_ROLE_FIELD, INPUT_STARTING_POSITION_CONFIGURATION_FIELD, S3_CONFIGURATION_FIELD, INPUT_PROCESSING_CONFIGURATION_FIELD));
    private final String resourceARN;
    private final String serviceExecutionRole;
    private final InputStartingPositionConfiguration inputStartingPositionConfiguration;
    private final S3Configuration s3Configuration;
    private final InputProcessingConfiguration inputProcessingConfiguration;

    private DiscoverInputSchemaRequest(BuilderImpl builder) {
        super(builder);
        this.resourceARN = builder.resourceARN;
        this.serviceExecutionRole = builder.serviceExecutionRole;
        this.inputStartingPositionConfiguration = builder.inputStartingPositionConfiguration;
        this.s3Configuration = builder.s3Configuration;
        this.inputProcessingConfiguration = builder.inputProcessingConfiguration;
    }

    public String resourceARN() {
        return this.resourceARN;
    }

    public String serviceExecutionRole() {
        return this.serviceExecutionRole;
    }

    public InputStartingPositionConfiguration inputStartingPositionConfiguration() {
        return this.inputStartingPositionConfiguration;
    }

    public S3Configuration s3Configuration() {
        return this.s3Configuration;
    }

    public InputProcessingConfiguration inputProcessingConfiguration() {
        return this.inputProcessingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceExecutionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputStartingPositionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputProcessingConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInputSchemaRequest)) {
            return false;
        }
        DiscoverInputSchemaRequest other = (DiscoverInputSchemaRequest)((Object)obj);
        return Objects.equals(this.resourceARN(), other.resourceARN()) && Objects.equals(this.serviceExecutionRole(), other.serviceExecutionRole()) && Objects.equals(this.inputStartingPositionConfiguration(), other.inputStartingPositionConfiguration()) && Objects.equals(this.s3Configuration(), other.s3Configuration()) && Objects.equals(this.inputProcessingConfiguration(), other.inputProcessingConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"DiscoverInputSchemaRequest").add("ResourceARN", (Object)this.resourceARN()).add("ServiceExecutionRole", (Object)this.serviceExecutionRole()).add("InputStartingPositionConfiguration", (Object)this.inputStartingPositionConfiguration()).add("S3Configuration", (Object)this.s3Configuration()).add("InputProcessingConfiguration", (Object)this.inputProcessingConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceARN": {
                return Optional.ofNullable(clazz.cast(this.resourceARN()));
            }
            case "ServiceExecutionRole": {
                return Optional.ofNullable(clazz.cast(this.serviceExecutionRole()));
            }
            case "InputStartingPositionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inputStartingPositionConfiguration()));
            }
            case "S3Configuration": {
                return Optional.ofNullable(clazz.cast(this.s3Configuration()));
            }
            case "InputProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inputProcessingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiscoverInputSchemaRequest, T> g) {
        return obj -> g.apply((DiscoverInputSchemaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Request.BuilderImpl
    implements Builder {
        private String resourceARN;
        private String serviceExecutionRole;
        private InputStartingPositionConfiguration inputStartingPositionConfiguration;
        private S3Configuration s3Configuration;
        private InputProcessingConfiguration inputProcessingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverInputSchemaRequest model) {
            super(model);
            this.resourceARN(model.resourceARN);
            this.serviceExecutionRole(model.serviceExecutionRole);
            this.inputStartingPositionConfiguration(model.inputStartingPositionConfiguration);
            this.s3Configuration(model.s3Configuration);
            this.inputProcessingConfiguration(model.inputProcessingConfiguration);
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        public final String getServiceExecutionRole() {
            return this.serviceExecutionRole;
        }

        @Override
        public final Builder serviceExecutionRole(String serviceExecutionRole) {
            this.serviceExecutionRole = serviceExecutionRole;
            return this;
        }

        public final void setServiceExecutionRole(String serviceExecutionRole) {
            this.serviceExecutionRole = serviceExecutionRole;
        }

        public final InputStartingPositionConfiguration.Builder getInputStartingPositionConfiguration() {
            return this.inputStartingPositionConfiguration != null ? this.inputStartingPositionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration;
            return this;
        }

        public final void setInputStartingPositionConfiguration(InputStartingPositionConfiguration.BuilderImpl inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration != null ? inputStartingPositionConfiguration.build() : null;
        }

        public final S3Configuration.Builder getS3Configuration() {
            return this.s3Configuration != null ? this.s3Configuration.toBuilder() : null;
        }

        @Override
        public final Builder s3Configuration(S3Configuration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final void setS3Configuration(S3Configuration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        public final InputProcessingConfiguration.Builder getInputProcessingConfiguration() {
            return this.inputProcessingConfiguration != null ? this.inputProcessingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder inputProcessingConfiguration(InputProcessingConfiguration inputProcessingConfiguration) {
            this.inputProcessingConfiguration = inputProcessingConfiguration;
            return this;
        }

        public final void setInputProcessingConfiguration(InputProcessingConfiguration.BuilderImpl inputProcessingConfiguration) {
            this.inputProcessingConfiguration = inputProcessingConfiguration != null ? inputProcessingConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DiscoverInputSchemaRequest build() {
            return new DiscoverInputSchemaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DiscoverInputSchemaRequest> {
        public Builder resourceARN(String var1);

        public Builder serviceExecutionRole(String var1);

        public Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration var1);

        default public Builder inputStartingPositionConfiguration(Consumer<InputStartingPositionConfiguration.Builder> inputStartingPositionConfiguration) {
            return this.inputStartingPositionConfiguration((InputStartingPositionConfiguration)((InputStartingPositionConfiguration.Builder)InputStartingPositionConfiguration.builder().applyMutation(inputStartingPositionConfiguration)).build());
        }

        public Builder s3Configuration(S3Configuration var1);

        default public Builder s3Configuration(Consumer<S3Configuration.Builder> s3Configuration) {
            return this.s3Configuration((S3Configuration)((S3Configuration.Builder)S3Configuration.builder().applyMutation(s3Configuration)).build());
        }

        public Builder inputProcessingConfiguration(InputProcessingConfiguration var1);

        default public Builder inputProcessingConfiguration(Consumer<InputProcessingConfiguration.Builder> inputProcessingConfiguration) {
            return this.inputProcessingConfiguration((InputProcessingConfiguration)((InputProcessingConfiguration.Builder)InputProcessingConfiguration.builder().applyMutation(inputProcessingConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

