/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationUpdate;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.EnvironmentPropertyUpdates;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationConfigurationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationConfigurationUpdate> {
    private static final SdkField<SqlApplicationConfigurationUpdate> SQL_APPLICATION_CONFIGURATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ApplicationConfigurationUpdate.getter(ApplicationConfigurationUpdate::sqlApplicationConfigurationUpdate)).setter(ApplicationConfigurationUpdate.setter(Builder::sqlApplicationConfigurationUpdate)).constructor(SqlApplicationConfigurationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlApplicationConfigurationUpdate").build()}).build();
    private static final SdkField<ApplicationCodeConfigurationUpdate> APPLICATION_CODE_CONFIGURATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ApplicationConfigurationUpdate.getter(ApplicationConfigurationUpdate::applicationCodeConfigurationUpdate)).setter(ApplicationConfigurationUpdate.setter(Builder::applicationCodeConfigurationUpdate)).constructor(ApplicationCodeConfigurationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationCodeConfigurationUpdate").build()}).build();
    private static final SdkField<FlinkApplicationConfigurationUpdate> FLINK_APPLICATION_CONFIGURATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ApplicationConfigurationUpdate.getter(ApplicationConfigurationUpdate::flinkApplicationConfigurationUpdate)).setter(ApplicationConfigurationUpdate.setter(Builder::flinkApplicationConfigurationUpdate)).constructor(FlinkApplicationConfigurationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlinkApplicationConfigurationUpdate").build()}).build();
    private static final SdkField<EnvironmentPropertyUpdates> ENVIRONMENT_PROPERTY_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ApplicationConfigurationUpdate.getter(ApplicationConfigurationUpdate::environmentPropertyUpdates)).setter(ApplicationConfigurationUpdate.setter(Builder::environmentPropertyUpdates)).constructor(EnvironmentPropertyUpdates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentPropertyUpdates").build()}).build();
    private static final SdkField<ApplicationSnapshotConfigurationUpdate> APPLICATION_SNAPSHOT_CONFIGURATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ApplicationConfigurationUpdate.getter(ApplicationConfigurationUpdate::applicationSnapshotConfigurationUpdate)).setter(ApplicationConfigurationUpdate.setter(Builder::applicationSnapshotConfigurationUpdate)).constructor(ApplicationSnapshotConfigurationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSnapshotConfigurationUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SQL_APPLICATION_CONFIGURATION_UPDATE_FIELD, APPLICATION_CODE_CONFIGURATION_UPDATE_FIELD, FLINK_APPLICATION_CONFIGURATION_UPDATE_FIELD, ENVIRONMENT_PROPERTY_UPDATES_FIELD, APPLICATION_SNAPSHOT_CONFIGURATION_UPDATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final SqlApplicationConfigurationUpdate sqlApplicationConfigurationUpdate;
    private final ApplicationCodeConfigurationUpdate applicationCodeConfigurationUpdate;
    private final FlinkApplicationConfigurationUpdate flinkApplicationConfigurationUpdate;
    private final EnvironmentPropertyUpdates environmentPropertyUpdates;
    private final ApplicationSnapshotConfigurationUpdate applicationSnapshotConfigurationUpdate;

    private ApplicationConfigurationUpdate(BuilderImpl builder) {
        this.sqlApplicationConfigurationUpdate = builder.sqlApplicationConfigurationUpdate;
        this.applicationCodeConfigurationUpdate = builder.applicationCodeConfigurationUpdate;
        this.flinkApplicationConfigurationUpdate = builder.flinkApplicationConfigurationUpdate;
        this.environmentPropertyUpdates = builder.environmentPropertyUpdates;
        this.applicationSnapshotConfigurationUpdate = builder.applicationSnapshotConfigurationUpdate;
    }

    public SqlApplicationConfigurationUpdate sqlApplicationConfigurationUpdate() {
        return this.sqlApplicationConfigurationUpdate;
    }

    public ApplicationCodeConfigurationUpdate applicationCodeConfigurationUpdate() {
        return this.applicationCodeConfigurationUpdate;
    }

    public FlinkApplicationConfigurationUpdate flinkApplicationConfigurationUpdate() {
        return this.flinkApplicationConfigurationUpdate;
    }

    public EnvironmentPropertyUpdates environmentPropertyUpdates() {
        return this.environmentPropertyUpdates;
    }

    public ApplicationSnapshotConfigurationUpdate applicationSnapshotConfigurationUpdate() {
        return this.applicationSnapshotConfigurationUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlApplicationConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationCodeConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.flinkApplicationConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentPropertyUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSnapshotConfigurationUpdate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationConfigurationUpdate)) {
            return false;
        }
        ApplicationConfigurationUpdate other = (ApplicationConfigurationUpdate)obj;
        return Objects.equals(this.sqlApplicationConfigurationUpdate(), other.sqlApplicationConfigurationUpdate()) && Objects.equals(this.applicationCodeConfigurationUpdate(), other.applicationCodeConfigurationUpdate()) && Objects.equals(this.flinkApplicationConfigurationUpdate(), other.flinkApplicationConfigurationUpdate()) && Objects.equals(this.environmentPropertyUpdates(), other.environmentPropertyUpdates()) && Objects.equals(this.applicationSnapshotConfigurationUpdate(), other.applicationSnapshotConfigurationUpdate());
    }

    public String toString() {
        return ToString.builder((String)"ApplicationConfigurationUpdate").add("SqlApplicationConfigurationUpdate", (Object)this.sqlApplicationConfigurationUpdate()).add("ApplicationCodeConfigurationUpdate", (Object)this.applicationCodeConfigurationUpdate()).add("FlinkApplicationConfigurationUpdate", (Object)this.flinkApplicationConfigurationUpdate()).add("EnvironmentPropertyUpdates", (Object)this.environmentPropertyUpdates()).add("ApplicationSnapshotConfigurationUpdate", (Object)this.applicationSnapshotConfigurationUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SqlApplicationConfigurationUpdate": {
                return Optional.ofNullable(clazz.cast(this.sqlApplicationConfigurationUpdate()));
            }
            case "ApplicationCodeConfigurationUpdate": {
                return Optional.ofNullable(clazz.cast(this.applicationCodeConfigurationUpdate()));
            }
            case "FlinkApplicationConfigurationUpdate": {
                return Optional.ofNullable(clazz.cast(this.flinkApplicationConfigurationUpdate()));
            }
            case "EnvironmentPropertyUpdates": {
                return Optional.ofNullable(clazz.cast(this.environmentPropertyUpdates()));
            }
            case "ApplicationSnapshotConfigurationUpdate": {
                return Optional.ofNullable(clazz.cast(this.applicationSnapshotConfigurationUpdate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationConfigurationUpdate, T> g) {
        return obj -> g.apply((ApplicationConfigurationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SqlApplicationConfigurationUpdate sqlApplicationConfigurationUpdate;
        private ApplicationCodeConfigurationUpdate applicationCodeConfigurationUpdate;
        private FlinkApplicationConfigurationUpdate flinkApplicationConfigurationUpdate;
        private EnvironmentPropertyUpdates environmentPropertyUpdates;
        private ApplicationSnapshotConfigurationUpdate applicationSnapshotConfigurationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationConfigurationUpdate model) {
            this.sqlApplicationConfigurationUpdate(model.sqlApplicationConfigurationUpdate);
            this.applicationCodeConfigurationUpdate(model.applicationCodeConfigurationUpdate);
            this.flinkApplicationConfigurationUpdate(model.flinkApplicationConfigurationUpdate);
            this.environmentPropertyUpdates(model.environmentPropertyUpdates);
            this.applicationSnapshotConfigurationUpdate(model.applicationSnapshotConfigurationUpdate);
        }

        public final SqlApplicationConfigurationUpdate.Builder getSqlApplicationConfigurationUpdate() {
            return this.sqlApplicationConfigurationUpdate != null ? this.sqlApplicationConfigurationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder sqlApplicationConfigurationUpdate(SqlApplicationConfigurationUpdate sqlApplicationConfigurationUpdate) {
            this.sqlApplicationConfigurationUpdate = sqlApplicationConfigurationUpdate;
            return this;
        }

        public final void setSqlApplicationConfigurationUpdate(SqlApplicationConfigurationUpdate.BuilderImpl sqlApplicationConfigurationUpdate) {
            this.sqlApplicationConfigurationUpdate = sqlApplicationConfigurationUpdate != null ? sqlApplicationConfigurationUpdate.build() : null;
        }

        public final ApplicationCodeConfigurationUpdate.Builder getApplicationCodeConfigurationUpdate() {
            return this.applicationCodeConfigurationUpdate != null ? this.applicationCodeConfigurationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder applicationCodeConfigurationUpdate(ApplicationCodeConfigurationUpdate applicationCodeConfigurationUpdate) {
            this.applicationCodeConfigurationUpdate = applicationCodeConfigurationUpdate;
            return this;
        }

        public final void setApplicationCodeConfigurationUpdate(ApplicationCodeConfigurationUpdate.BuilderImpl applicationCodeConfigurationUpdate) {
            this.applicationCodeConfigurationUpdate = applicationCodeConfigurationUpdate != null ? applicationCodeConfigurationUpdate.build() : null;
        }

        public final FlinkApplicationConfigurationUpdate.Builder getFlinkApplicationConfigurationUpdate() {
            return this.flinkApplicationConfigurationUpdate != null ? this.flinkApplicationConfigurationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder flinkApplicationConfigurationUpdate(FlinkApplicationConfigurationUpdate flinkApplicationConfigurationUpdate) {
            this.flinkApplicationConfigurationUpdate = flinkApplicationConfigurationUpdate;
            return this;
        }

        public final void setFlinkApplicationConfigurationUpdate(FlinkApplicationConfigurationUpdate.BuilderImpl flinkApplicationConfigurationUpdate) {
            this.flinkApplicationConfigurationUpdate = flinkApplicationConfigurationUpdate != null ? flinkApplicationConfigurationUpdate.build() : null;
        }

        public final EnvironmentPropertyUpdates.Builder getEnvironmentPropertyUpdates() {
            return this.environmentPropertyUpdates != null ? this.environmentPropertyUpdates.toBuilder() : null;
        }

        @Override
        public final Builder environmentPropertyUpdates(EnvironmentPropertyUpdates environmentPropertyUpdates) {
            this.environmentPropertyUpdates = environmentPropertyUpdates;
            return this;
        }

        public final void setEnvironmentPropertyUpdates(EnvironmentPropertyUpdates.BuilderImpl environmentPropertyUpdates) {
            this.environmentPropertyUpdates = environmentPropertyUpdates != null ? environmentPropertyUpdates.build() : null;
        }

        public final ApplicationSnapshotConfigurationUpdate.Builder getApplicationSnapshotConfigurationUpdate() {
            return this.applicationSnapshotConfigurationUpdate != null ? this.applicationSnapshotConfigurationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder applicationSnapshotConfigurationUpdate(ApplicationSnapshotConfigurationUpdate applicationSnapshotConfigurationUpdate) {
            this.applicationSnapshotConfigurationUpdate = applicationSnapshotConfigurationUpdate;
            return this;
        }

        public final void setApplicationSnapshotConfigurationUpdate(ApplicationSnapshotConfigurationUpdate.BuilderImpl applicationSnapshotConfigurationUpdate) {
            this.applicationSnapshotConfigurationUpdate = applicationSnapshotConfigurationUpdate != null ? applicationSnapshotConfigurationUpdate.build() : null;
        }

        public ApplicationConfigurationUpdate build() {
            return new ApplicationConfigurationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationConfigurationUpdate> {
        public Builder sqlApplicationConfigurationUpdate(SqlApplicationConfigurationUpdate var1);

        default public Builder sqlApplicationConfigurationUpdate(Consumer<SqlApplicationConfigurationUpdate.Builder> sqlApplicationConfigurationUpdate) {
            return this.sqlApplicationConfigurationUpdate((SqlApplicationConfigurationUpdate)((SqlApplicationConfigurationUpdate.Builder)SqlApplicationConfigurationUpdate.builder().applyMutation(sqlApplicationConfigurationUpdate)).build());
        }

        public Builder applicationCodeConfigurationUpdate(ApplicationCodeConfigurationUpdate var1);

        default public Builder applicationCodeConfigurationUpdate(Consumer<ApplicationCodeConfigurationUpdate.Builder> applicationCodeConfigurationUpdate) {
            return this.applicationCodeConfigurationUpdate((ApplicationCodeConfigurationUpdate)((ApplicationCodeConfigurationUpdate.Builder)ApplicationCodeConfigurationUpdate.builder().applyMutation(applicationCodeConfigurationUpdate)).build());
        }

        public Builder flinkApplicationConfigurationUpdate(FlinkApplicationConfigurationUpdate var1);

        default public Builder flinkApplicationConfigurationUpdate(Consumer<FlinkApplicationConfigurationUpdate.Builder> flinkApplicationConfigurationUpdate) {
            return this.flinkApplicationConfigurationUpdate((FlinkApplicationConfigurationUpdate)((FlinkApplicationConfigurationUpdate.Builder)FlinkApplicationConfigurationUpdate.builder().applyMutation(flinkApplicationConfigurationUpdate)).build());
        }

        public Builder environmentPropertyUpdates(EnvironmentPropertyUpdates var1);

        default public Builder environmentPropertyUpdates(Consumer<EnvironmentPropertyUpdates.Builder> environmentPropertyUpdates) {
            return this.environmentPropertyUpdates((EnvironmentPropertyUpdates)((EnvironmentPropertyUpdates.Builder)EnvironmentPropertyUpdates.builder().applyMutation(environmentPropertyUpdates)).build());
        }

        public Builder applicationSnapshotConfigurationUpdate(ApplicationSnapshotConfigurationUpdate var1);

        default public Builder applicationSnapshotConfigurationUpdate(Consumer<ApplicationSnapshotConfigurationUpdate.Builder> applicationSnapshotConfigurationUpdate) {
            return this.applicationSnapshotConfigurationUpdate((ApplicationSnapshotConfigurationUpdate)((ApplicationSnapshotConfigurationUpdate.Builder)ApplicationSnapshotConfigurationUpdate.builder().applyMutation(applicationSnapshotConfigurationUpdate)).build());
        }
    }
}

