/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisAnalyticsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteApplicationReferenceDataSourceRequest
extends KinesisAnalyticsRequest
implements ToCopyableBuilder<Builder, DeleteApplicationReferenceDataSourceRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteApplicationReferenceDataSourceRequest.getter(DeleteApplicationReferenceDataSourceRequest::applicationName)).setter(DeleteApplicationReferenceDataSourceRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<Long> CURRENT_APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DeleteApplicationReferenceDataSourceRequest.getter(DeleteApplicationReferenceDataSourceRequest::currentApplicationVersionId)).setter(DeleteApplicationReferenceDataSourceRequest.setter(Builder::currentApplicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentApplicationVersionId").build()}).build();
    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteApplicationReferenceDataSourceRequest.getter(DeleteApplicationReferenceDataSourceRequest::referenceId)).setter(DeleteApplicationReferenceDataSourceRequest.setter(Builder::referenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, CURRENT_APPLICATION_VERSION_ID_FIELD, REFERENCE_ID_FIELD));
    private final String applicationName;
    private final Long currentApplicationVersionId;
    private final String referenceId;

    private DeleteApplicationReferenceDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.referenceId = builder.referenceId;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public Long currentApplicationVersionId() {
        return this.currentApplicationVersionId;
    }

    public String referenceId() {
        return this.referenceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationReferenceDataSourceRequest)) {
            return false;
        }
        DeleteApplicationReferenceDataSourceRequest other = (DeleteApplicationReferenceDataSourceRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.currentApplicationVersionId(), other.currentApplicationVersionId()) && Objects.equals(this.referenceId(), other.referenceId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteApplicationReferenceDataSourceRequest").add("ApplicationName", (Object)this.applicationName()).add("CurrentApplicationVersionId", (Object)this.currentApplicationVersionId()).add("ReferenceId", (Object)this.referenceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "CurrentApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.currentApplicationVersionId()));
            }
            case "ReferenceId": {
                return Optional.ofNullable(clazz.cast(this.referenceId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteApplicationReferenceDataSourceRequest, T> g) {
        return obj -> g.apply((DeleteApplicationReferenceDataSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private Long currentApplicationVersionId;
        private String referenceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationReferenceDataSourceRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.currentApplicationVersionId(model.currentApplicationVersionId);
            this.referenceId(model.referenceId);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return this.currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final String getReferenceId() {
            return this.referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteApplicationReferenceDataSourceRequest build() {
            return new DeleteApplicationReferenceDataSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteApplicationReferenceDataSourceRequest> {
        public Builder applicationName(String var1);

        public Builder currentApplicationVersionId(Long var1);

        public Builder referenceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

