/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalytics.model.ApplicationSummary;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisAnalyticsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationResponse
extends KinesisAnalyticsResponse
implements ToCopyableBuilder<Builder, CreateApplicationResponse> {
    private static final SdkField<ApplicationSummary> APPLICATION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationSummary").getter(CreateApplicationResponse.getter(CreateApplicationResponse::applicationSummary)).setter(CreateApplicationResponse.setter(Builder::applicationSummary)).constructor(ApplicationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_SUMMARY_FIELD));
    private final ApplicationSummary applicationSummary;

    private CreateApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationSummary = builder.applicationSummary;
    }

    public final ApplicationSummary applicationSummary() {
        return this.applicationSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationResponse)) {
            return false;
        }
        CreateApplicationResponse other = (CreateApplicationResponse)((Object)obj);
        return Objects.equals(this.applicationSummary(), other.applicationSummary());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApplicationResponse").add("ApplicationSummary", (Object)this.applicationSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationSummary": {
                return Optional.ofNullable(clazz.cast(this.applicationSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationResponse, T> g) {
        return obj -> g.apply((CreateApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsResponse.BuilderImpl
    implements Builder {
        private ApplicationSummary applicationSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationResponse model) {
            super(model);
            this.applicationSummary(model.applicationSummary);
        }

        public final ApplicationSummary.Builder getApplicationSummary() {
            return this.applicationSummary != null ? this.applicationSummary.toBuilder() : null;
        }

        public final void setApplicationSummary(ApplicationSummary.BuilderImpl applicationSummary) {
            this.applicationSummary = applicationSummary != null ? applicationSummary.build() : null;
        }

        @Override
        public final Builder applicationSummary(ApplicationSummary applicationSummary) {
            this.applicationSummary = applicationSummary;
            return this;
        }

        @Override
        public CreateApplicationResponse build() {
            return new CreateApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationResponse> {
        public Builder applicationSummary(ApplicationSummary var1);

        default public Builder applicationSummary(Consumer<ApplicationSummary.Builder> applicationSummary) {
            return this.applicationSummary((ApplicationSummary)((ApplicationSummary.Builder)ApplicationSummary.builder().applyMutation(applicationSummary)).build());
        }
    }
}

