/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output for <code>PutRecords</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRecordsRequestEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<PutRecordsRequestEntry.Builder, PutRecordsRequestEntry> {
    private static final SdkField<SdkBytes> DATA_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Data").getter(getter(PutRecordsRequestEntry::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()).build();

    private static final SdkField<String> EXPLICIT_HASH_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExplicitHashKey").getter(getter(PutRecordsRequestEntry::explicitHashKey))
            .setter(setter(Builder::explicitHashKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplicitHashKey").build()).build();

    private static final SdkField<String> PARTITION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartitionKey").getter(getter(PutRecordsRequestEntry::partitionKey))
            .setter(setter(Builder::partitionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD,
            EXPLICIT_HASH_KEY_FIELD, PARTITION_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SdkBytes data;

    private final String explicitHashKey;

    private final String partitionKey;

    private PutRecordsRequestEntry(BuilderImpl builder) {
        this.data = builder.data;
        this.explicitHashKey = builder.explicitHashKey;
        this.partitionKey = builder.partitionKey;
    }

    /**
     * <p>
     * The data blob to put into the record, which is base64-encoded when the blob is serialized. When the data blob
     * (the payload before base64-encoding) is added to the partition key size, the total size must not exceed the
     * maximum record size (1 MiB).
     * </p>
     * 
     * @return The data blob to put into the record, which is base64-encoded when the blob is serialized. When the data
     *         blob (the payload before base64-encoding) is added to the partition key size, the total size must not
     *         exceed the maximum record size (1 MiB).
     */
    public final SdkBytes data() {
        return data;
    }

    /**
     * <p>
     * The hash value used to determine explicitly the shard that the data record is assigned to by overriding the
     * partition key hash.
     * </p>
     * 
     * @return The hash value used to determine explicitly the shard that the data record is assigned to by overriding
     *         the partition key hash.
     */
    public final String explicitHashKey() {
        return explicitHashKey;
    }

    /**
     * <p>
     * Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with a
     * maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input
     * to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash
     * function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As
     * a result of this hashing mechanism, all data records with the same partition key map to the same shard within the
     * stream.
     * </p>
     * 
     * @return Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings
     *         with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the
     *         partition key as input to a hash function that maps the partition key and associated data to a specific
     *         shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to
     *         map associated data records to shards. As a result of this hashing mechanism, all data records with the
     *         same partition key map to the same shard within the stream.
     */
    public final String partitionKey() {
        return partitionKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(explicitHashKey());
        hashCode = 31 * hashCode + Objects.hashCode(partitionKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordsRequestEntry)) {
            return false;
        }
        PutRecordsRequestEntry other = (PutRecordsRequestEntry) obj;
        return Objects.equals(data(), other.data()) && Objects.equals(explicitHashKey(), other.explicitHashKey())
                && Objects.equals(partitionKey(), other.partitionKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRecordsRequestEntry").add("Data", data()).add("ExplicitHashKey", explicitHashKey())
                .add("PartitionKey", partitionKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        case "ExplicitHashKey":
            return Optional.ofNullable(clazz.cast(explicitHashKey()));
        case "PartitionKey":
            return Optional.ofNullable(clazz.cast(partitionKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Data", DATA_FIELD);
        map.put("ExplicitHashKey", EXPLICIT_HASH_KEY_FIELD);
        map.put("PartitionKey", PARTITION_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRecordsRequestEntry, T> g) {
        return obj -> g.apply((PutRecordsRequestEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PutRecordsRequestEntry> {
        /**
         * <p>
         * The data blob to put into the record, which is base64-encoded when the blob is serialized. When the data blob
         * (the payload before base64-encoding) is added to the partition key size, the total size must not exceed the
         * maximum record size (1 MiB).
         * </p>
         * 
         * @param data
         *        The data blob to put into the record, which is base64-encoded when the blob is serialized. When the
         *        data blob (the payload before base64-encoding) is added to the partition key size, the total size must
         *        not exceed the maximum record size (1 MiB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(SdkBytes data);

        /**
         * <p>
         * The hash value used to determine explicitly the shard that the data record is assigned to by overriding the
         * partition key hash.
         * </p>
         * 
         * @param explicitHashKey
         *        The hash value used to determine explicitly the shard that the data record is assigned to by
         *        overriding the partition key hash.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explicitHashKey(String explicitHashKey);

        /**
         * <p>
         * Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with
         * a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as
         * input to a hash function that maps the partition key and associated data to a specific shard. Specifically,
         * an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data
         * records to shards. As a result of this hashing mechanism, all data records with the same partition key map to
         * the same shard within the stream.
         * </p>
         * 
         * @param partitionKey
         *        Determines which shard in the stream the data record is assigned to. Partition keys are Unicode
         *        strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses
         *        the partition key as input to a hash function that maps the partition key and associated data to a
         *        specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer
         *        values and to map associated data records to shards. As a result of this hashing mechanism, all data
         *        records with the same partition key map to the same shard within the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKey(String partitionKey);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes data;

        private String explicitHashKey;

        private String partitionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordsRequestEntry model) {
            data(model.data);
            explicitHashKey(model.explicitHashKey);
            partitionKey(model.partitionKey);
        }

        public final ByteBuffer getData() {
            return data == null ? null : data.asByteBuffer();
        }

        public final void setData(ByteBuffer data) {
            data(data == null ? null : SdkBytes.fromByteBuffer(data));
        }

        @Override
        public final Builder data(SdkBytes data) {
            this.data = data;
            return this;
        }

        public final String getExplicitHashKey() {
            return explicitHashKey;
        }

        public final void setExplicitHashKey(String explicitHashKey) {
            this.explicitHashKey = explicitHashKey;
        }

        @Override
        public final Builder explicitHashKey(String explicitHashKey) {
            this.explicitHashKey = explicitHashKey;
            return this;
        }

        public final String getPartitionKey() {
            return partitionKey;
        }

        public final void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        @Override
        public final Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        @Override
        public PutRecordsRequestEntry build() {
            return new PutRecordsRequestEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
