/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output for <a>EnableEnhancedMonitoring</a> and <a>DisableEnhancedMonitoring</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableEnhancedMonitoringResponse extends KinesisResponse implements
        ToCopyableBuilder<EnableEnhancedMonitoringResponse.Builder, EnableEnhancedMonitoringResponse> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EnableEnhancedMonitoringResponse::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<List<String>> CURRENT_SHARD_LEVEL_METRICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EnableEnhancedMonitoringResponse::currentShardLevelMetricsAsStrings))
            .setter(setter(Builder::currentShardLevelMetricsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentShardLevelMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DESIRED_SHARD_LEVEL_METRICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EnableEnhancedMonitoringResponse::desiredShardLevelMetricsAsStrings))
            .setter(setter(Builder::desiredShardLevelMetricsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredShardLevelMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            CURRENT_SHARD_LEVEL_METRICS_FIELD, DESIRED_SHARD_LEVEL_METRICS_FIELD));

    private final String streamName;

    private final List<String> currentShardLevelMetrics;

    private final List<String> desiredShardLevelMetrics;

    private EnableEnhancedMonitoringResponse(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.currentShardLevelMetrics = builder.currentShardLevelMetrics;
        this.desiredShardLevelMetrics = builder.desiredShardLevelMetrics;
    }

    /**
     * <p>
     * The name of the Kinesis data stream.
     * </p>
     * 
     * @return The name of the Kinesis data stream.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * Represents the current state of the metrics that are in the enhanced state before the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the current state of the metrics that are in the enhanced state before the operation.
     */
    public List<MetricsName> currentShardLevelMetrics() {
        return TypeConverter.convert(currentShardLevelMetrics, MetricsName::fromValue);
    }

    /**
     * <p>
     * Represents the current state of the metrics that are in the enhanced state before the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the current state of the metrics that are in the enhanced state before the operation.
     */
    public List<String> currentShardLevelMetricsAsStrings() {
        return currentShardLevelMetrics;
    }

    /**
     * <p>
     * Represents the list of all the metrics that would be in the enhanced state after the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the list of all the metrics that would be in the enhanced state after the operation.
     */
    public List<MetricsName> desiredShardLevelMetrics() {
        return TypeConverter.convert(desiredShardLevelMetrics, MetricsName::fromValue);
    }

    /**
     * <p>
     * Represents the list of all the metrics that would be in the enhanced state after the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the list of all the metrics that would be in the enhanced state after the operation.
     */
    public List<String> desiredShardLevelMetricsAsStrings() {
        return desiredShardLevelMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(currentShardLevelMetricsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(desiredShardLevelMetricsAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableEnhancedMonitoringResponse)) {
            return false;
        }
        EnableEnhancedMonitoringResponse other = (EnableEnhancedMonitoringResponse) obj;
        return Objects.equals(streamName(), other.streamName())
                && Objects.equals(currentShardLevelMetricsAsStrings(), other.currentShardLevelMetricsAsStrings())
                && Objects.equals(desiredShardLevelMetricsAsStrings(), other.desiredShardLevelMetricsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EnableEnhancedMonitoringResponse").add("StreamName", streamName())
                .add("CurrentShardLevelMetrics", currentShardLevelMetricsAsStrings())
                .add("DesiredShardLevelMetrics", desiredShardLevelMetricsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "CurrentShardLevelMetrics":
            return Optional.ofNullable(clazz.cast(currentShardLevelMetricsAsStrings()));
        case "DesiredShardLevelMetrics":
            return Optional.ofNullable(clazz.cast(desiredShardLevelMetricsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableEnhancedMonitoringResponse, T> g) {
        return obj -> g.apply((EnableEnhancedMonitoringResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisResponse.Builder, SdkPojo, CopyableBuilder<Builder, EnableEnhancedMonitoringResponse> {
        /**
         * <p>
         * The name of the Kinesis data stream.
         * </p>
         * 
         * @param streamName
         *        The name of the Kinesis data stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * Represents the current state of the metrics that are in the enhanced state before the operation.
         * </p>
         * 
         * @param currentShardLevelMetrics
         *        Represents the current state of the metrics that are in the enhanced state before the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentShardLevelMetricsWithStrings(Collection<String> currentShardLevelMetrics);

        /**
         * <p>
         * Represents the current state of the metrics that are in the enhanced state before the operation.
         * </p>
         * 
         * @param currentShardLevelMetrics
         *        Represents the current state of the metrics that are in the enhanced state before the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentShardLevelMetricsWithStrings(String... currentShardLevelMetrics);

        /**
         * <p>
         * Represents the current state of the metrics that are in the enhanced state before the operation.
         * </p>
         * 
         * @param currentShardLevelMetrics
         *        Represents the current state of the metrics that are in the enhanced state before the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentShardLevelMetrics(Collection<MetricsName> currentShardLevelMetrics);

        /**
         * <p>
         * Represents the current state of the metrics that are in the enhanced state before the operation.
         * </p>
         * 
         * @param currentShardLevelMetrics
         *        Represents the current state of the metrics that are in the enhanced state before the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentShardLevelMetrics(MetricsName... currentShardLevelMetrics);

        /**
         * <p>
         * Represents the list of all the metrics that would be in the enhanced state after the operation.
         * </p>
         * 
         * @param desiredShardLevelMetrics
         *        Represents the list of all the metrics that would be in the enhanced state after the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredShardLevelMetricsWithStrings(Collection<String> desiredShardLevelMetrics);

        /**
         * <p>
         * Represents the list of all the metrics that would be in the enhanced state after the operation.
         * </p>
         * 
         * @param desiredShardLevelMetrics
         *        Represents the list of all the metrics that would be in the enhanced state after the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredShardLevelMetricsWithStrings(String... desiredShardLevelMetrics);

        /**
         * <p>
         * Represents the list of all the metrics that would be in the enhanced state after the operation.
         * </p>
         * 
         * @param desiredShardLevelMetrics
         *        Represents the list of all the metrics that would be in the enhanced state after the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredShardLevelMetrics(Collection<MetricsName> desiredShardLevelMetrics);

        /**
         * <p>
         * Represents the list of all the metrics that would be in the enhanced state after the operation.
         * </p>
         * 
         * @param desiredShardLevelMetrics
         *        Represents the list of all the metrics that would be in the enhanced state after the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredShardLevelMetrics(MetricsName... desiredShardLevelMetrics);
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private String streamName;

        private List<String> currentShardLevelMetrics = DefaultSdkAutoConstructList.getInstance();

        private List<String> desiredShardLevelMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnableEnhancedMonitoringResponse model) {
            super(model);
            streamName(model.streamName);
            currentShardLevelMetricsWithStrings(model.currentShardLevelMetrics);
            desiredShardLevelMetricsWithStrings(model.desiredShardLevelMetrics);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Collection<String> getCurrentShardLevelMetricsAsStrings() {
            return currentShardLevelMetrics;
        }

        @Override
        public final Builder currentShardLevelMetricsWithStrings(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentShardLevelMetricsWithStrings(String... currentShardLevelMetrics) {
            currentShardLevelMetricsWithStrings(Arrays.asList(currentShardLevelMetrics));
            return this;
        }

        @Override
        public final Builder currentShardLevelMetrics(Collection<MetricsName> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copyEnumToString(currentShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentShardLevelMetrics(MetricsName... currentShardLevelMetrics) {
            currentShardLevelMetrics(Arrays.asList(currentShardLevelMetrics));
            return this;
        }

        public final void setCurrentShardLevelMetricsWithStrings(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
        }

        public final Collection<String> getDesiredShardLevelMetricsAsStrings() {
            return desiredShardLevelMetrics;
        }

        @Override
        public final Builder desiredShardLevelMetricsWithStrings(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredShardLevelMetricsWithStrings(String... desiredShardLevelMetrics) {
            desiredShardLevelMetricsWithStrings(Arrays.asList(desiredShardLevelMetrics));
            return this;
        }

        @Override
        public final Builder desiredShardLevelMetrics(Collection<MetricsName> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copyEnumToString(desiredShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredShardLevelMetrics(MetricsName... desiredShardLevelMetrics) {
            desiredShardLevelMetrics(Arrays.asList(desiredShardLevelMetrics));
            return this;
        }

        public final void setDesiredShardLevelMetricsWithStrings(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
        }

        @Override
        public EnableEnhancedMonitoringResponse build() {
            return new EnableEnhancedMonitoringResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
