/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.awssdk.services.kinesis.model.MetricsName;
import software.amazon.awssdk.services.kinesis.model.MetricsNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableEnhancedMonitoringResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, EnableEnhancedMonitoringResponse> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EnableEnhancedMonitoringResponse.getter(EnableEnhancedMonitoringResponse::streamName)).setter(EnableEnhancedMonitoringResponse.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<List<String>> CURRENT_SHARD_LEVEL_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EnableEnhancedMonitoringResponse.getter(EnableEnhancedMonitoringResponse::currentShardLevelMetricsAsStrings)).setter(EnableEnhancedMonitoringResponse.setter(Builder::currentShardLevelMetricsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentShardLevelMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DESIRED_SHARD_LEVEL_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EnableEnhancedMonitoringResponse.getter(EnableEnhancedMonitoringResponse::desiredShardLevelMetricsAsStrings)).setter(EnableEnhancedMonitoringResponse.setter(Builder::desiredShardLevelMetricsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredShardLevelMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, CURRENT_SHARD_LEVEL_METRICS_FIELD, DESIRED_SHARD_LEVEL_METRICS_FIELD));
    private final String streamName;
    private final List<String> currentShardLevelMetrics;
    private final List<String> desiredShardLevelMetrics;

    private EnableEnhancedMonitoringResponse(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.currentShardLevelMetrics = builder.currentShardLevelMetrics;
        this.desiredShardLevelMetrics = builder.desiredShardLevelMetrics;
    }

    public String streamName() {
        return this.streamName;
    }

    public List<MetricsName> currentShardLevelMetrics() {
        return TypeConverter.convert(this.currentShardLevelMetrics, MetricsName::fromValue);
    }

    public List<String> currentShardLevelMetricsAsStrings() {
        return this.currentShardLevelMetrics;
    }

    public List<MetricsName> desiredShardLevelMetrics() {
        return TypeConverter.convert(this.desiredShardLevelMetrics, MetricsName::fromValue);
    }

    public List<String> desiredShardLevelMetricsAsStrings() {
        return this.desiredShardLevelMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentShardLevelMetricsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredShardLevelMetricsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableEnhancedMonitoringResponse)) {
            return false;
        }
        EnableEnhancedMonitoringResponse other = (EnableEnhancedMonitoringResponse)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.currentShardLevelMetricsAsStrings(), other.currentShardLevelMetricsAsStrings()) && Objects.equals(this.desiredShardLevelMetricsAsStrings(), other.desiredShardLevelMetricsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"EnableEnhancedMonitoringResponse").add("StreamName", (Object)this.streamName()).add("CurrentShardLevelMetrics", this.currentShardLevelMetricsAsStrings()).add("DesiredShardLevelMetrics", this.desiredShardLevelMetricsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "CurrentShardLevelMetrics": {
                return Optional.ofNullable(clazz.cast(this.currentShardLevelMetricsAsStrings()));
            }
            case "DesiredShardLevelMetrics": {
                return Optional.ofNullable(clazz.cast(this.desiredShardLevelMetricsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableEnhancedMonitoringResponse, T> g) {
        return obj -> g.apply((EnableEnhancedMonitoringResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private String streamName;
        private List<String> currentShardLevelMetrics = DefaultSdkAutoConstructList.getInstance();
        private List<String> desiredShardLevelMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnableEnhancedMonitoringResponse model) {
            super(model);
            this.streamName(model.streamName);
            this.currentShardLevelMetricsWithStrings(model.currentShardLevelMetrics);
            this.desiredShardLevelMetricsWithStrings(model.desiredShardLevelMetrics);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Collection<String> getCurrentShardLevelMetricsAsStrings() {
            return this.currentShardLevelMetrics;
        }

        @Override
        public final Builder currentShardLevelMetricsWithStrings(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentShardLevelMetricsWithStrings(String ... currentShardLevelMetrics) {
            this.currentShardLevelMetricsWithStrings(Arrays.asList(currentShardLevelMetrics));
            return this;
        }

        @Override
        public final Builder currentShardLevelMetrics(Collection<MetricsName> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copyEnumToString(currentShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentShardLevelMetrics(MetricsName ... currentShardLevelMetrics) {
            this.currentShardLevelMetrics(Arrays.asList(currentShardLevelMetrics));
            return this;
        }

        public final void setCurrentShardLevelMetricsWithStrings(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
        }

        public final Collection<String> getDesiredShardLevelMetricsAsStrings() {
            return this.desiredShardLevelMetrics;
        }

        @Override
        public final Builder desiredShardLevelMetricsWithStrings(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredShardLevelMetricsWithStrings(String ... desiredShardLevelMetrics) {
            this.desiredShardLevelMetricsWithStrings(Arrays.asList(desiredShardLevelMetrics));
            return this;
        }

        @Override
        public final Builder desiredShardLevelMetrics(Collection<MetricsName> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copyEnumToString(desiredShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredShardLevelMetrics(MetricsName ... desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics(Arrays.asList(desiredShardLevelMetrics));
            return this;
        }

        public final void setDesiredShardLevelMetricsWithStrings(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
        }

        @Override
        public EnableEnhancedMonitoringResponse build() {
            return new EnableEnhancedMonitoringResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableEnhancedMonitoringResponse> {
        public Builder streamName(String var1);

        public Builder currentShardLevelMetricsWithStrings(Collection<String> var1);

        public Builder currentShardLevelMetricsWithStrings(String ... var1);

        public Builder currentShardLevelMetrics(Collection<MetricsName> var1);

        public Builder currentShardLevelMetrics(MetricsName ... var1);

        public Builder desiredShardLevelMetricsWithStrings(Collection<String> var1);

        public Builder desiredShardLevelMetricsWithStrings(String ... var1);

        public Builder desiredShardLevelMetrics(Collection<MetricsName> var1);

        public Builder desiredShardLevelMetrics(MetricsName ... var1);
    }
}

