/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HashKeyRange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HashKeyRange> {
    private static final SdkField<String> STARTING_HASH_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartingHashKey").getter(HashKeyRange.getter(HashKeyRange::startingHashKey)).setter(HashKeyRange.setter(Builder::startingHashKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingHashKey").build()}).build();
    private static final SdkField<String> ENDING_HASH_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndingHashKey").getter(HashKeyRange.getter(HashKeyRange::endingHashKey)).setter(HashKeyRange.setter(Builder::endingHashKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndingHashKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STARTING_HASH_KEY_FIELD, ENDING_HASH_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StartingHashKey", STARTING_HASH_KEY_FIELD);
            this.put("EndingHashKey", ENDING_HASH_KEY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String startingHashKey;
    private final String endingHashKey;

    private HashKeyRange(BuilderImpl builder) {
        this.startingHashKey = builder.startingHashKey;
        this.endingHashKey = builder.endingHashKey;
    }

    public final String startingHashKey() {
        return this.startingHashKey;
    }

    public final String endingHashKey() {
        return this.endingHashKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startingHashKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.endingHashKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HashKeyRange)) {
            return false;
        }
        HashKeyRange other = (HashKeyRange)obj;
        return Objects.equals(this.startingHashKey(), other.startingHashKey()) && Objects.equals(this.endingHashKey(), other.endingHashKey());
    }

    public final String toString() {
        return ToString.builder((String)"HashKeyRange").add("StartingHashKey", (Object)this.startingHashKey()).add("EndingHashKey", (Object)this.endingHashKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartingHashKey": {
                return Optional.ofNullable(clazz.cast(this.startingHashKey()));
            }
            case "EndingHashKey": {
                return Optional.ofNullable(clazz.cast(this.endingHashKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HashKeyRange, T> g) {
        return obj -> g.apply((HashKeyRange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String startingHashKey;
        private String endingHashKey;

        private BuilderImpl() {
        }

        private BuilderImpl(HashKeyRange model) {
            this.startingHashKey(model.startingHashKey);
            this.endingHashKey(model.endingHashKey);
        }

        public final String getStartingHashKey() {
            return this.startingHashKey;
        }

        public final void setStartingHashKey(String startingHashKey) {
            this.startingHashKey = startingHashKey;
        }

        @Override
        public final Builder startingHashKey(String startingHashKey) {
            this.startingHashKey = startingHashKey;
            return this;
        }

        public final String getEndingHashKey() {
            return this.endingHashKey;
        }

        public final void setEndingHashKey(String endingHashKey) {
            this.endingHashKey = endingHashKey;
        }

        @Override
        public final Builder endingHashKey(String endingHashKey) {
            this.endingHashKey = endingHashKey;
            return this;
        }

        public HashKeyRange build() {
            return new HashKeyRange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HashKeyRange> {
        public Builder startingHashKey(String var1);

        public Builder endingHashKey(String var1);
    }
}

