/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.services.kinesis.model.StreamModeDetails;
import software.amazon.awssdk.services.kinesis.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStreamRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, CreateStreamRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(CreateStreamRequest.getter(CreateStreamRequest::streamName)).setter(CreateStreamRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<Integer> SHARD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ShardCount").getter(CreateStreamRequest.getter(CreateStreamRequest::shardCount)).setter(CreateStreamRequest.setter(Builder::shardCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardCount").build()}).build();
    private static final SdkField<StreamModeDetails> STREAM_MODE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamModeDetails").getter(CreateStreamRequest.getter(CreateStreamRequest::streamModeDetails)).setter(CreateStreamRequest.setter(Builder::streamModeDetails)).constructor(StreamModeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamModeDetails").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateStreamRequest.getter(CreateStreamRequest::tags)).setter(CreateStreamRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, SHARD_COUNT_FIELD, STREAM_MODE_DETAILS_FIELD, TAGS_FIELD));
    private final String streamName;
    private final Integer shardCount;
    private final StreamModeDetails streamModeDetails;
    private final Map<String, String> tags;

    private CreateStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.shardCount = builder.shardCount;
        this.streamModeDetails = builder.streamModeDetails;
        this.tags = builder.tags;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final Integer shardCount() {
        return this.shardCount;
    }

    public final StreamModeDetails streamModeDetails() {
        return this.streamModeDetails;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamModeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamRequest)) {
            return false;
        }
        CreateStreamRequest other = (CreateStreamRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.shardCount(), other.shardCount()) && Objects.equals(this.streamModeDetails(), other.streamModeDetails()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStreamRequest").add("StreamName", (Object)this.streamName()).add("ShardCount", (Object)this.shardCount()).add("StreamModeDetails", (Object)this.streamModeDetails()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "ShardCount": {
                return Optional.ofNullable(clazz.cast(this.shardCount()));
            }
            case "StreamModeDetails": {
                return Optional.ofNullable(clazz.cast(this.streamModeDetails()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamRequest, T> g) {
        return obj -> g.apply((CreateStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private Integer shardCount;
        private StreamModeDetails streamModeDetails;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.shardCount(model.shardCount);
            this.streamModeDetails(model.streamModeDetails);
            this.tags(model.tags);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final Integer getShardCount() {
            return this.shardCount;
        }

        public final void setShardCount(Integer shardCount) {
            this.shardCount = shardCount;
        }

        @Override
        public final Builder shardCount(Integer shardCount) {
            this.shardCount = shardCount;
            return this;
        }

        public final StreamModeDetails.Builder getStreamModeDetails() {
            return this.streamModeDetails != null ? this.streamModeDetails.toBuilder() : null;
        }

        public final void setStreamModeDetails(StreamModeDetails.BuilderImpl streamModeDetails) {
            this.streamModeDetails = streamModeDetails != null ? streamModeDetails.build() : null;
        }

        @Override
        public final Builder streamModeDetails(StreamModeDetails streamModeDetails) {
            this.streamModeDetails = streamModeDetails;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamRequest build() {
            return new CreateStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStreamRequest> {
        public Builder streamName(String var1);

        public Builder shardCount(Integer var1);

        public Builder streamModeDetails(StreamModeDetails var1);

        default public Builder streamModeDetails(Consumer<StreamModeDetails.Builder> streamModeDetails) {
            return this.streamModeDetails((StreamModeDetails)((StreamModeDetails.Builder)StreamModeDetails.builder().applyMutation(streamModeDetails)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

