/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.internal.UserAgentUtils;
import software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest;
import software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse;

public class ListStreamConsumersPublisher
implements SdkPublisher<ListStreamConsumersResponse> {
    private final KinesisAsyncClient client;
    private final ListStreamConsumersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStreamConsumersPublisher(KinesisAsyncClient client, ListStreamConsumersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStreamConsumersPublisher(KinesisAsyncClient client, ListStreamConsumersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStreamConsumersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStreamConsumersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListStreamConsumersResponseFetcher
    implements AsyncPageFetcher<ListStreamConsumersResponse> {
        private ListStreamConsumersResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamConsumersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStreamConsumersResponse> nextPage(ListStreamConsumersResponse previousPage) {
            if (previousPage == null) {
                return ListStreamConsumersPublisher.this.client.listStreamConsumers(ListStreamConsumersPublisher.this.firstRequest);
            }
            return ListStreamConsumersPublisher.this.client.listStreamConsumers((ListStreamConsumersRequest)((Object)ListStreamConsumersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

