/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ShardFilterType {
    AFTER_SHARD_ID("AFTER_SHARD_ID"),
    AT_TRIM_HORIZON("AT_TRIM_HORIZON"),
    FROM_TRIM_HORIZON("FROM_TRIM_HORIZON"),
    AT_LATEST("AT_LATEST"),
    AT_TIMESTAMP("AT_TIMESTAMP"),
    FROM_TIMESTAMP("FROM_TIMESTAMP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ShardFilterType> VALUE_MAP;
    private final String value;

    private ShardFilterType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ShardFilterType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ShardFilterType> knownValues() {
        EnumSet<ShardFilterType> knownValues = EnumSet.allOf(ShardFilterType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ShardFilterType.class, ShardFilterType::toString);
    }
}

