/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetShardIteratorRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, GetShardIteratorRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(GetShardIteratorRequest.getter(GetShardIteratorRequest::streamName)).setter(GetShardIteratorRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> SHARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShardId").getter(GetShardIteratorRequest.getter(GetShardIteratorRequest::shardId)).setter(GetShardIteratorRequest.setter(Builder::shardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardId").build()}).build();
    private static final SdkField<String> SHARD_ITERATOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShardIteratorType").getter(GetShardIteratorRequest.getter(GetShardIteratorRequest::shardIteratorTypeAsString)).setter(GetShardIteratorRequest.setter(Builder::shardIteratorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardIteratorType").build()}).build();
    private static final SdkField<String> STARTING_SEQUENCE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartingSequenceNumber").getter(GetShardIteratorRequest.getter(GetShardIteratorRequest::startingSequenceNumber)).setter(GetShardIteratorRequest.setter(Builder::startingSequenceNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingSequenceNumber").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(GetShardIteratorRequest.getter(GetShardIteratorRequest::timestamp)).setter(GetShardIteratorRequest.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(GetShardIteratorRequest.getter(GetShardIteratorRequest::streamARN)).setter(GetShardIteratorRequest.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, SHARD_ID_FIELD, SHARD_ITERATOR_TYPE_FIELD, STARTING_SEQUENCE_NUMBER_FIELD, TIMESTAMP_FIELD, STREAM_ARN_FIELD));
    private final String streamName;
    private final String shardId;
    private final String shardIteratorType;
    private final String startingSequenceNumber;
    private final Instant timestamp;
    private final String streamARN;

    private GetShardIteratorRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.shardId = builder.shardId;
        this.shardIteratorType = builder.shardIteratorType;
        this.startingSequenceNumber = builder.startingSequenceNumber;
        this.timestamp = builder.timestamp;
        this.streamARN = builder.streamARN;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final String shardId() {
        return this.shardId;
    }

    public final ShardIteratorType shardIteratorType() {
        return ShardIteratorType.fromValue(this.shardIteratorType);
    }

    public final String shardIteratorTypeAsString() {
        return this.shardIteratorType;
    }

    public final String startingSequenceNumber() {
        return this.startingSequenceNumber;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardIteratorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetShardIteratorRequest)) {
            return false;
        }
        GetShardIteratorRequest other = (GetShardIteratorRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.shardId(), other.shardId()) && Objects.equals(this.shardIteratorTypeAsString(), other.shardIteratorTypeAsString()) && Objects.equals(this.startingSequenceNumber(), other.startingSequenceNumber()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.streamARN(), other.streamARN());
    }

    public final String toString() {
        return ToString.builder((String)"GetShardIteratorRequest").add("StreamName", (Object)this.streamName()).add("ShardId", (Object)this.shardId()).add("ShardIteratorType", (Object)this.shardIteratorTypeAsString()).add("StartingSequenceNumber", (Object)this.startingSequenceNumber()).add("Timestamp", (Object)this.timestamp()).add("StreamARN", (Object)this.streamARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "ShardId": {
                return Optional.ofNullable(clazz.cast(this.shardId()));
            }
            case "ShardIteratorType": {
                return Optional.ofNullable(clazz.cast(this.shardIteratorTypeAsString()));
            }
            case "StartingSequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.startingSequenceNumber()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetShardIteratorRequest, T> g) {
        return obj -> g.apply((GetShardIteratorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String shardId;
        private String shardIteratorType;
        private String startingSequenceNumber;
        private Instant timestamp;
        private String streamARN;

        private BuilderImpl() {
        }

        private BuilderImpl(GetShardIteratorRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.shardId(model.shardId);
            this.shardIteratorType(model.shardIteratorType);
            this.startingSequenceNumber(model.startingSequenceNumber);
            this.timestamp(model.timestamp);
            this.streamARN(model.streamARN);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getShardId() {
            return this.shardId;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final String getShardIteratorType() {
            return this.shardIteratorType;
        }

        public final void setShardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
        }

        @Override
        public final Builder shardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
            return this;
        }

        @Override
        public final Builder shardIteratorType(ShardIteratorType shardIteratorType) {
            this.shardIteratorType(shardIteratorType == null ? null : shardIteratorType.toString());
            return this;
        }

        public final String getStartingSequenceNumber() {
            return this.startingSequenceNumber;
        }

        public final void setStartingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
        }

        @Override
        public final Builder startingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetShardIteratorRequest build() {
            return new GetShardIteratorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetShardIteratorRequest> {
        public Builder streamName(String var1);

        public Builder shardId(String var1);

        public Builder shardIteratorType(String var1);

        public Builder shardIteratorType(ShardIteratorType var1);

        public Builder startingSequenceNumber(String var1);

        public Builder timestamp(Instant var1);

        public Builder streamARN(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

