/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesis.model.Consumer;
import software.amazon.awssdk.services.kinesis.model.ConsumerListCopier;
import software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStreamConsumersResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, ListStreamConsumersResponse> {
    private static final SdkField<List<Consumer>> CONSUMERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Consumers").getter(ListStreamConsumersResponse.getter(ListStreamConsumersResponse::consumers)).setter(ListStreamConsumersResponse.setter(Builder::consumers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Consumers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Consumer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStreamConsumersResponse.getter(ListStreamConsumersResponse::nextToken)).setter(ListStreamConsumersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Consumer> consumers;
    private final String nextToken;

    private ListStreamConsumersResponse(BuilderImpl builder) {
        super(builder);
        this.consumers = builder.consumers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConsumers() {
        return this.consumers != null && !(this.consumers instanceof SdkAutoConstructList);
    }

    public final List<Consumer> consumers() {
        return this.consumers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConsumers() ? this.consumers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamConsumersResponse)) {
            return false;
        }
        ListStreamConsumersResponse other = (ListStreamConsumersResponse)((Object)obj);
        return this.hasConsumers() == other.hasConsumers() && Objects.equals(this.consumers(), other.consumers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStreamConsumersResponse").add("Consumers", this.hasConsumers() ? this.consumers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Consumers": {
                return Optional.ofNullable(clazz.cast(this.consumers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamConsumersResponse, T> g) {
        return obj -> g.apply((ListStreamConsumersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private List<Consumer> consumers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamConsumersResponse model) {
            super(model);
            this.consumers(model.consumers);
            this.nextToken(model.nextToken);
        }

        public final List<Consumer.Builder> getConsumers() {
            List<Consumer.Builder> result = ConsumerListCopier.copyToBuilder(this.consumers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConsumers(Collection<Consumer.BuilderImpl> consumers) {
            this.consumers = ConsumerListCopier.copyFromBuilder(consumers);
        }

        @Override
        public final Builder consumers(Collection<Consumer> consumers) {
            this.consumers = ConsumerListCopier.copy(consumers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumers(Consumer ... consumers) {
            this.consumers(Arrays.asList(consumers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumers(java.util.function.Consumer<Consumer.Builder> ... consumers) {
            this.consumers(Stream.of(consumers).map(c -> (Consumer)((Consumer.Builder)Consumer.builder().applyMutation((java.util.function.Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStreamConsumersResponse build() {
            return new ListStreamConsumersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStreamConsumersResponse> {
        public Builder consumers(Collection<Consumer> var1);

        public Builder consumers(Consumer ... var1);

        public Builder consumers(java.util.function.Consumer<Consumer.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

