/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.awssdk.services.kinesis.model.StreamDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStreamResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, DescribeStreamResponse> {
    private static final SdkField<StreamDescription> STREAM_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamDescription").getter(DescribeStreamResponse.getter(DescribeStreamResponse::streamDescription)).setter(DescribeStreamResponse.setter(Builder::streamDescription)).constructor(StreamDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_DESCRIPTION_FIELD));
    private final StreamDescription streamDescription;

    private DescribeStreamResponse(BuilderImpl builder) {
        super(builder);
        this.streamDescription = builder.streamDescription;
    }

    public final StreamDescription streamDescription() {
        return this.streamDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamResponse)) {
            return false;
        }
        DescribeStreamResponse other = (DescribeStreamResponse)((Object)obj);
        return Objects.equals(this.streamDescription(), other.streamDescription());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStreamResponse").add("StreamDescription", (Object)this.streamDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamDescription": {
                return Optional.ofNullable(clazz.cast(this.streamDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStreamResponse, T> g) {
        return obj -> g.apply((DescribeStreamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private StreamDescription streamDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamResponse model) {
            super(model);
            this.streamDescription(model.streamDescription);
        }

        public final StreamDescription.Builder getStreamDescription() {
            return this.streamDescription != null ? this.streamDescription.toBuilder() : null;
        }

        public final void setStreamDescription(StreamDescription.BuilderImpl streamDescription) {
            this.streamDescription = streamDescription != null ? streamDescription.build() : null;
        }

        @Override
        public final Builder streamDescription(StreamDescription streamDescription) {
            this.streamDescription = streamDescription;
            return this;
        }

        @Override
        public DescribeStreamResponse build() {
            return new DescribeStreamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStreamResponse> {
        public Builder streamDescription(StreamDescription var1);

        default public Builder streamDescription(Consumer<StreamDescription.Builder> streamDescription) {
            return this.streamDescription((StreamDescription)((StreamDescription.Builder)StreamDescription.builder().applyMutation(streamDescription)).build());
        }
    }
}

