/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.services.kinesis.waiters.KinesisWaiter;
import software.amazon.awssdk.services.kinesis.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultKinesisWaiter
implements KinesisWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final KinesisClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeStreamResponse> streamExistsWaiter;
    private final Waiter<DescribeStreamResponse> streamNotExistsWaiter;

    private DefaultKinesisWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (KinesisClient)KinesisClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.streamExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeStreamResponse.class).acceptors(DefaultKinesisWaiter.streamExistsWaiterAcceptors())).overrideConfiguration(DefaultKinesisWaiter.streamExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.streamNotExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeStreamResponse.class).acceptors(DefaultKinesisWaiter.streamNotExistsWaiterAcceptors())).overrideConfiguration(DefaultKinesisWaiter.streamNotExistsWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeStreamResponse> waitUntilStreamExists(DescribeStreamRequest describeStreamRequest) {
        return this.streamExistsWaiter.run(() -> this.client.describeStream(this.applyWaitersUserAgent(describeStreamRequest)));
    }

    @Override
    public WaiterResponse<DescribeStreamResponse> waitUntilStreamExists(DescribeStreamRequest describeStreamRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamExistsWaiter.run(() -> this.client.describeStream(this.applyWaitersUserAgent(describeStreamRequest)), DefaultKinesisWaiter.streamExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeStreamResponse> waitUntilStreamNotExists(DescribeStreamRequest describeStreamRequest) {
        return this.streamNotExistsWaiter.run(() -> this.client.describeStream(this.applyWaitersUserAgent(describeStreamRequest)));
    }

    @Override
    public WaiterResponse<DescribeStreamResponse> waitUntilStreamNotExists(DescribeStreamRequest describeStreamRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamNotExistsWaiter.run(() -> this.client.describeStream(this.applyWaitersUserAgent(describeStreamRequest)), DefaultKinesisWaiter.streamNotExistsWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeStreamResponse>> streamExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStreamResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStreamResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("StreamDescription").field("StreamStatus").value(), "ACTIVE");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeStreamResponse>> streamNotExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStreamResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStreamResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultKinesisWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration streamExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(18);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamNotExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(18);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static KinesisWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends KinesisRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((KinesisRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements KinesisWaiter.Builder {
        private KinesisClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public KinesisWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public KinesisWaiter.Builder client(KinesisClient client) {
            this.client = client;
            return this;
        }

        @Override
        public KinesisWaiter build() {
            return new DefaultKinesisWaiter(this);
        }
    }
}

